/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.Collection;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.MappingType;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.CollectionExpression;
import org.datanucleus.store.rdbms.sql.expression.CollectionLiteral;
import org.datanucleus.store.rdbms.sql.expression.EnumExpression;
import org.datanucleus.store.rdbms.sql.expression.IllegalExpressionOperationException;
import org.datanucleus.store.rdbms.sql.expression.InExpression;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;
import org.datanucleus.store.rdbms.sql.expression.UnboundExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class CollectionContainsMethod
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        Class elementType;
        if (args == null || args.size() == 0 || args.size() > 1) {
            throw new NucleusException(Localiser.msg((String)"060016", (Object[])new Object[]{"contains", "CollectionExpression", 1}));
        }
        CollectionExpression collExpr = (CollectionExpression)expr;
        AbstractMemberMetaData mmd = collExpr.getJavaTypeMapping().getMemberMetaData();
        SQLExpression elemExpr = args.get(0);
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        if (elemExpr.isParameter() && mmd != null && mmd.getCollection() != null) {
            Class elementCls = stmt.getQueryGenerator().getClassLoaderResolver().classForName(mmd.getCollection().getElementType());
            stmt.getQueryGenerator().bindParameter(elemExpr.getParameterName(), elementCls);
        }
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        if (collExpr instanceof CollectionLiteral) {
            CollectionLiteral lit = (CollectionLiteral)collExpr;
            Collection coll = (Collection)lit.getValue();
            JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
            if (coll == null || coll.isEmpty()) {
                return exprFactory.newLiteral(stmt, m, true).eq(exprFactory.newLiteral(stmt, m, false));
            }
            if (collExpr.isParameter()) {
                stmt.getQueryGenerator().useParameterExpressionAsLiteral((CollectionLiteral)collExpr);
            }
            boolean useInExpression = false;
            List<SQLExpression> collElementExprs = lit.getElementExpressions();
            if (collElementExprs != null && !collElementExprs.isEmpty()) {
                SQLExpression collElementExpr2;
                boolean incompatible = true;
                Class elemtype = clr.classForName(elemExpr.getJavaTypeMapping().getType());
                for (SQLExpression collElementExpr2 : collElementExprs) {
                    Class collElemType = clr.classForName(collElementExpr2.getJavaTypeMapping().getType());
                    if (!this.elementTypeCompatible(elemtype, collElemType)) continue;
                    incompatible = false;
                    break;
                }
                if (incompatible) {
                    return exprFactory.newLiteral(stmt, m, true).eq(exprFactory.newLiteral(stmt, m, false));
                }
                collElementExpr2 = collElementExprs.get(0);
                if (collElementExpr2 instanceof StringExpression || collElementExpr2 instanceof NumericExpression || collElementExpr2 instanceof TemporalExpression || collElementExpr2 instanceof CharacterExpression || collElementExpr2 instanceof EnumExpression) {
                    useInExpression = true;
                }
            }
            if (useInExpression) {
                SQLExpression[] exprs = collElementExprs != null ? collElementExprs.toArray(new SQLExpression[collElementExprs.size()]) : null;
                return new InExpression(elemExpr, exprs);
            }
            SQLExpression bExpr = null;
            if (collElementExprs != null) {
                for (int i = 0; i < collElementExprs.size(); ++i) {
                    bExpr = bExpr == null ? collElementExprs.get(i).eq(elemExpr) : ((BooleanExpression)bExpr).ior(collElementExprs.get(i).eq(elemExpr));
                }
            }
            if (bExpr != null) {
                bExpr.encloseInParentheses();
            }
            return bExpr;
        }
        if (mmd == null) {
            throw new NucleusUserException("Cannot perform Collection.contains when the field metadata is not provided");
        }
        if (mmd.isSerialized()) {
            throw new NucleusUserException("Cannot perform Collection.contains when the collection is being serialised");
        }
        ApiAdapter api = stmt.getRDBMSManager().getApiAdapter();
        if (!api.isPersistable(elementType = clr.classForName(mmd.getCollection().getElementType())) && mmd.getJoinMetaData() == null) {
            throw new NucleusUserException("Cannot perform Collection.contains when the collection<Non-Persistable> is not in a join table");
        }
        if (stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.FILTER) {
            boolean useSubquery = this.getNeedsSubquery(stmt, collExpr, elemExpr);
            SQLJoin.JoinType joinType = SQLJoin.JoinType.INNER_JOIN;
            if (elemExpr instanceof UnboundExpression) {
                String varName = ((UnboundExpression)elemExpr).getVariableName();
                String extensionName = "datanucleus.query.jdoql." + varName + ".join";
                String extensionValue = (String)stmt.getQueryGenerator().getValueForExtension(extensionName);
                if (extensionValue != null) {
                    if (extensionValue.equalsIgnoreCase("SUBQUERY")) {
                        useSubquery = true;
                    } else if (extensionValue.equalsIgnoreCase("INNERJOIN")) {
                        useSubquery = false;
                    } else if (extensionValue.equalsIgnoreCase("LEFTOUTERJOIN")) {
                        joinType = SQLJoin.JoinType.LEFT_OUTER_JOIN;
                    }
                }
            }
            if (useSubquery) {
                return this.containsAsSubquery(stmt, collExpr, elemExpr);
            }
            return this.containsAsJoin(stmt, collExpr, elemExpr, joinType);
        }
        return this.containsAsSubquery(stmt, collExpr, elemExpr);
    }

    protected boolean getNeedsSubquery(SQLStatement stmt, SQLExpression collExpr, SQLExpression elemExpr) {
        Boolean hasNOT;
        if (elemExpr instanceof UnboundExpression) {
            NucleusLogger.QUERY.debug((Object)(">> collection.contains collExpr=" + collExpr + " elemExpr=" + elemExpr + " elem.variable=" + ((UnboundExpression)elemExpr).getVariableName() + " need to implement check on whether there is a !coll or an OR using just this variable"));
        }
        boolean needsSubquery = false;
        Boolean hasOR = (Boolean)stmt.getQueryGenerator().getProperty("Filter.OR");
        if (hasOR != null && hasOR.booleanValue()) {
            needsSubquery = true;
        }
        if ((hasNOT = (Boolean)stmt.getQueryGenerator().getProperty("Filter.NOT")) != null && hasNOT.booleanValue()) {
            needsSubquery = true;
        }
        return needsSubquery;
    }

    protected SQLExpression containsAsJoin(SQLStatement stmt, CollectionExpression collExpr, SQLExpression elemExpr, SQLJoin.JoinType joinType) {
        Class varType;
        boolean elemIsUnbound = elemExpr instanceof UnboundExpression;
        String varName = null;
        String elemAlias = null;
        String elemType = null;
        if (elemIsUnbound) {
            varName = ((UnboundExpression)elemExpr).getVariableName();
            NucleusLogger.QUERY.debug((Object)("collection.contains(" + elemExpr + ") binding unbound variable " + varName + " using INNER JOIN"));
        } else if (!stmt.getQueryGenerator().hasExplicitJoins() && stmt.getJoinTypeForTable(elemExpr.getSQLTable()) == SQLJoin.JoinType.CROSS_JOIN) {
            elemAlias = stmt.removeCrossJoin(elemExpr.getSQLTable());
            elemIsUnbound = true;
            elemType = elemExpr.getJavaTypeMapping().getType();
            NucleusLogger.QUERY.debug((Object)("collection.contains(" + elemExpr + ") was previously bound as CROSS JOIN but changing to INNER JOIN"));
        }
        RDBMSStoreManager storeMgr = stmt.getRDBMSManager();
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        AbstractMemberMetaData mmd = collExpr.getJavaTypeMapping().getMemberMetaData();
        AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr);
        CollectionTable joinTbl = (CollectionTable)storeMgr.getTable(mmd);
        if (elemIsUnbound && (varType = stmt.getQueryGenerator().getTypeOfVariable(varName)) != null) {
            elemType = varType.getName();
            elemCmd = storeMgr.getMetaDataManager().getMetaDataForClass(elemType, clr);
        }
        if (elemType == null) {
            elemType = mmd.getCollection().getElementType();
        }
        if (joinTbl != null) {
            SQLTable joinSqlTbl;
            if (elemCmd == null) {
                joinSqlTbl = stmt.join(joinType, collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping(), joinTbl, elemAlias, joinTbl.getOwnerMapping(), null, null);
                SQLExpression elemIdExpr = exprFactory.newExpression(stmt, joinSqlTbl, joinTbl.getElementMapping());
                if (elemIsUnbound) {
                    stmt.getQueryGenerator().bindVariable(varName, null, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                } else {
                    this.addRestrictionOnElement(stmt, elemIdExpr, elemExpr);
                }
            } else {
                joinSqlTbl = stmt.join(joinType, collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                if (!mmd.getCollection().isEmbeddedElement()) {
                    DatastoreClass elemTbl = storeMgr.getDatastoreClass(elemType, clr);
                    SQLTable elemSqlTbl = null;
                    if (joinTbl.getElementMapping() instanceof ReferenceMapping && ((ReferenceMapping)joinTbl.getElementMapping()).getMappingStrategy() == 0) {
                        JavaTypeMapping elemMapping = null;
                        JavaTypeMapping[] elemImplMappings = ((ReferenceMapping)joinTbl.getElementMapping()).getJavaTypeMapping();
                        for (int i = 0; i < elemImplMappings.length; ++i) {
                            if (!elemImplMappings[i].getType().equals(elemCmd.getFullClassName())) continue;
                            elemMapping = elemImplMappings[i];
                            break;
                        }
                        elemSqlTbl = stmt.join(joinType, joinSqlTbl, elemMapping, joinTbl.getElementMapping(), elemTbl, elemAlias, elemTbl.getIdMapping(), null, null, null, true, null);
                    } else {
                        elemSqlTbl = stmt.join(joinType, joinSqlTbl, joinTbl.getElementMapping(), elemTbl, elemAlias, elemTbl.getIdMapping(), null, null);
                    }
                    SQLExpression elemIdExpr = exprFactory.newExpression(stmt, elemSqlTbl, elemTbl.getIdMapping());
                    if (elemIsUnbound) {
                        stmt.getQueryGenerator().bindVariable(varName, elemCmd, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                    } else {
                        this.addRestrictionOnElement(stmt, elemIdExpr, elemExpr);
                    }
                } else {
                    SQLExpression elemIdExpr = exprFactory.newExpression(stmt, joinSqlTbl, joinTbl.getElementMapping());
                    if (elemIsUnbound) {
                        stmt.getQueryGenerator().bindVariable(varName, elemCmd, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                    } else {
                        this.addRestrictionOnElement(stmt, elemIdExpr, elemExpr);
                    }
                }
            }
        } else {
            DatastoreClass elemTbl = storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), clr);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? elemTbl.getMemberMapping(mmd.getRelatedMemberMetaData(clr)[0]) : elemTbl.getExternalMapping(mmd, MappingType.EXTERNAL_FK);
            SQLTable elemSqlTbl = stmt.join(joinType, collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping(), elemTbl, elemAlias, ownerMapping, null, null);
            if (elemIsUnbound) {
                SQLExpression elemIdExpr = null;
                if (!elemType.equals(mmd.getCollection().getElementType())) {
                    DatastoreClass varTbl = storeMgr.getDatastoreClass(elemType, clr);
                    SQLTable varSqlTbl = stmt.join(joinType, elemSqlTbl, elemTbl.getIdMapping(), varTbl, null, varTbl.getIdMapping(), null, null);
                    elemIdExpr = exprFactory.newExpression(stmt, varSqlTbl, varTbl.getIdMapping());
                } else {
                    elemIdExpr = exprFactory.newExpression(stmt, elemSqlTbl, elemTbl.getIdMapping());
                }
                stmt.getQueryGenerator().bindVariable(varName, elemCmd, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
            } else {
                SQLExpression elemIdExpr = exprFactory.newExpression(stmt, elemSqlTbl, elemTbl.getIdMapping());
                this.addRestrictionOnElement(stmt, elemIdExpr, elemExpr);
            }
        }
        JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
        return exprFactory.newLiteral(stmt, m, true).eq(exprFactory.newLiteral(stmt, m, true));
    }

    protected SQLExpression containsAsSubquery(SQLStatement stmt, CollectionExpression collExpr, SQLExpression elemExpr) {
        Class varType;
        boolean elemIsUnbound = elemExpr instanceof UnboundExpression;
        String varName = null;
        if (elemIsUnbound) {
            varName = ((UnboundExpression)elemExpr).getVariableName();
            NucleusLogger.QUERY.debug((Object)("collection.contains(" + elemExpr + ") binding unbound variable " + varName + " using SUBQUERY"));
        }
        RDBMSStoreManager storeMgr = stmt.getRDBMSManager();
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        AbstractMemberMetaData mmd = collExpr.getJavaTypeMapping().getMemberMetaData();
        AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr);
        CollectionTable joinTbl = (CollectionTable)storeMgr.getTable(mmd);
        String elemType = mmd.getCollection().getElementType();
        if (elemIsUnbound && (varType = stmt.getQueryGenerator().getTypeOfVariable(varName)) != null) {
            elemType = varType.getName();
            elemCmd = storeMgr.getMetaDataManager().getMetaDataForClass(elemType, clr);
        }
        SelectStatement subStmt = null;
        if (joinTbl != null) {
            if (elemCmd == null) {
                subStmt = new SelectStatement(stmt, storeMgr, joinTbl, null, null);
                subStmt.setClassLoaderResolver(clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
                SQLExpression ownerIdExpr = exprFactory.newExpression(stmt, collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                SQLExpression elemIdExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), joinTbl.getElementMapping());
                if (elemIsUnbound) {
                    stmt.getQueryGenerator().bindVariable(varName, null, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                } else {
                    this.addRestrictionOnElement(subStmt, elemIdExpr, elemExpr);
                }
            } else {
                DatastoreClass elemTbl = storeMgr.getDatastoreClass(elemType, clr);
                subStmt = new SelectStatement(stmt, storeMgr, elemTbl, null, null);
                subStmt.setClassLoaderResolver(clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLTable joinSqlTbl = subStmt.join(SQLJoin.JoinType.INNER_JOIN, subStmt.getPrimaryTable(), elemTbl.getIdMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null, true, null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = exprFactory.newExpression(subStmt, joinSqlTbl, ownerMapping);
                SQLExpression ownerIdExpr = exprFactory.newExpression(stmt, collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                SQLExpression elemIdExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), elemTbl.getIdMapping());
                if (elemIsUnbound) {
                    stmt.getQueryGenerator().bindVariable(varName, elemCmd, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                } else {
                    this.addRestrictionOnElement(subStmt, elemIdExpr, elemExpr);
                }
            }
        } else {
            DatastoreClass elemTbl = storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), clr);
            subStmt = new SelectStatement(stmt, storeMgr, elemTbl, null, null);
            subStmt.setClassLoaderResolver(clr);
            JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
            subStmt.select(exprFactory.newLiteral(subStmt, oneMapping, 1), null);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? elemTbl.getMemberMapping(mmd.getRelatedMemberMetaData(clr)[0]) : elemTbl.getExternalMapping(mmd, MappingType.EXTERNAL_FK);
            SQLExpression ownerExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
            SQLExpression ownerIdExpr = exprFactory.newExpression(stmt, collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping());
            subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
            if (elemIsUnbound) {
                SQLExpression elemIdExpr = null;
                if (!elemType.equals(mmd.getCollection().getElementType())) {
                    DatastoreClass varTbl = storeMgr.getDatastoreClass(elemType, clr);
                    SQLTable varSqlTbl = subStmt.join(SQLJoin.JoinType.INNER_JOIN, subStmt.getPrimaryTable(), elemTbl.getIdMapping(), null, varTbl, null, varTbl.getIdMapping(), null, null, null, true, null);
                    elemIdExpr = exprFactory.newExpression(subStmt, varSqlTbl, varTbl.getIdMapping());
                } else {
                    elemIdExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), elemTbl.getIdMapping());
                }
                stmt.getQueryGenerator().bindVariable(varName, elemCmd, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
            } else {
                SQLExpression elemIdExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), elemTbl.getIdMapping());
                this.addRestrictionOnElement(subStmt, elemIdExpr, elemExpr);
            }
        }
        return new BooleanSubqueryExpression(stmt, "EXISTS", subStmt);
    }

    protected void addRestrictionOnElement(SQLStatement stmt, SQLExpression elemIdExpr, SQLExpression elemExpr) {
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        try {
            stmt.whereAnd(elemIdExpr.eq(elemExpr), true);
        }
        catch (IllegalExpressionOperationException ieoe) {
            NucleusLogger.QUERY.warn((Object)("Collection.contains element expression supplied is inconsistent with element type of this collection : " + ieoe.getMessage()));
            JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
            BooleanExpression notContainedExpr = exprFactory.newLiteral(stmt, m, false).eq(exprFactory.newLiteral(stmt, m, true));
            stmt.whereAnd(notContainedExpr, true);
        }
    }

    protected boolean elementTypeCompatible(Class elementType, Class collectionElementType) {
        if (!elementType.isPrimitive() && collectionElementType.isPrimitive() && !collectionElementType.isAssignableFrom(elementType) && !elementType.isAssignableFrom(collectionElementType)) {
            return false;
        }
        if (elementType.isPrimitive()) {
            if (elementType == Boolean.TYPE && collectionElementType == Boolean.class) {
                return true;
            }
            if (elementType == Byte.TYPE && collectionElementType == Byte.class) {
                return true;
            }
            if (elementType == Character.TYPE && collectionElementType == Character.class) {
                return true;
            }
            if (elementType == Double.TYPE && collectionElementType == Double.class) {
                return true;
            }
            if (elementType == Float.TYPE && collectionElementType == Float.class) {
                return true;
            }
            if (elementType == Integer.TYPE && collectionElementType == Integer.class) {
                return true;
            }
            if (elementType == Long.TYPE && collectionElementType == Long.class) {
                return true;
            }
            return elementType == Short.TYPE && collectionElementType == Short.class;
        }
        return true;
    }
}

