/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.jee.rest.exception.treatment;

import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.demoiselle.jee.core.exception.ExceptionTreatment;
import org.demoiselle.jee.rest.DemoiselleRestConfig;
import org.demoiselle.jee.rest.exception.DemoiselleRestException;
import org.demoiselle.jee.rest.message.DemoiselleRESTMessage;

public class ExceptionTreatmentImpl
implements ExceptionTreatment {
    private static final Logger logger = Logger.getLogger(ExceptionTreatmentImpl.class.getName());
    private final String FIELDNAME_ERROR = "error";
    private final String FIELDNAME_ERROR_DESCRIPTION = "error_description";
    private final String FIELDNAME_ERROR_LINK = "error_link";
    private final String DATABASE_SQL_STATE = "sql_state";
    private final String DATABASE_MASSAGE = "error_message";
    private final String DATABASE_ERROR_CODE = "error_code";
    @Inject
    private DemoiselleRESTMessage messages;
    @Inject
    private DemoiselleRestConfig config;

    public Response getFormatedError(Throwable exception, HttpServletRequest request) {
        boolean isShowErrorDetails = this.config.isShowErrorDetails();
        MediaType responseMediaType = MediaType.APPLICATION_JSON_TYPE;
        if (request.getHeader("content-type") != null) {
            responseMediaType = MediaType.valueOf((String)request.getHeader("content-type"));
        }
        if (exception.getCause() != null && exception.getCause() instanceof DemoiselleRestException) {
            exception = (Exception)exception.getCause();
        }
        ArrayList arrayErrors = new ArrayList();
        if (exception instanceof ConstraintViolationException) {
            ConstraintViolationException c = (ConstraintViolationException)exception;
            c.getConstraintViolations().stream().forEach(violation -> {
                String objectType = violation.getLeafBean().getClass().getSimpleName();
                String arg = "arg0";
                String pathConverted = violation.getPropertyPath().toString().replaceAll(arg, objectType);
                ConcurrentHashMap<String, String> object = new ConcurrentHashMap<String, String>();
                object.put("error", pathConverted);
                object.put("error_description", violation.getMessage());
                logger.log(Level.FINEST, violation.getMessage());
                arrayErrors.add(object);
            });
            return this.buildResponse(arrayErrors, responseMediaType, Response.Status.PRECONDITION_FAILED);
        }
        SQLException sqlException = this.getSQLExceptionInException(exception);
        if (sqlException != null) {
            ConcurrentHashMap<String, Object> sqlError = new ConcurrentHashMap<String, Object>();
            Integer errorCode = sqlException.getErrorCode();
            sqlError.put("sql_state", sqlException.getSQLState());
            sqlError.put("error_code", errorCode);
            sqlError.put("error_message", sqlException.getMessage());
            ConcurrentHashMap<String, Object> object2 = new ConcurrentHashMap<String, Object>();
            if (isShowErrorDetails) {
                object2.put("error_description", sqlError);
            }
            if (this.config.getSqlError().get(errorCode.toString()) != null) {
                object2.put("error", this.config.getSqlError().get(errorCode.toString()));
            } else if (exception.getMessage() != null && !exception.getMessage().isEmpty()) {
                object2.put("error", exception.getMessage());
            } else {
                object2.put("error", this.messages.unhandledDatabaseException());
            }
            arrayErrors.add(object2);
            return this.buildResponse(arrayErrors, responseMediaType, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (exception instanceof DemoiselleRestException) {
            DemoiselleRestException e = (DemoiselleRestException)((Object)exception);
            if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                ConcurrentHashMap<String, Object> object3 = new ConcurrentHashMap<String, Object>();
                object3.put("error", e.getMessage());
                object3.put("error_description", this.unwrapException(exception));
                arrayErrors.add(object3);
            }
            e.getMessages().stream().map(message -> {
                ConcurrentHashMap<String, String> object = new ConcurrentHashMap<String, String>();
                object.put("error", message.getError());
                if (isShowErrorDetails) {
                    object.put("error_description", message.getError_description());
                }
                if (message.getError_link() != null && !message.getError_link().isEmpty()) {
                    object.put("error_link", message.getError_link());
                }
                return object;
            }).forEachOrdered(object -> arrayErrors.add(object));
            Response.Status statusCode = Response.Status.PRECONDITION_FAILED;
            if (e.getStatusCode() != 0) {
                statusCode = Response.Status.fromStatusCode((int)e.getStatusCode());
            }
            if (this.config.isShowErrorDetails()) {
                if (exception.getMessage() != null) {
                    logger.log(Level.WARNING, exception.getMessage());
                }
                if (exception.getCause() != null && exception.getCause().getMessage() != null) {
                    logger.log(Level.WARNING, exception.getCause().getMessage());
                }
            }
            return this.buildResponse(arrayErrors, responseMediaType, statusCode);
        }
        if (exception instanceof InvalidFormatException) {
            ConcurrentHashMap<String, Object> object4 = new ConcurrentHashMap<String, Object>();
            object4.put("error", this.messages.unhandledMalformedInputOutputException());
            if (isShowErrorDetails) {
                object4.put("error_description", this.unwrapException(exception));
            }
            arrayErrors.add(object4);
            return this.buildResponse(arrayErrors, responseMediaType, Response.Status.BAD_REQUEST);
        }
        if (exception instanceof ClientErrorException) {
            ClientErrorException exClient = (ClientErrorException)exception;
            ConcurrentHashMap<String, Object> object5 = new ConcurrentHashMap<String, Object>();
            object5.put("error", this.messages.httpException());
            if (isShowErrorDetails) {
                object5.put("error_description", this.unwrapException(exception));
            }
            arrayErrors.add(object5);
            return this.buildResponse(arrayErrors, responseMediaType, (Response.Status)exClient.getResponse().getStatusInfo());
        }
        ConcurrentHashMap<String, Object> object6 = new ConcurrentHashMap<String, Object>();
        object6.put("error", this.messages.unhandledServerException());
        if (isShowErrorDetails) {
            object6.put("error_description", this.unwrapException(exception));
        }
        arrayErrors.add(object6);
        return this.buildResponse(arrayErrors, responseMediaType, Response.Status.INTERNAL_SERVER_ERROR);
    }

    private SQLException getSQLExceptionInException(Throwable ex) {
        Throwable current = ex;
        do {
            if (!(current instanceof SQLException)) continue;
            return (SQLException)current;
        } while ((current = current.getCause()) != null);
        return null;
    }

    private Response buildResponse(Object entity, MediaType mediaType, Response.Status status) {
        Response.ResponseBuilder builder = Response.status((Response.Status)status).entity(entity);
        builder.type(mediaType);
        return builder.build();
    }

    private ArrayList<String> unwrapException(Throwable t) {
        ArrayList<String> array = new ArrayList<String>();
        this.doUnwrapException(array, t);
        return array;
    }

    private void doUnwrapException(ArrayList<String> array, Throwable t) {
        if (t == null) {
            return;
        }
        array.add(t.getMessage());
        if (t.getCause() != null && t != t.getCause()) {
            this.doUnwrapException(array, t.getCause());
        }
    }
}

