/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.util.StringUtils;
import org.drools.lang.descr.BaseDescr;
import org.drools.rule.Declaration;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.rule.builder.dialect.java.JavaDialect;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.SimpleTemplateRegistry;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRegistry;
import org.mvel2.templates.TemplateRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractJavaRuleBuilder {
    protected static final TemplateRegistry RULE_REGISTRY = new SimpleTemplateRegistry();
    protected static final TemplateRegistry INVOKER_REGISTRY = new SimpleTemplateRegistry();

    public static synchronized TemplateRegistry getRuleTemplateRegistry(ClassLoader cl) {
        if (!RULE_REGISTRY.contains("rules")) {
            ParserConfiguration pconf = new ParserConfiguration();
            pconf.setClassLoader(cl);
            ParserContext pctx = new ParserContext(pconf);
            RULE_REGISTRY.addNamedTemplate("rules", TemplateCompiler.compileTemplate((InputStream)AbstractJavaRuleBuilder.class.getResourceAsStream("javaRule.mvel"), (ParserContext)pctx));
            TemplateRuntime.execute((CompiledTemplate)RULE_REGISTRY.getNamedTemplate("rules"), null, (TemplateRegistry)RULE_REGISTRY);
        }
        return RULE_REGISTRY;
    }

    public static synchronized TemplateRegistry getInvokerTemplateRegistry(ClassLoader cl) {
        if (!INVOKER_REGISTRY.contains("invokers")) {
            ParserConfiguration pconf = new ParserConfiguration();
            pconf.setClassLoader(cl);
            ParserContext pctx = new ParserContext(pconf);
            INVOKER_REGISTRY.addNamedTemplate("invokers", TemplateCompiler.compileTemplate((InputStream)AbstractJavaRuleBuilder.class.getResourceAsStream("javaInvokers.mvel"), (ParserContext)pctx));
            TemplateRuntime.execute((CompiledTemplate)INVOKER_REGISTRY.getNamedTemplate("invokers"), null, (TemplateRegistry)INVOKER_REGISTRY);
        }
        return INVOKER_REGISTRY;
    }

    public Map<String, Object> createVariableContext(String className, String text, RuleBuildContext context, Declaration[] declarations, Declaration[] localDeclarations, Map<String, Class<?>> globals, JavaAnalysisResult analysis) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("methodName", className);
        map.put("package", context.getPkg().getName());
        map.put("ruleClassName", StringUtils.ucFirst((String)context.getRuleDescr().getClassName()));
        map.put("invokerClassName", context.getRuleDescr().getClassName() + StringUtils.ucFirst((String)className) + "Invoker");
        if (text != null) {
            map.put("text", text);
            map.put("hashCode", new Integer(text.hashCode()));
        }
        String[] declarationTypes = new String[declarations.length];
        int size = declarations.length;
        for (int i = 0; i < size; ++i) {
            declarationTypes[i] = ((JavaDialect)context.getDialect()).getTypeFixer().fix(declarations[i]);
            if (declarationTypes[i] != null) continue;
            declarationTypes[i] = "java.lang.Object";
        }
        map.put("declarations", declarations);
        map.put("declarationTypes", declarationTypes);
        if (localDeclarations != null) {
            String[] localDeclarationTypes = new String[localDeclarations.length];
            int size2 = localDeclarations.length;
            for (int i = 0; i < size2; ++i) {
                localDeclarationTypes[i] = ((JavaDialect)context.getDialect()).getTypeFixer().fix(localDeclarations[i]);
            }
            map.put("localDeclarations", localDeclarations);
            map.put("localDeclarationTypes", localDeclarationTypes);
        }
        String[] globalStr = new String[globals.size()];
        String[] globalTypes = new String[globals.size()];
        int i = 0;
        for (Map.Entry<String, Class<?>> entry : globals.entrySet()) {
            globalStr[i] = entry.getKey();
            globalTypes[i] = entry.getValue().getName().replace('$', '.');
            ++i;
        }
        map.put("globals", globalStr);
        map.put("globalTypes", globalTypes);
        return map;
    }

    public static void generatTemplates(String ruleTemplate, String invokerTemplate, RuleBuildContext context, String className, Map vars, Object invokerLookup, BaseDescr descrLookup) {
        TemplateRegistry registry = AbstractJavaRuleBuilder.getRuleTemplateRegistry((ClassLoader)context.getPackageBuilder().getRootClassLoader());
        context.getMethods().add(TemplateRuntime.execute((CompiledTemplate)registry.getNamedTemplate(ruleTemplate), null, (VariableResolverFactory)new MapVariableResolverFactory(vars), (TemplateRegistry)registry));
        registry = AbstractJavaRuleBuilder.getInvokerTemplateRegistry((ClassLoader)context.getPackageBuilder().getRootClassLoader());
        String invokerClassName = context.getPkg().getName() + "." + context.getRuleDescr().getClassName() + StringUtils.ucFirst((String)className) + "Invoker";
        context.getInvokers().put(invokerClassName, TemplateRuntime.execute((CompiledTemplate)registry.getNamedTemplate(invokerTemplate), null, (VariableResolverFactory)new MapVariableResolverFactory(vars), (TemplateRegistry)registry));
        context.getInvokerLookups().put(invokerClassName, invokerLookup);
        context.getDescrLookups().put(invokerClassName, descrLookup);
    }
}

