/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.conf.AssertBehaviorOption;
import org.drools.conf.EventProcessingOption;
import org.drools.kproject.KBase;
import org.drools.kproject.KProjectImpl;
import org.drools.kproject.KSession;
import org.drools.kproject.KSessionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KBaseImpl
implements KBase {
    private String namespace;
    private String name;
    private Set<String> includes;
    private List<String> files;
    private List<String> annotations;
    private AssertBehaviorOption equalsBehavior;
    private EventProcessingOption eventProcessingMode;
    private Map<String, KSession> kSessions;
    private KProjectImpl kProject;
    private transient PropertyChangeListener listener;

    public KBaseImpl(KProjectImpl kProject, String namespace, String name) {
        this.kProject = kProject;
        this.namespace = namespace;
        this.includes = new HashSet<String>();
        this.name = name;
        this.files = new ArrayList<String>();
        this.kSessions = Collections.emptyMap();
    }

    public KProjectImpl getKProject() {
        return this.kProject;
    }

    @Override
    public Map<String, KSession> getKSessions() {
        return Collections.unmodifiableMap(this.kSessions);
    }

    private void setKSessions(Map<String, KSession> kSessions) {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "kSessions", this.kSessions, kSessions));
            for (KSession ksession : kSessions.values()) {
                ksession.setListener(this.listener);
            }
        }
        this.kSessions = kSessions;
    }

    @Override
    public KSession newKSession(String namespace, String name) {
        KSessionImpl kSession = new KSessionImpl(this, namespace, name);
        HashMap<String, KSession> newMap = new HashMap<String, KSession>();
        newMap.putAll(this.kSessions);
        newMap.put(kSession.getQName(), kSession);
        this.setKSessions(newMap);
        return kSession;
    }

    @Override
    public KBase removeKSession(String qName) {
        HashMap<String, KSession> newMap = new HashMap<String, KSession>();
        newMap.putAll(this.kSessions);
        newMap.remove(qName);
        this.setKSessions(newMap);
        return this;
    }

    public void moveKSession(String oldQName, String newQName) {
        HashMap<String, KSession> newMap = new HashMap<String, KSession>();
        newMap.putAll(this.kSessions);
        KSession kSession = (KSession)newMap.remove(oldQName);
        newMap.put(newQName, kSession);
        this.setKSessions(newMap);
    }

    @Override
    public PropertyChangeListener getListener() {
        return this.listener;
    }

    @Override
    public KBase setListener(PropertyChangeListener listener) {
        this.listener = listener;
        for (KSession ksession : this.kSessions.values()) {
            ksession.setListener(listener);
        }
        return this;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public KBase setNamespace(String namespace) {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "namespace", this.namespace, namespace));
        }
        this.namespace = namespace;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public KBase setName(String name) {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "name", this.name, name));
        }
        this.name = name;
        return this;
    }

    @Override
    public String getQName() {
        return this.namespace + "." + this.name;
    }

    @Override
    public Set<String> getIncludes() {
        return Collections.unmodifiableSet(this.includes);
    }

    @Override
    public KBase addInclude(String kBaseQName) {
        this.includes.add(kBaseQName);
        return this;
    }

    @Override
    public KBase removeInclude(String kBaseQName) {
        this.includes.remove(kBaseQName);
        return this;
    }

    @Override
    public List<String> getFiles() {
        return this.files;
    }

    @Override
    public KBase setFiles(List<String> files) {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "files", this.files, files));
        }
        this.files = files;
        return this;
    }

    @Override
    public AssertBehaviorOption getEqualsBehavior() {
        return this.equalsBehavior;
    }

    @Override
    public KBase setEqualsBehavior(AssertBehaviorOption equalsBehaviour) {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "equalsBehavior", this.equalsBehavior, this.equalsBehavior));
        }
        this.equalsBehavior = equalsBehaviour;
        return this;
    }

    @Override
    public EventProcessingOption getEventProcessingMode() {
        return this.eventProcessingMode;
    }

    @Override
    public KBase setEventProcessingMode(EventProcessingOption eventProcessingMode) {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "eventProcessingMode", this.eventProcessingMode, eventProcessingMode));
        }
        this.eventProcessingMode = eventProcessingMode;
        return this;
    }

    @Override
    public List<String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public KBase setAnnotations(List<String> annotations) {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "annotations", this.annotations, annotations));
        }
        this.annotations = annotations;
        return this;
    }

    public String toString() {
        return "KBase [namespace=" + this.namespace + ", name=" + this.name + ", files=" + this.files + ", annotations=" + this.annotations + ", equalsBehaviour=" + this.equalsBehavior + ", eventProcessingMode=" + this.eventProcessingMode + ", ksessions=" + this.kSessions + "]";
    }
}

