/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.compiled;

import java.util.Collection;
import java.util.Iterator;
import org.drools.base.ClassObjectType;
import org.drools.base.ValueType;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageRegistry;
import org.drools.lang.descr.PackageDescr;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.compiled.AssertHandler;
import org.drools.reteoo.compiled.CompiledNetwork;
import org.drools.reteoo.compiled.DeclarationsHandler;
import org.drools.reteoo.compiled.HashedAlphasDeclaration;
import org.drools.reteoo.compiled.NetworkHandler;
import org.drools.reteoo.compiled.ObjectTypeNodeParser;
import org.drools.reteoo.compiled.SetNodeReferenceHandler;
import org.drools.rule.builder.dialect.java.JavaDialect;

public class ObjectTypeNodeCompiler {
    private static final String NEWLINE = "\n";
    private static final String PACKAGE_NAME = "org.drools.reteoo.compiled";
    private static final String BINARY_PACKAGE_NAME = "org.drools.reteoo.compiled".replace('.', '/');
    private String className;
    private String generatedClassSimpleName;
    private ObjectTypeNode objectTypeNode;
    private StringBuilder builder = new StringBuilder();

    private ObjectTypeNodeCompiler(ObjectTypeNode objectTypeNode) {
        this.objectTypeNode = objectTypeNode;
        ClassObjectType classObjectType = (ClassObjectType)objectTypeNode.getObjectType();
        this.className = classObjectType.getClassName();
        this.generatedClassSimpleName = "Compiled" + classObjectType.getClassName().replace('.', '_') + "Network";
    }

    private String generateSource() {
        this.createClassDeclaration();
        ObjectTypeNodeParser parser = new ObjectTypeNodeParser(this.objectTypeNode);
        DeclarationsHandler declarations = new DeclarationsHandler(this.builder);
        parser.accept((NetworkHandler)declarations);
        Collection hashedAlphaDeclarations = declarations.getHashedAlphaDeclarations();
        this.createConstructor(hashedAlphaDeclarations);
        SetNodeReferenceHandler setNode = new SetNodeReferenceHandler(this.builder);
        parser.accept((NetworkHandler)setNode);
        AssertHandler assertHandler = new AssertHandler(this.builder, this.className, hashedAlphaDeclarations.size() > 0);
        parser.accept((NetworkHandler)assertHandler);
        this.builder.append("}").append(NEWLINE);
        return this.builder.toString();
    }

    private void createClassDeclaration() {
        this.builder.append("package ").append(PACKAGE_NAME).append(";").append(NEWLINE);
        this.builder.append("public class ").append(this.generatedClassSimpleName).append(" extends ").append(CompiledNetwork.class.getName()).append("{ ").append(NEWLINE);
    }

    private void createConstructor(Collection<HashedAlphasDeclaration> hashedAlphaDeclarations) {
        this.builder.append("public ").append(this.generatedClassSimpleName).append("() {").append(NEWLINE);
        for (HashedAlphasDeclaration declaration : hashedAlphaDeclarations) {
            String mapVariableName = declaration.getVariableName();
            Iterator i$ = declaration.getHashedValues().iterator();
            while (i$.hasNext()) {
                Object hashedValue;
                Object value = hashedValue = i$.next();
                if (declaration.getValueType() == ValueType.STRING_TYPE) {
                    value = "\"" + value + "\"";
                }
                String nodeId = declaration.getNodeId(hashedValue);
                this.builder.append(mapVariableName).append(".put(").append(value).append(", ").append(nodeId).append(");");
                this.builder.append(NEWLINE);
            }
        }
        this.builder.append("}").append(NEWLINE);
    }

    private String getName() {
        return this.getPackageName() + "." + this.generatedClassSimpleName;
    }

    private String getBinaryName() {
        return BINARY_PACKAGE_NAME + "." + this.generatedClassSimpleName + ".class";
    }

    private String getPackageName() {
        return PACKAGE_NAME;
    }

    public static CompiledNetwork compile(PackageBuilder pkgBuilder, ObjectTypeNode objectTypeNode) {
        CompiledNetwork network;
        if (objectTypeNode == null) {
            throw new IllegalArgumentException("ObjectTypeNode cannot be null!");
        }
        if (pkgBuilder == null) {
            throw new IllegalArgumentException("PackageBuilder cannot be null!");
        }
        ObjectTypeNodeCompiler compiler = new ObjectTypeNodeCompiler(objectTypeNode);
        String packageName = compiler.getPackageName();
        PackageRegistry pkgReg = pkgBuilder.getPackageRegistry(packageName);
        if (pkgReg == null) {
            pkgBuilder.addPackage(new PackageDescr(packageName));
            pkgReg = pkgBuilder.getPackageRegistry(packageName);
        }
        String source = compiler.generateSource();
        String generatedSourceName = compiler.getName();
        JavaDialect dialect = (JavaDialect)pkgReg.getDialectCompiletimeRegistry().getDialect("java");
        dialect.addSrc(compiler.getBinaryName(), source.getBytes());
        pkgBuilder.compileAll();
        pkgBuilder.updateResults();
        try {
            network = (CompiledNetwork)Class.forName(generatedSourceName, true, (ClassLoader)pkgBuilder.getRootClassLoader()).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("This is a bug. Please contact the development team", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("This is a bug. Please contact the development team", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("This is a bug. Please contact the development team", e);
        }
        return network;
    }
}

