/*
 * Decompiled with CFR 0.152.
 */
package org.kie.builder.impl;

import java.util.HashMap;
import java.util.Map;
import org.drools.kproject.models.KieSessionModelImpl;
import org.kie.KieBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.builder.GAV;
import org.kie.builder.KieBaseModel;
import org.kie.builder.KieContainer;
import org.kie.builder.KieModule;
import org.kie.builder.KieRepository;
import org.kie.builder.KieSessionModel;
import org.kie.builder.impl.AbstractKieModule;
import org.kie.builder.impl.KieProject;
import org.kie.runtime.KieSession;
import org.kie.runtime.StatelessKieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieContainerImpl
implements KieContainer {
    private static final Logger log = LoggerFactory.getLogger(KieContainerImpl.class);
    private final KieProject kProject;
    private final Map<String, KieBase> kBases = new HashMap<String, KieBase>();
    private final KieRepository kr;

    public KieContainerImpl(KieProject kProject, KieRepository kr) {
        this.kr = kr;
        this.kProject = kProject;
        if (kProject != null) {
            this.kProject.init();
        }
    }

    public GAV getGAV() {
        return this.kProject.getGAV();
    }

    public void updateToVersion(GAV version) {
        throw new UnsupportedOperationException("This method is still to be implemented");
    }

    public KieBase getKieBase() {
        return this.getKieBase("!DeFaUlT!");
    }

    public KieBase getKieBase(String kBaseName) {
        KieBase kBase = this.kBases.get(kBaseName);
        if (kBase == null) {
            if (this.kProject != null) {
                kBase = AbstractKieModule.createKieBase(this.kProject.getKieBaseModel(kBaseName), this.kProject);
                if (kBase != null) {
                    this.kBases.put(kBaseName, kBase);
                }
            } else {
                return KnowledgeBaseFactory.newKnowledgeBase();
            }
        }
        return kBase;
    }

    public KieSession getKieSession() {
        return this.getKieBase().newKieSession();
    }

    public StatelessKieSession getKieStatelessSession() {
        return this.getKieBase().newStatelessKieSession();
    }

    public KieSession getKieSession(String kSessionName) {
        KieSessionModelImpl kSessionModel = (KieSessionModelImpl)this.kProject.getKieSessionModel(kSessionName);
        if (kSessionModel == null) {
            return null;
        }
        KieBase kBase = this.getKieBase(kSessionModel.getKieBaseModel().getName());
        if (kBase != null) {
            return kBase.newKieSession();
        }
        return null;
    }

    public StatelessKieSession getKieStatelessSession(String kSessionName) {
        KieSessionModelImpl kSessionModel = (KieSessionModelImpl)this.kProject.getKieSessionModel(kSessionName);
        if (kSessionName == null) {
            return null;
        }
        KieBase kBase = this.getKieBase(kSessionModel.getKieBaseModel().getName());
        if (kBase != null) {
            return kBase.newStatelessKieSession();
        }
        return null;
    }

    public void dispose() {
    }

    public KieModule getKieModuleForKBase(String kBaseName) {
        return this.kProject.getKieModuleForKBase(kBaseName);
    }

    public KieBaseModel getKieBaseModel(String kBaseName) {
        return this.kProject.getKieBaseModel(kBaseName);
    }

    public KieSessionModel getKieSessionModel(String kSessionName) {
        return this.kProject.getKieSessionModel(kSessionName);
    }

    public ClassLoader getClassLoader() {
        return this.kProject.getClassLoader();
    }
}

