/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import org.drools.commons.jci.problems.CompilationProblem;
import org.drools.compiler.DroolsError;
import org.drools.lang.descr.BaseDescr;
import org.drools.rule.Package;

public class FieldTemplateError
extends DroolsError {
    private Package pkg;
    private BaseDescr descr;
    private Object object;
    private String message;
    private int[] line;
    private String namespace;

    public FieldTemplateError(Package pkg, BaseDescr descr, Object object, String message) {
        super(descr.getResource());
        this.namespace = pkg.getName();
        this.pkg = pkg;
        this.descr = descr;
        this.object = object;
        this.message = message;
        this.line = new int[]{this.descr != null ? this.descr.getLine() : -1};
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public Package getPackage() {
        return this.pkg;
    }

    public BaseDescr getDescr() {
        return this.descr;
    }

    public Object getObject() {
        return this.object;
    }

    @Override
    public int[] getLines() {
        return this.line;
    }

    public int getLine() {
        return this.line[0];
    }

    @Override
    public String getMessage() {
        String summary = this.message;
        if (this.object instanceof CompilationProblem[]) {
            CompilationProblem[] problem = (CompilationProblem[])this.object;
            for (int i = 0; i < problem.length; ++i) {
                summary = summary + " " + problem[i].getMessage();
            }
        }
        return summary;
    }
}

