/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.DialectConfiguration;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.xml.RulesSemanticModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.rule.builder.DroolsCompilerComponentFactory;
import org.drools.compiler.rule.builder.util.AccumulateUtil;
import org.drools.core.base.evaluators.EvaluatorDefinition;
import org.drools.core.base.evaluators.EvaluatorRegistry;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.factmodel.ClassBuilderFactory;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.ConfFileUtils;
import org.drools.core.util.StringUtils;
import org.drools.core.xml.ChangeSetSemanticModule;
import org.drools.core.xml.DefaultSemanticModule;
import org.drools.core.xml.Handler;
import org.drools.core.xml.SemanticModule;
import org.drools.core.xml.SemanticModules;
import org.drools.core.xml.WrapperSemanticModule;
import org.drools.reflective.classloader.ProjectClassLoader;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.ResultSeverity;
import org.kie.internal.builder.conf.AccumulateFunctionOption;
import org.kie.internal.builder.conf.ClassLoaderCacheOption;
import org.kie.internal.builder.conf.DefaultDialectOption;
import org.kie.internal.builder.conf.DefaultPackageNameOption;
import org.kie.internal.builder.conf.DumpDirOption;
import org.kie.internal.builder.conf.EvaluatorOption;
import org.kie.internal.builder.conf.ExternaliseCanonicalModelLambdaOption;
import org.kie.internal.builder.conf.GroupDRLsInKieBasesByFolderOption;
import org.kie.internal.builder.conf.KBuilderSeverityOption;
import org.kie.internal.builder.conf.KnowledgeBuilderOption;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.kie.internal.builder.conf.MultiValueKnowledgeBuilderOption;
import org.kie.internal.builder.conf.ParallelRulesBuildThresholdOption;
import org.kie.internal.builder.conf.ProcessStringEscapesOption;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.kie.internal.builder.conf.SingleValueKnowledgeBuilderOption;
import org.kie.internal.builder.conf.TrimCellsInDTableOption;
import org.kie.internal.utils.ChainedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeBuilderConfigurationImpl
implements KnowledgeBuilderConfiguration {
    public static final String DEFAULT_PACKAGE = "defaultpkg";
    private static final int DEFAULT_PARALLEL_RULES_BUILD_THRESHOLD = 10;
    private Map<String, DialectConfiguration> dialectConfigurations;
    private DefaultDialectOption defaultDialect;
    private ParallelRulesBuildThresholdOption parallelRulesBuildThreshold = ParallelRulesBuildThresholdOption.get((int)10);
    private ClassLoader classLoader;
    private ChainedProperties chainedProperties;
    private Map<String, AccumulateFunction> accumulateFunctions;
    private EvaluatorRegistry evaluatorRegistry;
    private SemanticModules semanticModules;
    private File dumpDirectory;
    private boolean processStringEscapes = true;
    private boolean classLoaderCache = true;
    private boolean trimCellsInDTable = true;
    private boolean groupDRLsInKieBasesByFolder = false;
    private boolean externaliseCanonicalModelLambda = true;
    private static final PropertySpecificOption DEFAULT_PROP_SPEC_OPT = PropertySpecificOption.ALWAYS;
    private PropertySpecificOption propertySpecificOption = DEFAULT_PROP_SPEC_OPT;
    private String defaultPackageName;
    private Map<String, ResultSeverity> severityMap;
    private DroolsCompilerComponentFactory componentFactory;
    private ClassBuilderFactory classBuilderFactory;
    private LanguageLevelOption languageLevel = DrlParser.DEFAULT_LANGUAGE_LEVEL;
    private InternalKieModule.CompilationCache compilationCache = null;
    private static final Logger log = LoggerFactory.getLogger(KnowledgeBuilderConfigurationImpl.class);

    public KnowledgeBuilderConfigurationImpl(ClassLoader ... classLoaders) {
        this.init(null, classLoaders);
    }

    public KnowledgeBuilderConfigurationImpl(Properties properties) {
        this.init(properties, null);
    }

    public KnowledgeBuilderConfigurationImpl(Properties properties, ClassLoader ... classLoaders) {
        this.init(properties, classLoaders);
    }

    public KnowledgeBuilderConfigurationImpl() {
        this.init(null, null);
    }

    private void init(Properties properties, ClassLoader ... classLoaders) {
        if (classLoaders != null && classLoaders.length > 1) {
            throw new RuntimeException("Multiple classloaders are no longer supported");
        }
        this.setClassLoader(classLoaders == null || classLoaders.length == 0 ? null : classLoaders[0]);
        this.init(properties);
    }

    private void init(Properties properties) {
        this.chainedProperties = ChainedProperties.getChainedProperties((ClassLoader)this.getClassLoader());
        if (this.chainedProperties.getProperty("drools.dialect.java", null) == null) {
            this.chainedProperties = ChainedProperties.getChainedProperties((ClassLoader)this.getClass().getClassLoader());
            if (this.classLoader instanceof ProjectClassLoader) {
                ((ProjectClassLoader)this.classLoader).setDroolsClassLoader(this.getClass().getClassLoader());
            }
        }
        if (properties != null) {
            this.chainedProperties.addProperties(properties);
        }
        this.setProperty("drools.classLoaderCacheEnabled", this.chainedProperties.getProperty("drools.classLoaderCacheEnabled", "true"));
        this.setProperty("drools.trimCellsInDTable", this.chainedProperties.getProperty("drools.trimCellsInDTable", "true"));
        this.setProperty("drools.groupDRLsInKieBasesByFolder", this.chainedProperties.getProperty("drools.groupDRLsInKieBasesByFolder", "false"));
        this.setProperty("drools.propertySpecific", this.chainedProperties.getProperty("drools.propertySpecific", DEFAULT_PROP_SPEC_OPT.toString()));
        this.setProperty("drools.lang.level", this.chainedProperties.getProperty("drools.lang.level", DrlParser.DEFAULT_LANGUAGE_LEVEL.toString()));
        this.setProperty("drools.parallelRulesBuildThreshold", this.chainedProperties.getProperty("drools.parallelRulesBuildThreshold", String.valueOf(10)));
        this.dialectConfigurations = new HashMap<String, DialectConfiguration>();
        this.buildDialectConfigurationMap();
        this.accumulateFunctions = AccumulateUtil.buildAccumulateFunctionsMap(this.chainedProperties, this.getClassLoader());
        this.buildEvaluatorRegistry();
        this.buildDumpDirectory();
        this.buildSeverityMap();
        this.setProperty("drools.parser.processStringEscapes", this.chainedProperties.getProperty("drools.parser.processStringEscapes", "true"));
        this.setProperty("drools.defaultPackageName", this.chainedProperties.getProperty("drools.defaultPackageName", DEFAULT_PACKAGE));
        this.setProperty("drools.externaliseCanonicalModelLambda", this.chainedProperties.getProperty("drools.externaliseCanonicalModelLambda", "true"));
        this.componentFactory = new DroolsCompilerComponentFactory();
        this.classBuilderFactory = new ClassBuilderFactory();
    }

    private void buildSeverityMap() {
        this.severityMap = new HashMap<String, ResultSeverity>();
        HashMap temp = new HashMap();
        this.chainedProperties.mapStartsWith(temp, KBuilderSeverityOption.PROPERTY_NAME, true);
        int index = KBuilderSeverityOption.PROPERTY_NAME.length();
        for (Map.Entry entry : temp.entrySet()) {
            String identifier = ((String)entry.getKey()).trim().substring(index);
            this.severityMap.put(identifier, KBuilderSeverityOption.get((String)identifier, (String)((String)entry.getValue())).getSeverity());
        }
    }

    public void setProperty(String name, String value) {
        if (StringUtils.isEmpty((CharSequence)(name = name.trim()))) {
            return;
        }
        if (name.equals("drools.dialect.default")) {
            this.setDefaultDialect(value);
        } else if (name.startsWith("drools.accumulate.function.")) {
            this.addAccumulateFunction(name.substring("drools.accumulate.function.".length()), value);
        } else if (name.startsWith("drools.evaluator.")) {
            this.evaluatorRegistry.addEvaluatorDefinition(value);
        } else if (name.equals("drools.dump.dir")) {
            this.buildDumpDirectory(value);
        } else if (name.equals("drools.defaultPackageName")) {
            this.setDefaultPackageName(value);
        } else if (name.equals("drools.parser.processStringEscapes")) {
            this.setProcessStringEscapes(Boolean.parseBoolean(value));
        } else if (name.equals("drools.classLoaderCacheEnabled")) {
            this.setClassLoaderCacheEnabled(Boolean.parseBoolean(value));
        } else if (name.equals("drools.trimCellsInDTable")) {
            this.setTrimCellsInDTable(Boolean.parseBoolean(value));
        } else if (name.equals("drools.groupDRLsInKieBasesByFolder")) {
            this.setGroupDRLsInKieBasesByFolder(Boolean.parseBoolean(value));
        } else if (name.startsWith(KBuilderSeverityOption.PROPERTY_NAME)) {
            String key = name.substring(name.lastIndexOf(46) + 1);
            this.severityMap.put(key, KBuilderSeverityOption.get((String)key, (String)value).getSeverity());
        } else if (name.equals("drools.propertySpecific")) {
            try {
                this.setPropertySpecificOption(PropertySpecificOption.valueOf((String)value.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid value " + value + " for option " + "drools.propertySpecific");
            }
        } else if (name.equals("drools.lang.level")) {
            try {
                this.setLanguageLevel(LanguageLevelOption.valueOf((String)value.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid value " + value + " for option " + "drools.lang.level");
            }
        } else if (name.equals("drools.parallelRulesBuildThreshold")) {
            this.setParallelRulesBuildThreshold(Integer.valueOf(value));
        } else if (name.equals("drools.externaliseCanonicalModelLambda")) {
            this.setExternaliseCanonicalModelLambda(Boolean.valueOf(value));
        } else {
            Properties additionalProperty = new Properties();
            additionalProperty.setProperty(name, value);
            this.chainedProperties.addProperties(additionalProperty);
        }
    }

    public String getProperty(String name) {
        if (StringUtils.isEmpty((CharSequence)(name = name.trim()))) {
            return null;
        }
        if (name.equals("drools.dialect.default")) {
            return this.getDefaultDialect();
        }
        if (name.equals("drools.defaultPackageName")) {
            return this.getDefaultPackageName();
        }
        if (name.startsWith("drools.accumulate.function.")) {
            int index = "drools.accumulate.function.".length();
            AccumulateFunction function = this.accumulateFunctions.get(name.substring(index));
            return function != null ? function.getClass().getName() : null;
        }
        if (name.startsWith("drools.evaluator.")) {
            String key = name.substring(name.lastIndexOf(46) + 1);
            EvaluatorDefinition evalDef = this.evaluatorRegistry.getEvaluatorDefinition(key);
            return evalDef != null ? evalDef.getClass().getName() : null;
        }
        if (name.equals("drools.dump.dir")) {
            return this.dumpDirectory != null ? this.dumpDirectory.toString() : null;
        }
        if (name.equals("drools.parser.processStringEscapes")) {
            return String.valueOf(this.isProcessStringEscapes());
        }
        if (name.equals("drools.classLoaderCacheEnabled")) {
            return String.valueOf(this.isClassLoaderCacheEnabled());
        }
        if (name.equals("drools.trimCellsInDTable")) {
            return String.valueOf(this.isTrimCellsInDTable());
        }
        if (name.equals("drools.groupDRLsInKieBasesByFolder")) {
            return String.valueOf(this.isGroupDRLsInKieBasesByFolder());
        }
        if (name.startsWith(KBuilderSeverityOption.PROPERTY_NAME)) {
            String key = name.substring(name.lastIndexOf(46) + 1);
            ResultSeverity severity = this.severityMap.get(key);
            return severity.toString();
        }
        if (name.equals("drools.lang.level")) {
            return "" + this.getLanguageLevel();
        }
        if (name.equals("drools.parallelRulesBuildThreshold")) {
            return String.valueOf(this.getParallelRulesBuildThreshold());
        }
        if (name.equals("drools.externaliseCanonicalModelLambda")) {
            return String.valueOf(this.isExternaliseCanonicalModelLambda());
        }
        return null;
    }

    public ChainedProperties getChainedProperties() {
        return this.chainedProperties;
    }

    private void buildDialectConfigurationMap() {
        HashMap dialectProperties = new HashMap();
        this.chainedProperties.mapStartsWith(dialectProperties, "drools.dialect", false);
        this.setDefaultDialect((String)dialectProperties.remove("drools.dialect.default"));
        for (Map.Entry entry : dialectProperties.entrySet()) {
            String str = (String)entry.getKey();
            String dialectName = str.substring(str.lastIndexOf(".") + 1);
            String dialectClass = (String)entry.getValue();
            this.addDialect(dialectName, dialectClass);
        }
    }

    public void addDialect(String dialectName, String dialectClass) {
        Class<?> cls = null;
        try {
            cls = this.getClassLoader().loadClass(dialectClass);
            DialectConfiguration dialectConf = (DialectConfiguration)cls.newInstance();
            dialectConf.init(this);
            this.addDialect(dialectName, dialectConf);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load dialect '" + dialectClass + ":" + dialectName + ":" + (cls != null ? cls.getName() : "null") + "'", e);
        }
    }

    public void addDialect(String dialectName, DialectConfiguration dialectConf) {
        this.dialectConfigurations.put(dialectName, dialectConf);
    }

    public DialectCompiletimeRegistry buildDialectRegistry(ClassLoader rootClassLoader, KnowledgeBuilderConfigurationImpl pkgConf, PackageRegistry pkgRegistry, InternalKnowledgePackage pkg) {
        DialectCompiletimeRegistry registry = new DialectCompiletimeRegistry();
        for (DialectConfiguration conf : this.dialectConfigurations.values()) {
            Dialect dialect = conf.newDialect(rootClassLoader, pkgConf, pkgRegistry, pkg);
            registry.addDialect(dialect.getId(), dialect);
        }
        return registry;
    }

    public String getDefaultDialect() {
        return this.defaultDialect.getName();
    }

    public void setDefaultDialect(String defaultDialect) {
        this.defaultDialect = DefaultDialectOption.get((String)defaultDialect);
    }

    public DialectConfiguration getDialectConfiguration(String name) {
        return this.dialectConfigurations.get(name);
    }

    public void setDialectConfiguration(String name, DialectConfiguration configuration) {
        this.dialectConfigurations.put(name, configuration);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void setClassLoader(ClassLoader classLoader) {
        this.classLoader = ProjectClassLoader.getClassLoader((ClassLoader)classLoader, this.getClass(), (boolean)this.isClassLoaderCacheEnabled());
    }

    public void addSemanticModule(SemanticModule module) {
        if (this.semanticModules == null) {
            this.initSemanticModules();
        }
        this.semanticModules.addSemanticModule(module);
    }

    public SemanticModules getSemanticModules() {
        if (this.semanticModules == null) {
            this.initSemanticModules();
        }
        return this.semanticModules;
    }

    public void initSemanticModules() {
        String[] locations;
        this.semanticModules = new SemanticModules();
        RulesSemanticModule ruleModule = new RulesSemanticModule("http://ddefault");
        this.semanticModules.addSemanticModule((SemanticModule)new WrapperSemanticModule("http://drools.org/drools-5.0", (SemanticModule)ruleModule));
        this.semanticModules.addSemanticModule((SemanticModule)new WrapperSemanticModule("http://drools.org/drools-5.2", (SemanticModule)ruleModule));
        this.semanticModules.addSemanticModule((SemanticModule)new ChangeSetSemanticModule());
        for (String moduleLocation : locations = this.chainedProperties.getProperty("semanticModules", "").split("\\s")) {
            if ((moduleLocation = moduleLocation.trim()).startsWith("\"")) {
                moduleLocation = moduleLocation.substring(1);
            }
            if (moduleLocation.endsWith("\"")) {
                moduleLocation = moduleLocation.substring(0, moduleLocation.length() - 1);
            }
            if (moduleLocation.equals("")) continue;
            this.loadSemanticModule(moduleLocation);
        }
    }

    public void loadSemanticModule(String moduleLocation) {
        URL url = ConfFileUtils.getURL((String)moduleLocation, (ClassLoader)this.getClassLoader(), this.getClass());
        if (url == null) {
            throw new IllegalArgumentException(moduleLocation + " is specified but cannot be found.'");
        }
        Properties properties = ConfFileUtils.getProperties((URL)url);
        if (properties == null) {
            throw new IllegalArgumentException(moduleLocation + " is specified but cannot be found.'");
        }
        this.loadSemanticModule(properties);
    }

    public void loadSemanticModule(Properties properties) {
        String uri = properties.getProperty("uri", null);
        if (uri == null || uri.trim().equals("")) {
            throw new RuntimeException("Semantic Module URI property must not be empty");
        }
        DefaultSemanticModule module = new DefaultSemanticModule(uri);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String elementName = (String)entry.getKey();
            if ("uri".equals(elementName)) continue;
            if (elementName == null || elementName.trim().equals("")) {
                throw new RuntimeException("Element name must be specified for Semantic Module handler");
            }
            String handlerName = (String)entry.getValue();
            if (handlerName == null || handlerName.trim().equals("")) {
                throw new RuntimeException("Handler name must be specified for Semantic Module");
            }
            Handler handler = (Handler)ClassUtils.instantiateObject((String)handlerName, (ClassLoader)this.getClassLoader());
            if (handler == null) {
                throw new RuntimeException("Unable to load Semantic Module handler '" + elementName + ":" + handlerName + "'");
            }
            module.addHandler(elementName, handler);
        }
        this.semanticModules.addSemanticModule((SemanticModule)module);
    }

    public void addAccumulateFunction(String identifier, String className) {
        this.accumulateFunctions.put(identifier, AccumulateUtil.loadAccumulateFunction(this.getClassLoader(), identifier, className));
    }

    public void addAccumulateFunction(String identifier, Class<? extends AccumulateFunction> clazz) {
        try {
            this.accumulateFunctions.put(identifier, clazz.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error loading accumulate function for identifier " + identifier + ". Instantiation failed for class " + clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error loading accumulate function for identifier " + identifier + ". Illegal access to class " + clazz.getName(), e);
        }
    }

    public AccumulateFunction getAccumulateFunction(String identifier) {
        return this.accumulateFunctions.get(identifier);
    }

    public Collection<String> getAccumulateFunctionNames() {
        return this.accumulateFunctions.keySet();
    }

    private void buildEvaluatorRegistry() {
        this.evaluatorRegistry = new EvaluatorRegistry(this.getClassLoader());
        HashMap temp = new HashMap();
        this.chainedProperties.mapStartsWith(temp, "drools.evaluator.", true);
        for (Map.Entry e : temp.entrySet()) {
            String key = (String)e.getKey();
            if ("drools.evaluator.equality".equals(key) || "drools.evaluator.comparable".equals(key)) continue;
            this.evaluatorRegistry.addEvaluatorDefinition((String)e.getValue());
        }
    }

    public EvaluatorRegistry getEvaluatorRegistry() {
        return this.evaluatorRegistry;
    }

    public void addEvaluatorDefinition(String className) {
        this.evaluatorRegistry.addEvaluatorDefinition(className);
    }

    public void addEvaluatorDefinition(EvaluatorDefinition def) {
        this.evaluatorRegistry.addEvaluatorDefinition(def);
    }

    private void buildDumpDirectory() {
        String dumpStr = this.chainedProperties.getProperty("drools.dump.dir", null);
        this.buildDumpDirectory(dumpStr);
    }

    private void buildDumpDirectory(String dumpStr) {
        if (dumpStr != null) {
            this.setDumpDir(new File(dumpStr));
        }
    }

    public File getDumpDir() {
        return this.dumpDirectory;
    }

    public void setDumpDir(File dumpDir) {
        if (!(dumpDir.isDirectory() && dumpDir.canWrite() && dumpDir.canRead())) {
            throw new RuntimeException("Drools dump directory is not accessible: " + dumpDir.toString());
        }
        this.dumpDirectory = dumpDir;
    }

    public boolean isProcessStringEscapes() {
        return this.processStringEscapes;
    }

    public void setProcessStringEscapes(boolean processStringEscapes) {
        this.processStringEscapes = processStringEscapes;
    }

    @Deprecated
    public boolean isClassLoaderCacheEnabled() {
        return this.classLoaderCache;
    }

    @Deprecated
    public void setClassLoaderCacheEnabled(boolean classLoaderCacheEnabled) {
        this.classLoaderCache = classLoaderCacheEnabled;
    }

    public boolean isTrimCellsInDTable() {
        return this.trimCellsInDTable;
    }

    public void setTrimCellsInDTable(boolean trimCellsInDTable) {
        this.trimCellsInDTable = trimCellsInDTable;
    }

    public boolean isGroupDRLsInKieBasesByFolder() {
        return this.groupDRLsInKieBasesByFolder;
    }

    public void setGroupDRLsInKieBasesByFolder(boolean groupDRLsInKieBasesByFolder) {
        this.groupDRLsInKieBasesByFolder = groupDRLsInKieBasesByFolder;
    }

    public int getParallelRulesBuildThreshold() {
        return this.parallelRulesBuildThreshold.getParallelRulesBuildThreshold();
    }

    public void setParallelRulesBuildThreshold(int parallelRulesBuildThreshold) {
        this.parallelRulesBuildThreshold = ParallelRulesBuildThresholdOption.get((int)parallelRulesBuildThreshold);
    }

    public String getDefaultPackageName() {
        return this.defaultPackageName;
    }

    public void setDefaultPackageName(String defaultPackageName) {
        this.defaultPackageName = defaultPackageName;
    }

    public DroolsCompilerComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    public void setComponentFactory(DroolsCompilerComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
    }

    public ClassBuilderFactory getClassBuilderFactory() {
        return this.classBuilderFactory;
    }

    public void setClassBuilderFactory(ClassBuilderFactory classBuilderFactory) {
        this.classBuilderFactory = classBuilderFactory;
    }

    public LanguageLevelOption getLanguageLevel() {
        return this.languageLevel;
    }

    public void setLanguageLevel(LanguageLevelOption languageLevel) {
        this.languageLevel = languageLevel;
    }

    public PropertySpecificOption getPropertySpecificOption() {
        return this.propertySpecificOption;
    }

    public void setPropertySpecificOption(PropertySpecificOption propertySpecificOption) {
        this.propertySpecificOption = propertySpecificOption;
    }

    public boolean isExternaliseCanonicalModelLambda() {
        return this.externaliseCanonicalModelLambda;
    }

    public void setExternaliseCanonicalModelLambda(boolean externaliseCanonicalModelLambda) {
        this.externaliseCanonicalModelLambda = externaliseCanonicalModelLambda;
    }

    public <T extends SingleValueKnowledgeBuilderOption> T getOption(Class<T> option) {
        if (DefaultDialectOption.class.equals(option)) {
            return (T)this.defaultDialect;
        }
        if (DumpDirOption.class.equals(option)) {
            return (T)DumpDirOption.get((File)this.dumpDirectory);
        }
        if (ProcessStringEscapesOption.class.equals(option)) {
            return (T)(this.processStringEscapes ? ProcessStringEscapesOption.YES : ProcessStringEscapesOption.NO);
        }
        if (DefaultPackageNameOption.class.equals(option)) {
            return (T)DefaultPackageNameOption.get((String)this.defaultPackageName);
        }
        if (ClassLoaderCacheOption.class.equals(option)) {
            return (T)(this.classLoaderCache ? ClassLoaderCacheOption.ENABLED : ClassLoaderCacheOption.DISABLED);
        }
        if (TrimCellsInDTableOption.class.equals(option)) {
            return (T)(this.trimCellsInDTable ? TrimCellsInDTableOption.ENABLED : TrimCellsInDTableOption.DISABLED);
        }
        if (GroupDRLsInKieBasesByFolderOption.class.equals(option)) {
            return (T)(this.groupDRLsInKieBasesByFolder ? GroupDRLsInKieBasesByFolderOption.ENABLED : GroupDRLsInKieBasesByFolderOption.DISABLED);
        }
        if (PropertySpecificOption.class.equals(option)) {
            return (T)this.propertySpecificOption;
        }
        if (LanguageLevelOption.class.equals(option)) {
            return (T)this.languageLevel;
        }
        if (ExternaliseCanonicalModelLambdaOption.class.equals(option)) {
            return (T)(this.externaliseCanonicalModelLambda ? ExternaliseCanonicalModelLambdaOption.ENABLED : ExternaliseCanonicalModelLambdaOption.DISABLED);
        }
        return null;
    }

    public <T extends MultiValueKnowledgeBuilderOption> T getOption(Class<T> option, String key) {
        if (AccumulateFunctionOption.class.equals(option)) {
            return (T)AccumulateFunctionOption.get((String)key, (AccumulateFunction)this.accumulateFunctions.get(key));
        }
        if (EvaluatorOption.class.equals(option)) {
            return (T)EvaluatorOption.get((String)key, (org.kie.api.runtime.rule.EvaluatorDefinition)this.evaluatorRegistry.getEvaluatorDefinition(key));
        }
        if (KBuilderSeverityOption.class.equals(option)) {
            return (T)KBuilderSeverityOption.get((String)key, (ResultSeverity)this.severityMap.get(key));
        }
        return null;
    }

    public <T extends MultiValueKnowledgeBuilderOption> Set<String> getOptionKeys(Class<T> option) {
        if (AccumulateFunctionOption.class.equals(option)) {
            return this.accumulateFunctions.keySet();
        }
        if (EvaluatorOption.class.equals(option)) {
            return this.evaluatorRegistry.keySet();
        }
        if (KBuilderSeverityOption.class.equals(option)) {
            return this.severityMap.keySet();
        }
        return null;
    }

    public <T extends KnowledgeBuilderOption> void setOption(T option) {
        if (option instanceof DefaultDialectOption) {
            this.defaultDialect = (DefaultDialectOption)option;
        } else if (option instanceof AccumulateFunctionOption) {
            this.accumulateFunctions.put(((AccumulateFunctionOption)option).getName(), ((AccumulateFunctionOption)option).getFunction());
        } else if (option instanceof DumpDirOption) {
            this.dumpDirectory = ((DumpDirOption)option).getDirectory();
        } else if (option instanceof EvaluatorOption) {
            this.evaluatorRegistry.addEvaluatorDefinition((EvaluatorDefinition)((EvaluatorOption)option).getEvaluatorDefinition());
        } else if (option instanceof ProcessStringEscapesOption) {
            this.processStringEscapes = ((ProcessStringEscapesOption)option).isProcessStringEscapes();
        } else if (option instanceof DefaultPackageNameOption) {
            this.setDefaultPackageName(((DefaultPackageNameOption)option).getPackageName());
        } else if (option instanceof ClassLoaderCacheOption) {
            this.setClassLoaderCacheEnabled(((ClassLoaderCacheOption)option).isClassLoaderCacheEnabled());
        } else if (option instanceof TrimCellsInDTableOption) {
            this.setTrimCellsInDTable(((TrimCellsInDTableOption)option).isTrimCellsInDTable());
        } else if (option instanceof GroupDRLsInKieBasesByFolderOption) {
            this.setGroupDRLsInKieBasesByFolder(((GroupDRLsInKieBasesByFolderOption)option).isGroupDRLsInKieBasesByFolder());
        } else if (option instanceof KBuilderSeverityOption) {
            this.severityMap.put(((KBuilderSeverityOption)option).getName(), ((KBuilderSeverityOption)option).getSeverity());
        } else if (option instanceof PropertySpecificOption) {
            this.propertySpecificOption = (PropertySpecificOption)option;
        } else if (option instanceof LanguageLevelOption) {
            this.languageLevel = (LanguageLevelOption)option;
        } else if (option instanceof ExternaliseCanonicalModelLambdaOption) {
            this.externaliseCanonicalModelLambda = ((ExternaliseCanonicalModelLambdaOption)option).isCanonicalModelLambdaExternalized();
        }
    }

    public InternalKieModule.CompilationCache getCompilationCache() {
        return this.compilationCache;
    }

    public void setCompilationCache(InternalKieModule.CompilationCache cache) {
        this.compilationCache = cache;
    }

    public boolean isPreCompiled() {
        return this.compilationCache != null;
    }
}

