/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect;

import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaBlockDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaCatchBlockDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaContainerBlockDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaTryBlockDescr;
import org.drools.core.util.ClassUtils;

public final class DialectUtil {
    private static final Pattern NON_ALPHA_REGEX = Pattern.compile("[\\W]");

    public static String getUniqueLegalName(String packageName, String name, int seed, String ext, String prefix, ResourceReader src) {
        String actualName;
        String newName = prefix + "_" + DialectUtil.normalizeRuleName(name);
        if (ext.equals("java")) {
            return newName + Math.abs(seed);
        }
        String fileName = packageName.replace('.', '/') + "/" + newName;
        if (src == null || !src.isAvailable(fileName + "." + ext)) {
            return newName;
        }
        int counter = -1;
        while (src.isAvailable(actualName = fileName + "_" + ++counter + "." + ext)) {
        }
        return newName + "_" + counter;
    }

    public static List<JavaBlockDescr> buildBlockDescrs(List<JavaBlockDescr> descrs, JavaContainerBlockDescr parentBlock) {
        for (JavaBlockDescr block : parentBlock.getJavaBlockDescrs()) {
            if (block instanceof JavaContainerBlockDescr) {
                DialectUtil.buildBlockDescrs(descrs, (JavaContainerBlockDescr)block);
                continue;
            }
            descrs.add(block);
        }
        return descrs;
    }

    private static void addWhiteSpaces(String original, StringBuilder consequence, int start, int end) {
        block3: for (int i = start; i < end; ++i) {
            switch (original.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    consequence.append(original.charAt(i));
                    continue block3;
                }
                default: {
                    consequence.append(" ");
                }
            }
        }
    }

    private static void stripTryDescr(String originalCode, StringBuilder consequence, JavaTryBlockDescr block, int offset) {
        DialectUtil.addWhiteSpaces(originalCode, consequence, consequence.length(), block.getTextStart() - offset);
        DialectUtil.addWhiteSpaces(originalCode, consequence, consequence.length(), block.getEnd() - offset);
        for (JavaCatchBlockDescr catchBlock : block.getCatches()) {
            DialectUtil.addWhiteSpaces(originalCode, consequence, consequence.length(), catchBlock.getTextStart() - offset);
            DialectUtil.addWhiteSpaces(originalCode, consequence, consequence.length(), catchBlock.getEnd() - offset);
        }
        if (block.getFinal() != null) {
            DialectUtil.addWhiteSpaces(originalCode, consequence, consequence.length(), block.getFinal().getTextStart() - offset);
            DialectUtil.addWhiteSpaces(originalCode, consequence, consequence.length(), block.getFinal().getEnd() - offset);
        }
    }

    private static void stripBlockDescr(String originalCode, StringBuilder consequence, JavaBlockDescr block, int offset) {
        DialectUtil.addWhiteSpaces(originalCode, consequence, consequence.length(), block.getEnd() - offset);
    }

    public static Class<?> findClassByName(RuleBuildContext context, String className) {
        if (className == null) {
            return null;
        }
        String namespace = context.getRuleDescr().getNamespace();
        DroolsAssemblerContext packageBuilder = context.getKnowledgeBuilder();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className.indexOf(46) < 0 ? namespace + "." + className : className, false, packageBuilder.getRootClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            return clazz;
        }
        HashSet<String> imports = new HashSet<String>();
        List<PackageDescr> pkgDescrs = packageBuilder.getPackageDescrs(namespace);
        if (pkgDescrs == null) {
            return null;
        }
        for (PackageDescr pkgDescr : pkgDescrs) {
            for (ImportDescr importDescr : pkgDescr.getImports()) {
                imports.add(importDescr.getTarget());
            }
        }
        return ClassUtils.findClass((String)className, imports, (ClassLoader)packageBuilder.getRootClassLoader());
    }

    static String normalizeRuleName(String name) {
        String normalized = name.replace(' ', '_');
        if (!NON_ALPHA_REGEX.matcher(normalized).find()) {
            return normalized;
        }
        StringBuilder sb = new StringBuilder(normalized.length());
        for (char ch : normalized.toCharArray()) {
            if (ch == '$') {
                sb.append("_dollar_");
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                sb.append(ch);
                continue;
            }
            sb.append("$u").append((int)ch).append("$");
        }
        return sb.toString();
    }
}

