/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.TypeDeclarationUtils;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.TypeDeclarationError;
import org.drools.compiler.rule.builder.util.AnnotationFactory;
import org.drools.core.addon.TypeResolver;
import org.drools.core.base.ClassFieldInspector;
import org.drools.core.base.CoreComponentsBuilder;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.traits.Alias;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.util.HierarchySorter;
import org.drools.drl.ast.descr.AbstractClassTypeDeclarationDescr;
import org.drools.drl.ast.descr.AnnotatedBaseDescr;
import org.drools.drl.ast.descr.AnnotationDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.PatternDescr;
import org.drools.drl.ast.descr.QualifiedName;
import org.drools.drl.ast.descr.TypeDeclarationDescr;
import org.drools.drl.ast.descr.TypeFieldDescr;
import org.kie.api.definition.type.FactField;
import org.kie.api.definition.type.Key;
import org.kie.api.io.Resource;

public class ClassHierarchyManager {
    protected final KnowledgeBuilderImpl kbuilder;
    protected List<AbstractClassTypeDeclarationDescr> sortedDescriptors;
    protected Map<QualifiedName, Collection<QualifiedName>> taxonomy;

    public ClassHierarchyManager(Collection<AbstractClassTypeDeclarationDescr> unsortedDescrs, KnowledgeBuilderImpl kbuilder) {
        this.kbuilder = kbuilder;
        this.sortedDescriptors = this.sortByHierarchy(unsortedDescrs, kbuilder);
    }

    public List<AbstractClassTypeDeclarationDescr> getSortedDescriptors() {
        return this.sortedDescriptors;
    }

    protected List<AbstractClassTypeDeclarationDescr> sortByHierarchy(Collection<AbstractClassTypeDeclarationDescr> unsortedDescrs, KnowledgeBuilderImpl kbuilder) {
        this.taxonomy = new HashMap<QualifiedName, Collection<QualifiedName>>();
        HashMap<QualifiedName, AbstractClassTypeDeclarationDescr> cache = new HashMap<QualifiedName, AbstractClassTypeDeclarationDescr>();
        for (AbstractClassTypeDeclarationDescr tdescr : unsortedDescrs) {
            cache.put(tdescr.getType(), tdescr);
        }
        for (AbstractClassTypeDeclarationDescr tdescr : unsortedDescrs) {
            QualifiedName name = tdescr.getType();
            Collection<QualifiedName> supers = this.taxonomy.get(name);
            if (supers == null) {
                supers = new ArrayList<QualifiedName>();
                this.taxonomy.put(name, supers);
            } else {
                kbuilder.addBuilderResult(new TypeDeclarationError((BaseDescr)tdescr, "Found duplicate declaration for type " + tdescr.getType()));
            }
            boolean circular = false;
            for (QualifiedName sup : tdescr.getSuperTypes()) {
                if (Object.class.getName().equals(name.getFullName())) continue;
                if (!ClassHierarchyManager.hasCircularDependency(tdescr.getType(), sup, this.taxonomy)) {
                    if (!cache.containsKey(sup)) continue;
                    supers.add(sup);
                    continue;
                }
                circular = true;
                kbuilder.addBuilderResult(new TypeDeclarationError((BaseDescr)tdescr, "Found circular dependency for type " + tdescr.getTypeName()));
                break;
            }
            if (!circular) continue;
            tdescr.getSuperTypes().clear();
        }
        for (AbstractClassTypeDeclarationDescr tdescr : unsortedDescrs) {
            for (TypeFieldDescr field : tdescr.getFields().values()) {
                QualifiedName typeName;
                QualifiedName name = tdescr.getType();
                if (!ClassHierarchyManager.hasCircularDependency(name, typeName = new QualifiedName(field.getPattern().getGenericType().getRawType()), this.taxonomy)) {
                    if (!cache.containsKey(typeName)) continue;
                    this.taxonomy.get(name).add(typeName);
                    continue;
                }
                field.setRecursive(true);
            }
        }
        List sorted = new HierarchySorter().sort(this.taxonomy);
        ArrayList<AbstractClassTypeDeclarationDescr> list = new ArrayList<AbstractClassTypeDeclarationDescr>(sorted.size());
        for (QualifiedName name : sorted) {
            list.add((AbstractClassTypeDeclarationDescr)cache.get(name));
        }
        return list;
    }

    protected static boolean hasCircularDependency(QualifiedName name, QualifiedName typeName, Map<QualifiedName, Collection<QualifiedName>> taxonomy) {
        if (name.equals((Object)typeName)) {
            return true;
        }
        Collection<QualifiedName> parents = taxonomy.get(typeName);
        if (parents != null) {
            if (parents.contains(name)) {
                return true;
            }
            for (QualifiedName ancestor : parents) {
                if (!ClassHierarchyManager.hasCircularDependency(name, ancestor, taxonomy)) continue;
                return true;
            }
        }
        return false;
    }

    public void inheritFields(PackageRegistry pkgRegistry, AbstractClassTypeDeclarationDescr typeDescr, Map<String, AbstractClassTypeDeclarationDescr> unprocessableDescrs) {
        TypeDeclarationDescr tDescr = (TypeDeclarationDescr)typeDescr;
        boolean isNovel = TypeDeclarationUtils.isNovelClass(typeDescr, pkgRegistry);
        boolean inferFields = !isNovel && typeDescr.getFields().isEmpty();
        this.mergeInheritedFields(tDescr, unprocessableDescrs, pkgRegistry.getTypeResolver());
        if (inferFields) {
            Class<?> existingClass = TypeDeclarationUtils.getExistingDeclarationClass(typeDescr, pkgRegistry);
            ClassHierarchyManager.buildDescrsFromFields(existingClass, tDescr, tDescr.getFields());
        }
    }

    private static void buildDescrsFromFields(Class klass, TypeDeclarationDescr typeDescr, Map<String, TypeFieldDescr> fieldMap) {
        ClassFieldInspector inspector;
        try {
            inspector = CoreComponentsBuilder.get().createClassFieldInspector(klass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (String name : inspector.getGetterMethods().keySet()) {
            if (!inspector.getSetterMethods().containsKey(name) || inspector.isNonGetter(name) || "class".equals(name)) continue;
            Resource resource = typeDescr.getResource();
            PatternDescr patternDescr = new PatternDescr(inspector.getFieldType(name).getName());
            patternDescr.setResource(resource);
            TypeFieldDescr inheritedFlDescr = new TypeFieldDescr(name, patternDescr);
            inheritedFlDescr.setResource(resource);
            inheritedFlDescr.setInherited(!Modifier.isAbstract(((Method)inspector.getGetterMethods().get(name)).getModifiers()));
            if (fieldMap.containsKey(inheritedFlDescr.getFieldName())) continue;
            fieldMap.put(inheritedFlDescr.getFieldName(), inheritedFlDescr);
        }
    }

    protected void mergeInheritedFields(TypeDeclarationDescr typeDescr, Map<String, AbstractClassTypeDeclarationDescr> unprocessableDescrs, TypeResolver typeResolver) {
        if (typeDescr.getSuperTypes().isEmpty()) {
            return;
        }
        for (int j = typeDescr.getSuperTypes().size() - 1; j >= 0; --j) {
            QualifiedName qname = (QualifiedName)typeDescr.getSuperTypes().get(j);
            String simpleSuperTypeName = qname.getName();
            String superTypePackageName = qname.getNamespace();
            String fullSuper = qname.getFullName();
            this.mergeFields(simpleSuperTypeName, superTypePackageName, fullSuper, typeDescr, unprocessableDescrs, typeResolver);
        }
    }

    protected void mergeFields(String simpleSuperTypeName, String superTypePackageName, String fullSuper, TypeDeclarationDescr typeDescr, Map<String, AbstractClassTypeDeclarationDescr> unprocessableDescrs, TypeResolver resolver) {
        LinkedHashMap<String, TypeFieldDescr> fieldMap = new LinkedHashMap<String, TypeFieldDescr>();
        PackageRegistry registry = this.kbuilder.getPackageRegistry(superTypePackageName);
        InternalKnowledgePackage pack = null;
        if (registry != null) {
            pack = registry.getPackage();
        }
        if (unprocessableDescrs.containsKey(fullSuper)) {
            unprocessableDescrs.put(typeDescr.getType().getFullName(), (AbstractClassTypeDeclarationDescr)typeDescr);
            return;
        }
        boolean isSuperClassTagged = false;
        boolean isSuperClassDeclared = true;
        if (pack != null) {
            TypeDeclaration superTypeDeclaration = pack.getTypeDeclaration(simpleSuperTypeName);
            if (superTypeDeclaration != null && superTypeDeclaration.getTypeClassDef() != null) {
                ClassDefinition classDef = superTypeDeclaration.getTypeClassDef();
                for (FactField fld : classDef.getFields()) {
                    TypeFieldDescr inheritedFlDescr = this.buildInheritedFieldDescrFromDefinition(fld, typeDescr);
                    fieldMap.put(inheritedFlDescr.getFieldName(), inheritedFlDescr);
                }
                isSuperClassTagged = !superTypeDeclaration.isNovel();
            }
        } else {
            isSuperClassDeclared = false;
        }
        if (!isSuperClassDeclared || isSuperClassTagged) {
            try {
                Class superKlass = registry != null ? registry.getTypeResolver().resolveType(fullSuper) : resolver.resolveType(fullSuper);
                ClassHierarchyManager.buildDescrsFromFields(superKlass, typeDescr, fieldMap);
            }
            catch (ClassNotFoundException cnfe) {
                unprocessableDescrs.put(typeDescr.getType().getFullName(), (AbstractClassTypeDeclarationDescr)typeDescr);
                return;
            }
        }
        for (String fieldName : typeDescr.getFields().keySet()) {
            if (fieldMap.containsKey(fieldName)) {
                String type1 = ((TypeFieldDescr)fieldMap.get(fieldName)).getPattern().getObjectType();
                String type2 = ((TypeFieldDescr)typeDescr.getFields().get(fieldName)).getPattern().getObjectType();
                if (type2.lastIndexOf(".") < 0) {
                    try {
                        TypeResolver typeResolver = this.kbuilder.getPackageRegistry(typeDescr.getNamespace()).getTypeResolver();
                        type1 = typeResolver.resolveType(type1).getName();
                        type2 = typeResolver.resolveType(type2).getName();
                        ((TypeFieldDescr)fieldMap.get(fieldName)).getPattern().setObjectType(type1);
                        ((TypeFieldDescr)typeDescr.getFields().get(fieldName)).getPattern().setObjectType(type2);
                    }
                    catch (ClassNotFoundException typeResolver) {
                        // empty catch block
                    }
                }
                boolean clash = !type1.equals(type2);
                TypeFieldDescr overriding = null;
                if (clash) {
                    try {
                        Class sup = resolver.resolveType(type1);
                        Class loc = resolver.resolveType(type2);
                        if (sup.isAssignableFrom(loc)) {
                            clash = false;
                            overriding = (TypeFieldDescr)fieldMap.get(fieldName);
                        }
                    }
                    catch (ClassNotFoundException sup) {
                        // empty catch block
                    }
                }
                if (clash) {
                    this.kbuilder.addBuilderResult(new TypeDeclarationError((BaseDescr)typeDescr, "Cannot redeclare field '" + fieldName + " from " + type1 + " to " + type2));
                    typeDescr.setType(null, null);
                    return;
                }
                String initVal = ((TypeFieldDescr)fieldMap.get(fieldName)).getInitExpr();
                TypeFieldDescr fd = (TypeFieldDescr)typeDescr.getFields().get(fieldName);
                if (fd.getInitExpr() == null) {
                    fd.setInitExpr(initVal);
                }
                fd.setInherited(((TypeFieldDescr)fieldMap.get(fieldName)).isInherited());
                fd.setOverriding(overriding);
                for (String key : ((TypeFieldDescr)fieldMap.get(fieldName)).getAnnotationNames()) {
                    if (fd.getAnnotation(key) != null) continue;
                    fd.addAnnotation(((TypeFieldDescr)fieldMap.get(fieldName)).getAnnotation(key));
                }
                if (fd.getIndex() < 0) {
                    fd.setIndex(((TypeFieldDescr)fieldMap.get(fieldName)).getIndex());
                }
            }
            fieldMap.put(fieldName, (TypeFieldDescr)typeDescr.getFields().get(fieldName));
        }
        typeDescr.setFields(fieldMap);
    }

    protected TypeFieldDescr buildInheritedFieldDescrFromDefinition(FactField fld, TypeDeclarationDescr typeDescr) {
        TypeFieldDescr inheritedFldDescr = new TypeFieldDescr();
        inheritedFldDescr.setFieldName(fld.getName());
        inheritedFldDescr.setResource(typeDescr.getResource());
        PatternDescr fldType = new PatternDescr();
        fldType.setObjectType(((FieldDefinition)fld).getTypeName());
        inheritedFldDescr.setPattern(fldType);
        if (fld.isKey()) {
            AnnotationDescr keyAnnotation = new AnnotationDescr(Key.class.getCanonicalName());
            keyAnnotation.setFullyQualifiedName(Key.class.getCanonicalName());
            keyAnnotation.setResource(typeDescr.getResource());
            inheritedFldDescr.addAnnotation(keyAnnotation);
        }
        inheritedFldDescr.setIndex(((FieldDefinition)fld).getDeclIndex());
        inheritedFldDescr.setInherited(true);
        String initExprOverride = ((FieldDefinition)fld).getInitExpr();
        int overrideCount = 0;
        for (TypeFieldDescr localField : typeDescr.getFields().values()) {
            Alias alias = AnnotationFactory.getTypedAnnotation((AnnotatedBaseDescr)localField, Alias.class);
            if (alias == null || !fld.getName().equals(alias.value().replaceAll("\"", "")) || localField.getInitExpr() == null) continue;
            ++overrideCount;
            initExprOverride = localField.getInitExpr();
        }
        if (overrideCount > 1) {
            initExprOverride = null;
        }
        inheritedFldDescr.setInitExpr(initExprOverride);
        return inheritedFldDescr;
    }

    public void addDeclarationToPackagePreservingOrder(TypeDeclaration type, AbstractClassTypeDeclarationDescr typeDescr, InternalKnowledgePackage tgtPackage, Map<String, PackageRegistry> pkgRegistryMap) {
        Collection<QualifiedName> parents = this.taxonomy.get(new QualifiedName(type.getFullName()));
        int index = this.getSortedDescriptors().indexOf(typeDescr);
        if (parents != null && !parents.isEmpty()) {
            for (QualifiedName parentName : parents) {
                TypeDeclaration parentDeclaration;
                String nameSpace = parentName.getNamespace();
                String name = parentName.getName();
                PackageRegistry parentPkgRegistry = pkgRegistryMap.get(nameSpace);
                if (parentPkgRegistry == null || (parentDeclaration = parentPkgRegistry.getPackage().getTypeDeclaration(name)) == null || parentDeclaration.getNature() != TypeDeclaration.Nature.DEFINITION) continue;
                index = Math.max(index, parentDeclaration.getOrder());
            }
        }
        type.setOrder(index + 1);
        tgtPackage.addTypeDeclaration(type);
    }
}

