/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler.ast;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.mvelcompiler.ast.TypedExpression;

public class FieldToAccessorTExpr
implements TypedExpression {
    private final TypedExpression scope;
    private final Type type;
    private final Method accessor;
    private final List<TypedExpression> arguments;

    public FieldToAccessorTExpr(TypedExpression scope, Method accessor, List<TypedExpression> arguments) {
        this.scope = scope;
        this.accessor = accessor;
        this.type = accessor.getGenericReturnType();
        this.arguments = arguments;
    }

    public FieldToAccessorTExpr(TypedExpression scope, Method accessor) {
        this(scope, accessor, Collections.emptyList());
    }

    @Override
    public Optional<Type> getType() {
        return Optional.of(this.type);
    }

    @Override
    public Node toJavaExpression() {
        List arguments = this.arguments.stream().map(a -> (Expression)a.toJavaExpression()).collect(Collectors.toList());
        return new MethodCallExpr((Expression)this.scope.toJavaExpression(), this.accessor.getName(), NodeList.nodeList(arguments));
    }

    public String toString() {
        return "FieldToAccessorTExpr{ scope=" + this.scope.toString() + ", type=" + this.type + ", accessor=" + this.accessor + '}';
    }
}

