/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler.ast;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.drools.mvelcompiler.ast.TypedExpression;

public class BinaryTExpr
implements TypedExpression {
    private static final List<Type> PRIORITIZED_TYPES = Arrays.asList(String.class, BigDecimal.class, BigInteger.class, Double.class, Double.TYPE, Long.class, Long.TYPE, Float.class, Float.class, Integer.class, Integer.TYPE);
    private final TypedExpression left;
    private final TypedExpression right;
    private final BinaryExpr.Operator operator;

    public BinaryTExpr(TypedExpression left, TypedExpression right, BinaryExpr.Operator operator) {
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    public TypedExpression getLeft() {
        return this.left;
    }

    public TypedExpression getRight() {
        return this.right;
    }

    public BinaryExpr.Operator getOperator() {
        return this.operator;
    }

    @Override
    public Optional<Type> getType() {
        Optional<Type> leftType = this.left.getType();
        Optional<Type> rightType = this.right.getType();
        if (!leftType.isPresent()) {
            return rightType;
        }
        if (!rightType.isPresent()) {
            return leftType;
        }
        return Optional.of(BinaryTExpr.combine(leftType.get(), rightType.get()));
    }

    @Override
    public Node toJavaExpression() {
        return new BinaryExpr((Expression)this.left.toJavaExpression(), (Expression)this.right.toJavaExpression(), this.operator);
    }

    private static Type combine(Type t1, Type t2) {
        for (Type t : PRIORITIZED_TYPES) {
            if (t1 != t && t2 != t) continue;
            return t;
        }
        return t2;
    }
}

