/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.mvel.parser.MvelParser;
import org.drools.mvel.parser.ast.expr.ModifyStatement;
import org.drools.mvel.parser.ast.expr.WithStatement;
import org.drools.mvelcompiler.CompiledBlockResult;
import org.drools.mvelcompiler.CompiledExpressionResult;
import org.drools.mvelcompiler.LHSPhase;
import org.drools.mvelcompiler.PreprocessPhase;
import org.drools.mvelcompiler.RHSPhase;
import org.drools.mvelcompiler.ReProcessRHSPhase;
import org.drools.mvelcompiler.ast.TypedExpression;
import org.drools.mvelcompiler.context.MvelCompilerContext;

public class MvelCompiler {
    private final MvelCompilerContext mvelCompilerContext;
    private final PreprocessPhase preprocessPhase = new PreprocessPhase();

    public MvelCompiler(MvelCompilerContext mvelCompilerContext) {
        this.mvelCompilerContext = mvelCompilerContext;
    }

    public CompiledExpressionResult compileExpression(String mvelExpressionString) {
        Expression parsedExpression = MvelParser.parseExpression((String)mvelExpressionString);
        Node compiled = this.compileExpression((Node)parsedExpression);
        return new CompiledExpressionResult((Expression)compiled);
    }

    public CompiledBlockResult compileStatement(String mvelBlock) {
        BlockStmt mvelExpression = MvelParser.parseBlock((String)mvelBlock);
        this.preprocessPhase.removeEmptyStmt(mvelExpression);
        HashSet<String> allUsedBindings = new HashSet<String>();
        List modifyUsedBindings = mvelExpression.findAll(ModifyStatement.class).stream().flatMap(this::transformStatementWithPreprocessing).collect(Collectors.toList());
        List withUsedBindings = mvelExpression.findAll(WithStatement.class).stream().flatMap(this::transformStatementWithPreprocessing).collect(Collectors.toList());
        allUsedBindings.addAll(modifyUsedBindings);
        allUsedBindings.addAll(withUsedBindings);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (Statement s : mvelExpression.getStatements()) {
            this.processWithMvelCompiler(statements, s);
        }
        return new CompiledBlockResult(statements).setUsedBindings(allUsedBindings);
    }

    private Stream<String> transformStatementWithPreprocessing(Statement s) {
        PreprocessPhase.PreprocessPhaseResult invoke = this.preprocessPhase.invoke(s);
        s.remove();
        return invoke.getUsedBindings().stream();
    }

    private void processWithMvelCompiler(List<Statement> statements, Statement s) {
        if (s.isBlockStmt()) {
            BlockStmt body = s.asBlockStmt();
            for (Statement children : body.getStatements()) {
                this.processWithMvelCompiler(statements, children);
            }
        } else if (s instanceof IfStmt) {
            IfStmt ifStmt = s.asIfStmt();
            NodeList thenStmts = NodeList.nodeList((Node[])new Statement[0]);
            this.processWithMvelCompiler((List<Statement>)thenStmts, ifStmt.getThenStmt());
            NodeList elseStmts = NodeList.nodeList((Node[])new Statement[0]);
            ifStmt.getElseStmt().ifPresent(elseStmt -> this.processWithMvelCompiler((List<Statement>)elseStmts, (Statement)elseStmt));
            statements.add((Statement)new IfStmt(ifStmt.getCondition(), (Statement)new BlockStmt(thenStmts), (Statement)new BlockStmt(elseStmts)));
        } else {
            statements.add((Statement)this.compileStatement((Node)s));
        }
    }

    private Node compileStatement(Node n) {
        TypedExpression rhs = new RHSPhase(this.mvelCompilerContext).invoke(n);
        TypedExpression lhs = new LHSPhase(this.mvelCompilerContext, Optional.ofNullable(rhs)).invoke(n);
        Optional<TypedExpression> postProcessedRHS = new ReProcessRHSPhase(this.mvelCompilerContext).invoke(rhs, lhs);
        TypedExpression postProcessedLHS = postProcessedRHS.map(ppr -> new LHSPhase(this.mvelCompilerContext, Optional.of(ppr)).invoke(n)).orElse(lhs);
        return postProcessedLHS.toJavaExpression();
    }

    private Node compileExpression(Node n) {
        TypedExpression rhs = new RHSPhase(this.mvelCompilerContext).invoke(n);
        return rhs.toJavaExpression();
    }
}

