/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler.ast;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import java.lang.reflect.Type;
import java.util.Optional;
import org.drools.mvelcompiler.ast.TypedExpression;
import org.drools.mvelcompiler.util.TypeUtils;

public class VariableDeclaratorTExpr
implements TypedExpression {
    private final Node originalNode;
    private final String name;
    private final Type type;
    private final Optional<TypedExpression> initExpression;

    public VariableDeclaratorTExpr(Node originalNode, String name, Type type, Optional<TypedExpression> initExpression) {
        this.originalNode = originalNode;
        this.name = name;
        this.type = type;
        this.initExpression = initExpression;
    }

    @Override
    public Optional<Type> getType() {
        return Optional.of(this.type);
    }

    @Override
    public Node toJavaExpression() {
        Optional optInitType = this.initExpression.flatMap(TypedExpression::getType);
        com.github.javaparser.ast.type.Type jpType = TypeUtils.toJPType(this.type);
        return this.initExpression.map(ie -> {
            Expression initializer = (Expression)ie.toJavaExpression();
            if (!optInitType.isPresent() || ((Type)optInitType.get()).equals(Object.class)) {
                initializer = new CastExpr(jpType, (Expression)new EnclosedExpr(initializer));
            }
            return new VariableDeclarationExpr(new VariableDeclarator(jpType, this.name, initializer));
        }).orElse((Node)new VariableDeclarationExpr(jpType, this.name));
    }

    public String toString() {
        return "VariableDeclaratorTExpr{originalNode=" + this.originalNode + ", name=" + this.name + ", initExpression=" + this.initExpression + '}';
    }
}

