/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.simulation.PathFinder;
import org.jbpm.simulation.PathFinderFactory;
import org.jbpm.simulation.PathFormatConverter;
import org.jbpm.simulation.converter.SimulationFilterPathFormatConverter;
import org.jbpm.simulation.impl.BPMN2SimulationDataProvider;
import org.jbpm.simulation.impl.SimulationPath;
import org.jbpm.workflow.core.NodeContainer;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;

public class BPMN2SimulationDataProviderTest {
    @Test
    public void testReadAllSimulationProperties() {
        BPMN2SimulationDataProvider provider = new BPMN2SimulationDataProvider(this.getClass().getResourceAsStream("/BPMN2-UserTaskWithSimulationMetaData.bpmn2"));
        Map data = provider.getSimulationDataForNode(new Node(){

            public List<Connection> getOutgoingConnections(String type) {
                return null;
            }

            public Map<String, List<Connection>> getOutgoingConnections() {
                return null;
            }

            public NodeContainer getNodeContainer() {
                return null;
            }

            public String getName() {
                return "Hello";
            }

            public Object getMetaData(String name) {
                return null;
            }

            public Map<String, Object> getMetaData() {
                HashMap<String, Object> metaData = new HashMap<String, Object>();
                metaData.put("UniqueId", "_2B5B707D-3458-475C-943D-74F20B13AF20");
                return metaData;
            }

            public List<Connection> getIncomingConnections(String type) {
                return null;
            }

            public Map<String, List<Connection>> getIncomingConnections() {
                return null;
            }

            public long getId() {
                return 2L;
            }
        });
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)9L, (long)data.size());
        Assert.assertTrue((boolean)data.containsKey("unitcost"));
        Assert.assertTrue((boolean)data.containsKey("distributiontype"));
        Assert.assertTrue((boolean)data.containsKey("standarddeviation"));
        Assert.assertTrue((boolean)data.containsKey("mean"));
        Assert.assertTrue((boolean)data.containsKey("quantity"));
        Assert.assertTrue((boolean)data.containsKey("standarddeviation"));
        Assert.assertTrue((boolean)data.containsKey("timeunit"));
        Assert.assertTrue((boolean)data.containsKey("workinghours"));
        Assert.assertTrue((boolean)data.containsKey("probability"));
    }

    @Test
    public void testReadProbabilitySimulationProperties() {
        BPMN2SimulationDataProvider provider = new BPMN2SimulationDataProvider(this.getClass().getResourceAsStream("/BPMN2-ExclusiveSplitWithSimulationProps.bpmn2"));
        Map data = provider.getSimulationDataForNode(new Node(){

            public List<Connection> getOutgoingConnections(String type) {
                return null;
            }

            public Map<String, List<Connection>> getOutgoingConnections() {
                return null;
            }

            public NodeContainer getNodeContainer() {
                return null;
            }

            public String getName() {
                return "Hello";
            }

            public Object getMetaData(String name) {
                return null;
            }

            public Map<String, Object> getMetaData() {
                HashMap<String, Object> metaData = new HashMap<String, Object>();
                metaData.put("UniqueId", "_575A78C8-C34A-445E-8B2F-BB990B513A03");
                return metaData;
            }

            public List<Connection> getIncomingConnections(String type) {
                return null;
            }

            public Map<String, List<Connection>> getIncomingConnections() {
                return null;
            }

            public long getId() {
                return 2L;
            }
        });
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)1L, (long)data.size());
        Assert.assertTrue((boolean)data.containsKey("probability"));
    }

    @Test
    public void testExclusiveSplit() throws IOException {
        PathFinder finder = PathFinderFactory.getInstance((InputStream)this.getClass().getResourceAsStream("/BPMN2-ExclusiveSplitWithSimulationProps.bpmn2"));
        List paths = (List)finder.findPaths((PathFormatConverter)new SimulationFilterPathFormatConverter());
        Assert.assertNotNull((Object)paths);
        Assert.assertEquals((long)2L, (long)paths.size());
        BPMN2SimulationDataProvider provider = new BPMN2SimulationDataProvider(this.getClass().getResourceAsStream("/BPMN2-ExclusiveSplitWithSimulationProps.bpmn2"));
        double probabilityOfPathOne = provider.calculatePathProbability((SimulationPath)paths.get(0));
        double probabilityOfPathTwo = provider.calculatePathProbability((SimulationPath)paths.get(1));
        Assert.assertTrue((0.7 == probabilityOfPathOne ? 1 : 0) != 0);
        Assert.assertTrue((0.3 == probabilityOfPathTwo ? 1 : 0) != 0);
        System.out.println("Probability 1: " + probabilityOfPathOne + " probabilit 2: " + probabilityOfPathTwo);
    }
}

