/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.SubProcess;
import org.jbpm.simulation.PathFinder;
import org.jbpm.simulation.PathFinderFactory;
import org.jbpm.simulation.helper.TestUtils;
import org.jbpm.simulation.util.BPMN2Utils;
import org.junit.Assert;
import org.junit.Test;

public class ContainerPathFinderTest {
    @Test
    public void testFindPathFromProcess() {
        ArrayList<String> expectedIds = new ArrayList<String>();
        expectedIds.add("_1");
        expectedIds.add("_1-_2");
        expectedIds.add("_2");
        expectedIds.add("_2-_3");
        expectedIds.add("_3");
        Definitions defs = BPMN2Utils.getDefinitions((InputStream)this.getClass().getResourceAsStream("/BPMN2-UserTask.bpmn2"));
        Process process = null;
        List rootElements = defs.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            process = (Process)root;
            break;
        }
        PathFinder finder = PathFinderFactory.getInstance(process);
        List paths = finder.findPaths();
        Assert.assertNotNull((Object)paths);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertTrue((boolean)TestUtils.matchExpected(paths, expectedIds));
        TestUtils.printOutPaths(paths, "testFindPathFromProcess");
    }

    @Test
    public void testFindPathFromAdHocSubprocess() {
        ArrayList<String> expectedIds1 = new ArrayList<String>();
        expectedIds1.add("_2-1");
        ArrayList<String> expectedIds2 = new ArrayList<String>();
        expectedIds2.add("_2-2");
        expectedIds2.add("_2-2-_2-3");
        expectedIds2.add("_2-3");
        Definitions defs = BPMN2Utils.getDefinitions((InputStream)this.getClass().getResourceAsStream("/BPMN2-AdHocSubProcess.bpmn2"));
        Process process = null;
        List rootElements = defs.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            process = (Process)root;
            break;
        }
        Assert.assertNotNull(process);
        FlowElementsContainer container = null;
        for (FlowElement element : process.getFlowElements()) {
            if (!(element instanceof AdHocSubProcess)) continue;
            container = (FlowElementsContainer)element;
            break;
        }
        Assert.assertNotNull(container);
        PathFinder finder = PathFinderFactory.getInstance(container);
        List paths = finder.findPaths();
        Assert.assertNotNull((Object)paths);
        Assert.assertEquals((long)2L, (long)paths.size());
        Assert.assertTrue((boolean)TestUtils.matchExpected(paths, expectedIds1, expectedIds2));
        TestUtils.printOutPaths(paths, "testFindPathFromAdHocSubprocess");
    }

    @Test
    public void testFindPathFromEmbeddedSubprocess() throws IOException {
        ArrayList<String> expectedIds1 = new ArrayList<String>();
        expectedIds1.add("StartEvent_2");
        expectedIds1.add("SequenceFlow_3");
        expectedIds1.add("ExclusiveGateway_1");
        expectedIds1.add("SequenceFlow_5");
        expectedIds1.add("ScriptTask_1");
        expectedIds1.add("SequenceFlow_7");
        expectedIds1.add("ExclusiveGateway_2");
        expectedIds1.add("SequenceFlow_8");
        expectedIds1.add("EndEvent_2");
        ArrayList<String> expectedIds2 = new ArrayList<String>();
        expectedIds2.add("StartEvent_2");
        expectedIds2.add("SequenceFlow_3");
        expectedIds2.add("ExclusiveGateway_1");
        expectedIds2.add("SequenceFlow_10");
        expectedIds2.add("ScriptTask_2");
        expectedIds2.add("SequenceFlow_11");
        expectedIds2.add("ExclusiveGateway_2");
        expectedIds2.add("SequenceFlow_8");
        expectedIds2.add("EndEvent_2");
        Definitions defs = BPMN2Utils.getDefinitions((InputStream)this.getClass().getResourceAsStream("/BPMN2-EmbeddedSubProcessWithExclusiveSplit.bpmn2"));
        Process process = null;
        List rootElements = defs.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            process = (Process)root;
            break;
        }
        Assert.assertNotNull(process);
        FlowElementsContainer container = null;
        for (FlowElement element : process.getFlowElements()) {
            if (!(element instanceof SubProcess)) continue;
            container = (FlowElementsContainer)element;
            break;
        }
        Assert.assertNotNull(container);
        PathFinder finder = PathFinderFactory.getInstance(container);
        List paths = finder.findPaths();
        Assert.assertNotNull((Object)paths);
        Assert.assertEquals((long)2L, (long)paths.size());
        Assert.assertTrue((boolean)TestUtils.matchExpected(paths, expectedIds1, expectedIds2));
        TestUtils.printOutPaths(paths, "testFindPathFromEmbeddedSubprocess");
    }
}

