/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation;

import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.drools.simulation.fluent.simulation.SimulationFluent;
import org.drools.simulation.fluent.simulation.impl.DefaultSimulationFluent;
import org.jbpm.simulation.PathFinder;
import org.jbpm.simulation.PathFinderFactory;
import org.jbpm.simulation.PathFormatConverter;
import org.jbpm.simulation.SimulationContext;
import org.jbpm.simulation.SimulationContextFactory;
import org.jbpm.simulation.SimulationDataProvider;
import org.jbpm.simulation.converter.SimulationFilterPathFormatConverter;
import org.jbpm.simulation.helper.HardCodedSimulationDataProvider;
import org.jbpm.simulation.helper.TestUtils;
import org.jbpm.simulation.impl.BPMN2SimulationDataProvider;
import org.jbpm.simulation.impl.SimulateProcessPathCommand;
import org.jbpm.simulation.impl.SimulationPath;
import org.junit.Test;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.Command;
import org.kie.api.io.ResourceType;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class SimulationFluentTest {
    @Test
    public void testSimulationFluent() throws Exception {
        PathFinder finder = PathFinderFactory.getInstance((InputStream)this.getClass().getResourceAsStream("/BPMN2-ExclusiveSplit.bpmn2"));
        List paths = (List)finder.findPaths((PathFormatConverter)new SimulationFilterPathFormatConverter());
        SimulationContext context = SimulationContextFactory.newContext((SimulationDataProvider)new HardCodedSimulationDataProvider());
        ReleaseId releaseId = TestUtils.createKJarWithMultipleResources("TestKbase", new String[]{"BPMN2-ExclusiveSplit.bpmn2"}, new ResourceType[]{ResourceType.BPMN2});
        DefaultSimulationFluent f = new DefaultSimulationFluent();
        ((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)f.newPath("path1").newStep(0L)).newKieSession(releaseId, "TestKbase.KSession1").end("ROOT", StatefulKnowledgeSession.class.getName())).addCommand((Command)new SimulateProcessPathCommand("com.sample.test", context, (SimulationPath)paths.get(0))).newPath("path2").newStep(10L, TimeUnit.MINUTES)).newKieSession(releaseId, "TestKbase.KSession1").end("ROOT", StatefulKnowledgeSession.class.getName())).addCommand((Command)new SimulateProcessPathCommand("com.sample.test", context, (SimulationPath)paths.get(1))).runSimulation();
    }

    @Test
    public void testSimulationFluentWithUserTask() throws Exception {
        PathFinder finder = PathFinderFactory.getInstance((InputStream)this.getClass().getResourceAsStream("/BPMN2-UserTask.bpmn2"));
        List paths = (List)finder.findPaths((PathFormatConverter)new SimulationFilterPathFormatConverter());
        SimulationContext context = SimulationContextFactory.newContext((SimulationDataProvider)new HardCodedSimulationDataProvider());
        ReleaseId releaseId = TestUtils.createKJarWithMultipleResources("TestKbase", new String[]{"BPMN2-UserTask.bpmn2"}, new ResourceType[]{ResourceType.BPMN2});
        DefaultSimulationFluent f = new DefaultSimulationFluent();
        ((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)f.newPath("path1").newStep(0L)).newKieSession(releaseId, "TestKbase.KSession1").end("ROOT", StatefulKnowledgeSession.class.getName())).addCommand((Command)new SimulateProcessPathCommand("UserTask", context, (SimulationPath)paths.get(0))).newStep(5L, TimeUnit.MINUTES)).newKieSession(releaseId, "TestKbase.KSession1").end("ROOT", StatefulKnowledgeSession.class.getName())).addCommand((Command)new SimulateProcessPathCommand("UserTask", context, (SimulationPath)paths.get(0))).newStep(10L, TimeUnit.MINUTES)).newKieSession(releaseId, "TestKbase.KSession1").end("ROOT", StatefulKnowledgeSession.class.getName())).addCommand((Command)new SimulateProcessPathCommand("UserTask", context, (SimulationPath)paths.get(0))).newStep(15L, TimeUnit.MINUTES)).newKieSession(releaseId, "TestKbase.KSession1").end("ROOT", StatefulKnowledgeSession.class.getName())).addCommand((Command)new SimulateProcessPathCommand("UserTask", context, (SimulationPath)paths.get(0))).newStep(20L, TimeUnit.MINUTES)).newKieSession(releaseId, "TestKbase.KSession1").end("ROOT", StatefulKnowledgeSession.class.getName())).addCommand((Command)new SimulateProcessPathCommand("UserTask", context, (SimulationPath)paths.get(0))).newStep(25L, TimeUnit.MINUTES)).newKieSession(releaseId, "TestKbase.KSession1").end("ROOT", StatefulKnowledgeSession.class.getName())).addCommand((Command)new SimulateProcessPathCommand("UserTask", context, (SimulationPath)paths.get(0))).runSimulation();
        System.out.println("Resource utilization for UserTask Hello: " + context.getStaffPoolManager().getActivityPool("Hello").getResourceUtilization());
    }

    @Test
    public void testSimulationFluentWithUserTaskBPMN2DataProvider() throws Exception {
        PathFinder finder = PathFinderFactory.getInstance((InputStream)this.getClass().getResourceAsStream("/BPMN2-UserTaskWithSimulationMetaData.bpmn2"));
        List paths = (List)finder.findPaths((PathFormatConverter)new SimulationFilterPathFormatConverter());
        SimulationContext context = SimulationContextFactory.newContext((SimulationDataProvider)new BPMN2SimulationDataProvider(this.getClass().getResourceAsStream("/BPMN2-UserTaskWithSimulationMetaData.bpmn2")));
        ReleaseId releaseId = TestUtils.createKJarWithMultipleResources("TestKbase", new String[]{"BPMN2-UserTaskWithSimulationMetaData.bpmn2"}, new ResourceType[]{ResourceType.BPMN2});
        DefaultSimulationFluent f = new DefaultSimulationFluent();
        ((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)f.newPath("path1").newStep(0L)).newKieSession(releaseId, "TestKbase.KSession1").end("ROOT", StatefulKnowledgeSession.class.getName())).addCommand((Command)new SimulateProcessPathCommand("UserTask", context, (SimulationPath)paths.get(0))).newStep(5L, TimeUnit.MINUTES)).newKieSession(releaseId, "TestKbase.KSession1").end("ROOT", StatefulKnowledgeSession.class.getName())).addCommand((Command)new SimulateProcessPathCommand("UserTask", context, (SimulationPath)paths.get(0))).newStep(10L, TimeUnit.MINUTES)).newKieSession(releaseId, "TestKbase.KSession1").end("ROOT", StatefulKnowledgeSession.class.getName())).addCommand((Command)new SimulateProcessPathCommand("UserTask", context, (SimulationPath)paths.get(0))).newStep(15L, TimeUnit.MINUTES)).newKieSession(releaseId, "TestKbase.KSession1").end("ROOT", StatefulKnowledgeSession.class.getName())).addCommand((Command)new SimulateProcessPathCommand("UserTask", context, (SimulationPath)paths.get(0))).newStep(20L, TimeUnit.MINUTES)).newKieSession(releaseId, "TestKbase.KSession1").end("ROOT", StatefulKnowledgeSession.class.getName())).addCommand((Command)new SimulateProcessPathCommand("UserTask", context, (SimulationPath)paths.get(0))).newStep(25L, TimeUnit.MINUTES)).newKieSession(releaseId, "TestKbase.KSession1").end("ROOT", StatefulKnowledgeSession.class.getName())).addCommand((Command)new SimulateProcessPathCommand("UserTask", context, (SimulationPath)paths.get(0))).runSimulation();
        System.out.println("Resource utilization for UserTask Hello: " + context.getStaffPoolManager().getActivityPool("Hello").getResourceUtilization());
    }
}

