/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation;

import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.drools.core.time.SessionPseudoClock;
import org.jbpm.simulation.PathFinder;
import org.jbpm.simulation.PathFinderFactory;
import org.jbpm.simulation.PathFormatConverter;
import org.jbpm.simulation.SimulationContext;
import org.jbpm.simulation.SimulationContextFactory;
import org.jbpm.simulation.SimulationDataProvider;
import org.jbpm.simulation.SimulationRepository;
import org.jbpm.simulation.converter.SimulationFilterPathFormatConverter;
import org.jbpm.simulation.helper.HardCodedSimulationDataProvider;
import org.jbpm.simulation.helper.TestUtils;
import org.jbpm.simulation.impl.BPMN2SimulationDataProvider;
import org.jbpm.simulation.impl.SimulationPath;
import org.jbpm.simulation.impl.WorkingMemorySimulationRepository;
import org.junit.Assert;
import org.junit.Test;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class WorkingMemorySimulationRepositoryTest {
    @Test
    public void testWorkingMemorySimulationRepositoryPrintoutRule() {
        PathFinder finder = PathFinderFactory.getInstance((InputStream)this.getClass().getResourceAsStream("/BPMN2-UserTask.bpmn2"));
        List paths = (List)finder.findPaths((PathFormatConverter)new SimulationFilterPathFormatConverter());
        SimulationContext context = SimulationContextFactory.newContext((SimulationDataProvider)new HardCodedSimulationDataProvider(), (SimulationRepository)new WorkingMemorySimulationRepository(true, new String[]{"printOutRule.drl"}));
        for (SimulationPath path : paths) {
            context.setCurrentPath(path);
            StatefulKnowledgeSession session = TestUtils.createSession("BPMN2-UserTask.bpmn2");
            context.setClock((SessionPseudoClock)session.getSessionClock());
            context.getClock().advanceTime(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            session.startProcess("UserTask");
            System.out.println("#####################################");
        }
    }

    @Test
    public void testWorkingMemorySimulationRepositoryCEPRule() {
        PathFinder finder = PathFinderFactory.getInstance((InputStream)this.getClass().getResourceAsStream("/BPMN2-TwoUserTasks.bpmn2"));
        List paths = (List)finder.findPaths((PathFormatConverter)new SimulationFilterPathFormatConverter());
        SimulationContext context = SimulationContextFactory.newContext((SimulationDataProvider)new BPMN2SimulationDataProvider(this.getClass().getResourceAsStream("/BPMN2-TwoUserTasks.bpmn2")), (SimulationRepository)new WorkingMemorySimulationRepository(new String[]{"default.simulation.rules.drl"}));
        for (int i = 0; i < 5; ++i) {
            for (SimulationPath path : paths) {
                context.setCurrentPath(path);
                StatefulKnowledgeSession session = TestUtils.createSession("BPMN2-TwoUserTasks.bpmn2");
                context.setClock((SessionPseudoClock)session.getSessionClock());
                context.getClock().advanceTime(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                session.startProcess("BPMN2-TwoUserTasks");
                System.out.println("#####################################");
            }
        }
        ((WorkingMemorySimulationRepository)context.getRepository()).fireAllRules();
        List results = ((WorkingMemorySimulationRepository)context.getRepository()).getAggregatedEvents();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)3L, (long)results.size());
    }
}

