/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.impl;

import java.util.ArrayList;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.event.DefaultProcessEventListener;
import org.drools.core.time.SessionPseudoClock;
import org.jbpm.simulation.SimulationContext;
import org.jbpm.simulation.SimulationInfo;
import org.jbpm.simulation.impl.SimulationNodeInstanceFactoryRegistry;
import org.jbpm.simulation.impl.SimulationPath;
import org.jbpm.simulation.impl.events.ProcessInstanceEndSimulationEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.Context;

public class SimulateProcessPathCommand
implements GenericCommand<KieSession> {
    private static final long serialVersionUID = 3485947845100224769L;
    private String processId;
    private SimulationContext simContext;
    private SimulationPath path;

    public SimulateProcessPathCommand(String processId, SimulationContext context, SimulationPath path) {
        this.processId = processId;
        this.simContext = context;
        this.path = path;
    }

    public KieSession execute(Context context) {
        KieSession session = ((KnowledgeCommandContext)context).getKieSession();
        session.getEnvironment().set("NodeInstanceFactoryRegistry", (Object)SimulationNodeInstanceFactoryRegistry.getInstance());
        this.simContext.setClock((SessionPseudoClock)session.getSessionClock());
        this.simContext.setCurrentPath(this.path);
        SimulationInfo simInfo = this.simContext.getRepository().getSimulationInfo();
        if (simInfo != null) {
            simInfo.setProcessName(session.getKieBase().getProcess(this.processId).getName());
            simInfo.setProcessVersion(session.getKieBase().getProcess(this.processId).getVersion());
        }
        this.simContext.resetMaxEndTime();
        this.simContext.getExecutedNodes().clear();
        this.simContext.incrementProcessInstanceId();
        long instanceId = -1L;
        ProcessInstance pi = null;
        if (this.path.getSignalName() != null) {
            final ArrayList instances = new ArrayList();
            session.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

                public void beforeProcessStarted(ProcessStartedEvent event) {
                    instances.add(event.getProcessInstance());
                }
            });
            session.signalEvent(this.path.getSignalName(), null);
            if (!instances.isEmpty()) {
                pi = (ProcessInstance)instances.get(0);
                instanceId = (long)session.getId() + pi.getId();
            }
        } else {
            pi = session.startProcess(this.processId);
            instanceId = (long)session.getId() + pi.getId();
        }
        this.simContext.getRepository().storeEvent(new ProcessInstanceEndSimulationEvent(this.processId, instanceId, this.simContext.getStartTime(), this.simContext.getMaxEndTime(), this.path.getPathId(), pi.getProcessName(), pi.getProcess().getVersion()));
        return session;
    }
}

