/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.impl.ht;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.random.RandomData;
import org.apache.commons.math3.random.RandomDataImpl;
import org.jbpm.simulation.SimulationContext;
import org.jbpm.simulation.SimulationDataProvider;
import org.jbpm.simulation.TimeGenerator;
import org.jbpm.simulation.TimeGeneratorFactory;
import org.jbpm.simulation.impl.ht.Range;
import org.jbpm.simulation.impl.ht.RangeChain;
import org.jbpm.simulation.impl.ht.StaffPool;
import org.jbpm.simulation.util.SimulationUtils;
import org.kie.api.definition.process.Node;

public class StaffPoolImpl
implements StaffPool {
    private Map<String, Object> properties;
    private int poolSize;
    private long duration;
    private List<Long> allocatedTill = new ArrayList<Long>();
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private long workingHours = 28800000L;
    private long poolCapacity = 0L;
    private long performedWork = 0L;
    private RandomData randomizer = new RandomDataImpl();
    private double resourceCost;
    private TimeUnit elementTimeUnit;
    private TimeGenerator timeGenerator;
    private Map<String, List<Long>> allocatedRanges = new HashMap<String, List<Long>>();
    private RangeChain rangeChain = new RangeChain();

    public StaffPoolImpl(String processId, Node element, double simulationDuration) {
        SimulationDataProvider provider = SimulationContext.getContext().getDataProvider();
        this.properties = provider.getSimulationDataForNode(element);
        this.timeGenerator = TimeGeneratorFactory.newTimeGenerator(this.properties);
        this.elementTimeUnit = SimulationUtils.getTimeUnit(this.properties);
        this.poolSize = (int)SimulationUtils.asDouble(this.properties.get("quantity"));
        this.duration = this.timeGenerator.generateTime();
        String workingHoursRange = (String)this.properties.get("working.hours.range");
        if (workingHoursRange != null) {
            String[] ranges;
            for (String range : ranges = workingHoursRange.split(",")) {
                String[] rangeElems = range.split("-");
                this.rangeChain.addRange(new Range(Integer.parseInt(rangeElems[0]), Integer.parseInt(rangeElems[1]), this.poolSize));
            }
        } else {
            long workingHoursOpt = (long)SimulationUtils.asDouble(this.properties.get("workinghours"));
            if (workingHoursOpt > 0L) {
                this.workingHours = this.timeUnit.convert(workingHoursOpt, TimeUnit.HOURS);
            }
            this.rangeChain.addRange(new Range(0, 24, this.poolSize));
        }
        this.poolCapacity = (long)this.poolSize * this.workingHours;
        if (simulationDuration > 1.0) {
            this.poolCapacity = (long)((double)this.poolCapacity * simulationDuration);
        }
        this.resourceCost = SimulationUtils.asDouble(this.properties.get("unitcost"));
    }

    protected long allocate(long startTime, long duration) {
        this.performedWork += duration;
        return this.rangeChain.allocateWork(startTime, duration);
    }

    @Override
    public long allocate(long startTime) {
        return this.allocate(startTime, this.duration);
    }

    @Override
    public long allocate(long startTime, Node element) {
        long duration = this.duration = this.timeGenerator.generateTime();
        return this.allocate(startTime, duration);
    }

    @Override
    public double getResourceUtilization() {
        if (this.poolCapacity == 0L) {
            return 0.0;
        }
        return this.performedWork * 100L / this.poolCapacity;
    }

    @Override
    public double getResourceCost() {
        return this.resourceCost;
    }

    @Override
    public TimeUnit getElementTimeUnit() {
        return this.elementTimeUnit;
    }

    protected List<Long> findAllocatedRange(long stringTime) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(stringTime);
        int hour = c.get(11);
        Set<String> ranges = this.allocatedRanges.keySet();
        for (String range : ranges) {
            String[] elems = range.split("-");
            int lower = Integer.parseInt(elems[0]);
            int upper = Integer.parseInt(elems[1]);
            if (hour < lower || hour > upper) continue;
            return this.allocatedRanges.get(range);
        }
        return null;
    }
}

