/*
 * Decompiled with CFR 0.152.
 */
import com.maxmind.geoip.LookupService;
import java.io.IOException;

class BenchmarkGeoIP {
    static String[] ipstring = new String[]{"24.24.24.24", "80.24.24.80", "200.24.24.40", "68.24.24.46"};

    BenchmarkGeoIP() {
    }

    static void testGeoipCountry(int flags, String msg, int numlookups) {
        try {
            LookupService cl = new LookupService("/usr/local/share/GeoIP/GeoIP.dat", flags);
            int i4 = 0;
            long t1 = System.currentTimeMillis();
            for (int i2 = 0; i2 < numlookups; ++i2) {
                cl.getCountry(ipstring[i4]);
                i4 = (i4 + 1) % ipstring.length;
            }
            long t2 = System.currentTimeMillis();
            double t3 = (double)(t2 - t1) / 1000.0;
            System.out.println(msg);
            System.out.println(numlookups + " lookups made in " + t3 + " seconds ");
        }
        catch (IOException e) {
            System.out.println("error");
        }
    }

    static void testGeoipRegion(int flags, String msg, int numlookups) {
        try {
            LookupService cl = new LookupService("/usr/local/share/GeoIP/GeoIPRegion.dat", flags);
            int i4 = 0;
            long t1 = System.currentTimeMillis();
            for (int i2 = 0; i2 < numlookups; ++i2) {
                cl.getRegion(ipstring[i4]);
                i4 = (i4 + 1) % ipstring.length;
            }
            long t2 = System.currentTimeMillis();
            double t3 = (double)(t2 - t1) / 1000.0;
            System.out.println(msg);
            System.out.println(numlookups + " lookups made in " + t3 + " seconds ");
        }
        catch (IOException e) {
            System.out.println("error");
        }
    }

    static void testGeoipCity(int flags, String msg, int numlookups) {
        try {
            LookupService cl = new LookupService("/usr/local/share/GeoIP/GeoIPCity.dat", flags);
            int i4 = 0;
            long t1 = System.currentTimeMillis();
            for (int i2 = 0; i2 < numlookups; ++i2) {
                cl.getLocation(ipstring[i4]);
                i4 = (i4 + 1) % ipstring.length;
            }
            long t2 = System.currentTimeMillis();
            double t3 = (double)(t2 - t1) / 1000.0;
            System.out.println(msg);
            System.out.println(numlookups + " lookups made in " + t3 + " seconds ");
        }
        catch (IOException e) {
            System.out.println("error");
        }
    }

    public static void main(String[] args) {
        BenchmarkGeoIP.testGeoipCountry(0, "GeoIP Country", 3000);
        BenchmarkGeoIP.testGeoipCountry(1, "GeoIP Country with GEOIP_MEMORY_CACHE", 30000);
        BenchmarkGeoIP.testGeoipRegion(0, "GeoIP Region", 3000);
        BenchmarkGeoIP.testGeoipRegion(1, "GeoIP Region with GEOIP_MEMORY_CACHE", 30000);
        BenchmarkGeoIP.testGeoipCity(0, "GeoIP City", 1500);
        BenchmarkGeoIP.testGeoipCity(1, "GeoIP City with GEOIP_MEMORY_CACHE", 15000);
    }
}

