/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.io.InputStream;
import org.dspace.app.mediafilter.MediaFilterManager;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.core.Context;

public abstract class MediaFilter {
    protected Item item = null;

    public abstract String getFilteredName(String var1);

    public abstract String getBundleName();

    public abstract String getFormatString();

    public abstract String getDescription();

    public abstract InputStream getDestinationStream(InputStream var1) throws Exception;

    public boolean processBitstream(Context c, Item item, Bitstream source) throws Exception {
        boolean overWrite = MediaFilterManager.isForce;
        this.item = item;
        String newName = this.getFilteredName(source.getName());
        Bitstream existingBitstream = null;
        Bundle targetBundle = null;
        Bundle[] bundles = item.getBundles(this.getBundleName());
        if (bundles.length > 0) {
            for (int i = 0; i < bundles.length; ++i) {
                Bitstream[] bitstreams = bundles[i].getBitstreams();
                for (int j = 0; j < bitstreams.length; ++j) {
                    if (!bitstreams[j].getName().equals(newName)) continue;
                    targetBundle = bundles[i];
                    existingBitstream = bitstreams[j];
                }
            }
        }
        if (!overWrite && existingBitstream != null) {
            System.out.println("SKIPPED: bitstream " + source.getID() + " because '" + newName + "' already exists");
            return false;
        }
        InputStream destStream = this.getDestinationStream(source.retrieve());
        targetBundle = bundles.length < 1 ? item.createBundle(this.getBundleName()) : bundles[0];
        Bitstream b = targetBundle.createBitstream(destStream);
        b.setName(newName);
        b.setSource("Written by MediaFilter " + this.getClass().getName());
        b.setDescription(this.getDescription());
        BitstreamFormat bf = BitstreamFormat.findByShortDescription(c, this.getFormatString());
        b.setFormat(bf);
        b.update();
        if (existingBitstream != null) {
            targetBundle.removeBitstream(existingBitstream);
        }
        System.out.println("FILTERED: bitstream " + source.getID() + " and created '" + newName + "'");
        return true;
    }
}

