/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.statistics;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.app.statistics.HTMLReport;
import org.dspace.app.statistics.Report;
import org.dspace.app.statistics.Stat;
import org.dspace.app.statistics.Statistics;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;

public class ReportGenerator {
    private static Map actionAggregator = new HashMap();
    private static Map searchAggregator = new HashMap();
    private static Map userAggregator = new HashMap();
    private static Map itemAggregator = new HashMap();
    private static Map archiveStats = new HashMap();
    private static int searchFloor;
    private static int itemFloor;
    private static int itemLookup;
    private static String userEmail;
    private static String url;
    private static String name;
    private static int avgItemViews;
    private static String serverName;
    private static Date startDate;
    private static Date endDate;
    private static int processTime;
    private static int logLines;
    private static int warnings;
    private static List generalSummary;
    private static Pattern real;
    private static Calendar startTime;
    private static Map actionMap;
    private static String format;
    private static String input;
    private static String output;
    private static String map;

    public static void main(String[] argv) throws Exception, SQLException {
        Context context = new Context();
        context.setIgnoreAuthorization(true);
        String myFormat = null;
        String myInput = null;
        String myOutput = null;
        String myMap = null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-format")) {
                myFormat = argv[i + 1].toLowerCase();
            }
            if (argv[i].equals("-in")) {
                myInput = argv[i + 1];
            }
            if (argv[i].equals("-out")) {
                myOutput = argv[i + 1];
            }
            if (argv[i].equals("-map")) {
                myMap = argv[i + 1];
            }
            if (!argv[i].equals("-help")) continue;
            ReportGenerator.usage();
            System.exit(0);
        }
        ReportGenerator.processReport(context, myFormat, myInput, myOutput, myMap);
    }

    public static void processReport(Context context, String myFormat, String myInput, String myOutput, String myMap) throws Exception, SQLException {
        startTime = new GregorianCalendar();
        ReportGenerator.setParameters(myFormat, myInput, myOutput, myMap);
        Object fr = null;
        Object br = null;
        ReportGenerator.readInput(input);
        ReportGenerator.readMap(map);
        Report report = null;
        if (format.equals("html")) {
            report = new HTMLReport();
        }
        report.setStartDate(startDate);
        report.setEndDate(endDate);
        report.setMainTitle(name, serverName);
        Iterator keys = null;
        int i = 0;
        String explanation = null;
        Statistics overview = new Statistics();
        overview.setSectionHeader("General Overview");
        for (String entry : generalSummary) {
            if (!actionAggregator.containsKey(entry)) continue;
            int count = Integer.parseInt((String)actionAggregator.get(entry));
            overview.add(new Stat(ReportGenerator.translate(entry), count));
        }
        report.addBlock(overview);
        if (archiveStats.size() > 0) {
            Statistics archiveInfo = ReportGenerator.prepareStats(archiveStats, true, false);
            archiveInfo.setSectionHeader("Archive Information");
            archiveInfo.setStatName("Content Type");
            archiveInfo.setResultName("Number of items");
            report.addBlock(archiveInfo);
        }
        Statistics viewedItems = new Statistics("Item/Handle", "Number of views", itemFloor);
        viewedItems.setSectionHeader("Items Viewed");
        Object[] items = new Stat[itemAggregator.size()];
        keys = itemAggregator.keySet().iterator();
        i = 0;
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String link = url + "handle/" + key;
            int value = Integer.parseInt((String)itemAggregator.get(key));
            items[i] = new Stat(key, value, link);
            ++i;
        }
        Arrays.sort(items);
        String info = null;
        for (i = 0; i < items.length; ++i) {
            if (i < itemLookup) {
                info = ReportGenerator.getItemInfo(context, ((Stat)items[i]).getKey());
            }
            if (info != null) {
                ((Stat)items[i]).setKey(info + " (" + ((Stat)items[i]).getKey() + ")");
            } else {
                ((Stat)items[i]).setKey(((Stat)items[i]).getReference());
            }
            info = null;
        }
        viewedItems.add((Stat[])items);
        report.addBlock(viewedItems);
        Statistics fullInfo = ReportGenerator.prepareStats(actionAggregator, true, true);
        fullInfo.setSectionHeader("All Actions Performed");
        fullInfo.setStatName("Action");
        fullInfo.setResultName("Number of times");
        report.addBlock(fullInfo);
        if (!userEmail.equals("off")) {
            Statistics userLogins = ReportGenerator.prepareStats(userAggregator, true, false);
            userLogins.setSectionHeader("User Logins");
            userLogins.setStatName("User");
            userLogins.setResultName("Number of logins");
            if (userEmail.equals("alias")) {
                explanation = "(distinct addresses)";
                userLogins.setExplanation(explanation);
            }
            report.addBlock(userLogins);
        }
        Statistics searchWords = ReportGenerator.prepareStats(searchAggregator, true, false);
        searchWords.setSectionHeader("Words Searched");
        searchWords.setStatName("Word");
        searchWords.setResultName("Number of searches");
        searchWords.setFloor(searchFloor);
        report.addBlock(searchWords);
        if (avgItemViews > 0) {
            Statistics avg = new Statistics();
            avg.setSectionHeader("Averaging Information");
            Stat[] average = new Stat[]{new Stat("Average views per item", avgItemViews)};
            avg.add(average);
            report.addBlock(avg);
        }
        Statistics levels = new Statistics("Level", "Number of lines");
        levels.setSectionHeader("Log Level Information");
        Stat[] level = new Stat[]{new Stat("Warnings", warnings)};
        levels.add(level);
        report.addBlock(levels);
        GregorianCalendar endTime = new GregorianCalendar();
        long timeInMillis = endTime.getTimeInMillis() - startTime.getTimeInMillis();
        int outputProcessTime = new Long(timeInMillis).intValue() / 1000;
        Statistics process = new Statistics("Operation", "");
        process.setSectionHeader("Processing Information");
        Stat[] proc = new Stat[3];
        proc[0] = new Stat("Log Processing Time", processTime);
        proc[0].setUnits("seconds");
        proc[1] = new Stat("Output Processing Time", outputProcessTime);
        proc[1].setUnits("seconds");
        proc[2] = new Stat("Log File Lines Analysed", logLines);
        proc[2].setUnits("lines");
        process.add(proc);
        report.addBlock(process);
        try {
            FileOutputStream fos = new FileOutputStream(output);
            OutputStreamWriter osr = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            PrintWriter out = new PrintWriter(osr);
            out.write(report.render());
            out.close();
        }
        catch (IOException e) {
            System.out.println("Unable to write to output file " + output);
            System.exit(0);
        }
    }

    public static Statistics prepareStats(Map aggregator, boolean sort, boolean translate) {
        Object[] stats = new Stat[aggregator.size()];
        if (aggregator.size() > 0) {
            Iterator keys = aggregator.keySet().iterator();
            int i = 0;
            while (keys.hasNext()) {
                String key = (String)keys.next();
                int value = Integer.parseInt((String)aggregator.get(key));
                stats[i] = translate ? new Stat(ReportGenerator.translate(key), value) : new Stat(key, value);
                ++i;
            }
            if (sort) {
                Arrays.sort(stats);
            }
        }
        Statistics statistics = new Statistics();
        statistics.add((Stat[])stats);
        return statistics;
    }

    public static String translate(String text) {
        if (actionMap.containsKey(text)) {
            return (String)actionMap.get(text);
        }
        return text;
    }

    public static void readMap(String map) throws IOException {
        FileReader fr = null;
        BufferedReader br = null;
        String record = null;
        try {
            fr = new FileReader(map);
            br = new BufferedReader(fr);
        }
        catch (IOException e) {
            System.err.println("Failed to read map file: log file actions will be displayed without translation");
            return;
        }
        while ((record = br.readLine()) != null) {
            Matcher matchReal = real.matcher(record);
            if (!matchReal.matches()) continue;
            actionMap.put(matchReal.group(1).trim(), matchReal.group(2).trim());
        }
    }

    public static void setParameters(String myFormat, String myInput, String myOutput, String myMap) {
        if (myFormat != null) {
            format = myFormat;
        }
        if (myInput != null) {
            input = myInput;
        }
        if (myOutput != null) {
            output = myOutput;
        }
        if (myMap != null) {
            map = myMap;
        }
    }

    public static void readInput(String input) throws IOException, ParseException {
        FileReader fr = null;
        BufferedReader br = null;
        String record = null;
        try {
            fr = new FileReader(input);
            br = new BufferedReader(fr);
        }
        catch (IOException e) {
            System.out.println("Failed to read input file");
            System.exit(0);
        }
        while ((record = br.readLine()) != null) {
            Matcher matchReal = real.matcher(record);
            String section = null;
            String key = null;
            String value = null;
            String left = null;
            if (!matchReal.matches()) continue;
            left = matchReal.group(1).trim();
            value = matchReal.group(2).trim();
            StringTokenizer tokens = new StringTokenizer(left, ".");
            int numTokens = tokens.countTokens();
            if (tokens.hasMoreTokens()) {
                section = tokens.nextToken();
                key = numTokens > 1 ? left.substring(section.length() + 1) : "";
            }
            SimpleDateFormat sdf = new SimpleDateFormat("dd'/'MM'/'yyyy");
            if (section.equals("archive")) {
                archiveStats.put(key, value);
            }
            if (section.equals("action")) {
                actionAggregator.put(key, value);
            }
            if (section.equals("user")) {
                userAggregator.put(key, value);
            }
            if (section.equals("search")) {
                searchAggregator.put(key, value);
            }
            if (section.equals("item")) {
                itemAggregator.put(key, value);
            }
            if (section.equals("user_email")) {
                userEmail = value;
            }
            if (section.equals("item_floor")) {
                itemFloor = Integer.parseInt(value);
            }
            if (section.equals("search_floor")) {
                searchFloor = Integer.parseInt(value);
            }
            if (section.equals("host_url")) {
                url = value;
            }
            if (section.equals("item_lookup")) {
                itemLookup = Integer.parseInt(value);
            }
            if (section.equals("avg_item_views")) {
                try {
                    avgItemViews = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    avgItemViews = 0;
                }
            }
            if (section.equals("server_name")) {
                serverName = value;
            }
            if (section.equals("service_name")) {
                name = value;
            }
            if (section.equals("start_date")) {
                startDate = sdf.parse(value);
            }
            if (section.equals("end_date")) {
                endDate = sdf.parse(value);
            }
            if (section.equals("analysis_process_time")) {
                processTime = Integer.parseInt(value);
            }
            if (section.equals("general_summary")) {
                generalSummary.add(value);
            }
            if (section.equals("log_lines")) {
                logLines = Integer.parseInt(value);
            }
            if (!section.equals("warnings")) continue;
            warnings = Integer.parseInt(value);
        }
        br.close();
        fr.close();
    }

    public static String getItemInfo(Context context, String handle) throws SQLException {
        Item item = null;
        try {
            item = (Item)HandleManager.resolveToObject(context, handle);
        }
        catch (Exception e) {
            return null;
        }
        if (item == null) {
            return null;
        }
        DCValue[] title = item.getDC("title", null, "*");
        DCValue[] author = item.getDC("contributor", "author", "*");
        StringBuffer authors = new StringBuffer();
        if (author.length > 0) {
            authors.append("(" + author[0].value);
        }
        if (author.length > 1) {
            authors.append(" et al");
        }
        if (author.length > 0) {
            authors.append(")");
        }
        String content = title[0].value + " " + authors.toString();
        return content;
    }

    public static void usage() {
        String usage = "Usage Information:\nReportGenerator [options [parameters]]\n-format [output format]\n\tRequired\n\tSpecify the format that you would like the output in\n\tOptions:\n\t\thtml\n-in [aggregation file]\n\tRequired\n\tSpecify the aggregation data file to display\n-out [output file]\n\tOptional\n\tSpecify the file to output the report to\n\tDefault uses [dspace log directory]/report\n-map [map file]\n\tOptional\n\tSpecify the map file to translate log file actions into human readable actions\n\tDefault uses [dspace config directory]/dstat.map\n-help\n\tdisplay this usage information\n";
        System.out.println(usage);
    }

    static {
        startDate = null;
        endDate = null;
        generalSummary = new ArrayList();
        real = Pattern.compile("^(.+)=(.+)");
        startTime = null;
        actionMap = new HashMap();
        format = null;
        input = null;
        output = ConfigurationManager.getProperty("dspace.dir") + File.separator + "log" + File.separator + "report";
        map = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator + "dstat.map";
    }
}

