/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authorize;

import java.sql.SQLException;
import java.util.Date;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;

public class ResourcePolicy {
    private Context myContext;
    private TableRow myRow;

    ResourcePolicy(Context context, TableRow row) {
        this.myContext = context;
        this.myRow = row;
    }

    public static ResourcePolicy find(Context context, int id) throws SQLException {
        TableRow row = DatabaseManager.find(context, "ResourcePolicy", id);
        if (row == null) {
            return null;
        }
        return new ResourcePolicy(context, row);
    }

    public static ResourcePolicy create(Context context) throws SQLException, AuthorizeException {
        TableRow row = DatabaseManager.create(context, "ResourcePolicy");
        return new ResourcePolicy(context, row);
    }

    public void delete() throws SQLException {
        DatabaseManager.delete(this.myContext, this.myRow);
    }

    public int getID() {
        return this.myRow.getIntColumn("policy_id");
    }

    public int getResourceType() {
        return this.myRow.getIntColumn("resource_type_id");
    }

    public void setResource(DSpaceObject o) {
        this.setResourceType(o.getType());
        this.setResourceID(o.getID());
    }

    public void setResourceType(int mytype) {
        this.myRow.setColumn("resource_type_id", mytype);
    }

    public int getResourceID() {
        return this.myRow.getIntColumn("resource_id");
    }

    public void setResourceID(int myid) {
        this.myRow.setColumn("resource_id", myid);
    }

    public int getAction() {
        return this.myRow.getIntColumn("action_id");
    }

    public String getActionText() {
        int myAction = this.myRow.getIntColumn("action_id");
        if (myAction == -1) {
            return "...";
        }
        return Constants.actionText[myAction];
    }

    public void setAction(int myid) {
        this.myRow.setColumn("action_id", myid);
    }

    public int getEPersonID() {
        return this.myRow.getIntColumn("eperson_id");
    }

    public EPerson getEPerson() throws SQLException {
        int eid = this.myRow.getIntColumn("eperson_id");
        if (eid == -1) {
            return null;
        }
        return EPerson.find(this.myContext, eid);
    }

    public void setEPerson(EPerson e) {
        if (e != null) {
            this.myRow.setColumn("eperson_id", e.getID());
        } else {
            this.myRow.setColumnNull("eperson_id");
        }
    }

    public int getGroupID() {
        return this.myRow.getIntColumn("epersongroup_id");
    }

    public Group getGroup() throws SQLException {
        int gid = this.myRow.getIntColumn("epersongroup_id");
        if (gid == -1) {
            return null;
        }
        return Group.find(this.myContext, gid);
    }

    public void setGroup(Group g) {
        if (g != null) {
            this.myRow.setColumn("epersongroup_id", g.getID());
        } else {
            this.myRow.setColumnNull("epersongroup_id");
        }
    }

    public boolean isDateValid() {
        Date sd = this.getStartDate();
        Date ed = this.getEndDate();
        if (sd == null && ed == null) {
            return true;
        }
        Date now = new Date();
        if (sd != null && now.before(sd)) {
            return false;
        }
        return ed == null || !now.after(sd);
    }

    public Date getStartDate() {
        return this.myRow.getDateColumn("start_date");
    }

    public void setStartDate(Date d) {
        this.myRow.setColumn("start_date", d);
    }

    public Date getEndDate() {
        return this.myRow.getDateColumn("end_date");
    }

    public void setEndDate(Date d) {
        this.myRow.setColumn("end_date", d);
    }

    public void update() throws SQLException {
        DatabaseManager.update(this.myContext, this.myRow);
    }
}

