/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.browse.BrowseCreateDAO;
import org.dspace.browse.BrowseDAOFactory;
import org.dspace.browse.BrowseDAOUtils;
import org.dspace.browse.BrowseException;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseCreateDAOPostgres
implements BrowseCreateDAO {
    private static Logger log = Logger.getLogger(BrowseCreateDAOPostgres.class);
    private Context context;
    private BrowseDAOUtils utils;

    public BrowseCreateDAOPostgres(Context context) throws BrowseException {
        this.context = context;
        this.utils = BrowseDAOFactory.getUtils(context);
    }

    @Override
    public String createCollectionView(String table, String view, boolean execute) throws BrowseException {
        try {
            String createColView = "CREATE VIEW " + view + " as " + "SELECT Collection2Item.collection_id, " + table + ".* " + "FROM " + table + ", Collection2Item " + "WHERE " + table + ".item_id = Collection2Item.item_id;";
            if (execute) {
                DatabaseManager.updateQuery(this.context, createColView, new Object[0]);
            }
            return createColView;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public String createCommunityView(String table, String view, boolean execute) throws BrowseException {
        try {
            String createComView = "CREATE VIEW " + view + " as " + "SELECT Community2Item.community_id, " + table + ".* " + "FROM " + table + ", Community2Item " + "WHERE " + table + ".item_id = Community2Item.item_id;";
            if (execute) {
                DatabaseManager.updateQuery(this.context, createComView, new Object[0]);
            }
            return createComView;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public String[] createDatabaseIndices(String table, List<Integer> sortCols, boolean value, boolean execute) throws BrowseException {
        try {
            ArrayList<String> array = new ArrayList<String>();
            array.add("CREATE INDEX " + table + "_item_id_idx ON " + table + "(item_id);");
            if (value) {
                array.add("CREATE INDEX " + table + "_value_index ON " + table + "(sort_value);");
            }
            for (Integer i : sortCols) {
                array.add("CREATE INDEX " + table + "_s" + i + "_idx ON " + table + "(sort_" + i + ");");
            }
            if (execute) {
                for (String query : array) {
                    DatabaseManager.updateQuery(this.context, query, new Object[0]);
                }
            }
            String[] arr = new String[array.size()];
            return array.toArray(arr);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public String createDistinctMap(String table, String map, boolean execute) throws BrowseException {
        try {
            String create = "CREATE TABLE " + map + " (" + "map_id integer primary key, " + "item_id integer references item(item_id), " + "distinct_id integer references " + table + "(id)" + ");";
            if (execute) {
                DatabaseManager.updateQuery(this.context, create, new Object[0]);
            }
            return create;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public void createDistinctMapping(String table, int itemID, int distinctID) throws BrowseException {
        try {
            TableRow tr = DatabaseManager.create(this.context, table);
            tr.setColumn("item_id", itemID);
            tr.setColumn("distinct_id", distinctID);
            DatabaseManager.update(this.context, tr);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            String msg = "problem creating distinct mapping: table=" + table + ",item-id=" + itemID + ",distinct_id=" + distinctID;
            throw new BrowseException(msg, e);
        }
    }

    @Override
    public String createDistinctTable(String table, boolean execute) throws BrowseException {
        try {
            String create = "CREATE TABLE " + table + " (" + "id integer primary key, " + "value " + this.getValueColumnDefinition() + ", " + "sort_value " + this.getSortColumnDefinition() + ");";
            if (execute) {
                DatabaseManager.updateQuery(this.context, create, new Object[0]);
            }
            return create;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public String createPrimaryTable(String table, List sortCols, boolean execute) throws BrowseException {
        try {
            StringBuffer sb = new StringBuffer();
            for (Integer no : sortCols) {
                sb.append(", sort_");
                sb.append(no.toString());
                sb.append(this.getSortColumnDefinition());
            }
            String createTable = "CREATE TABLE " + table + " (" + "id integer primary key," + "item_id integer references item(item_id)" + sb.toString() + ");";
            if (execute) {
                DatabaseManager.updateQuery(this.context, createTable, new Object[0]);
            }
            return createTable;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public String createSecondaryTable(String table, List sortCols, boolean execute) throws BrowseException {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(", sort_value ");
            sb.append(this.getSortColumnDefinition());
            for (Integer no : sortCols) {
                sb.append(", sort_");
                sb.append(no.toString());
                sb.append(this.getSortColumnDefinition());
            }
            String createTable = "CREATE TABLE " + table + " (" + "id integer primary key," + "item_id integer references item(item_id), " + "value " + this.getValueColumnDefinition() + sb.toString() + ");";
            if (execute) {
                DatabaseManager.updateQuery(this.context, createTable, new Object[0]);
            }
            return createTable;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public String createSequence(String sequence, boolean execute) throws BrowseException {
        try {
            String create = "CREATE SEQUENCE " + sequence + ";";
            if (execute) {
                DatabaseManager.updateQuery(this.context, create, new Object[0]);
            }
            return create;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public void deleteByItemID(String table, int itemID) throws BrowseException {
        try {
            Object[] params = new Object[]{new Integer(itemID)};
            String dquery = "DELETE FROM " + table + " WHERE item_id = ?";
            DatabaseManager.updateQuery(this.context, dquery, params);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public String dropIndexAndRelated(String table, boolean execute) throws BrowseException {
        try {
            String dropper = "DROP TABLE " + table + " CASCADE;";
            if (execute) {
                DatabaseManager.updateQuery(this.context, dropper, new Object[0]);
            }
            return dropper;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public String dropSequence(String sequence, boolean execute) throws BrowseException {
        try {
            String dropSeq = "DROP SEQUENCE " + sequence + ";";
            if (execute) {
                DatabaseManager.updateQuery(this.context, dropSeq, new Object[0]);
            }
            return dropSeq;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public String dropView(String view, boolean execute) throws BrowseException {
        return "";
    }

    @Override
    public int getDistinctID(String table, String value, String sortValue) throws BrowseException {
        TableRowIterator tri = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getDistinctID: table=" + table + ",value=" + value + ",sortValue=" + sortValue));
        }
        try {
            Object[] params = new Object[]{value};
            String select = "SELECT id FROM " + table + " WHERE value = ?";
            tri = DatabaseManager.query(this.context, select, params);
            int distinctID = -1;
            distinctID = !tri.hasNext() ? this.insertDistinctRecord(table, value, sortValue) : tri.next().getIntColumn("id");
            if (log.isDebugEnabled()) {
                log.debug((Object)("getDistinctID: return=" + distinctID));
            }
            int n = distinctID;
            return n;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
    }

    @Override
    public int insertDistinctRecord(String table, String value, String sortValue) throws BrowseException {
        log.debug((Object)("insertDistinctRecord: table=" + table + ",value=" + value + ",sortValue=" + sortValue));
        try {
            TableRow dr = DatabaseManager.create(this.context, table);
            dr.setColumn("value", this.utils.truncateValue(value));
            dr.setColumn("sort_value", this.utils.truncateSortValue(sortValue));
            DatabaseManager.update(this.context, dr);
            int distinctID = dr.getIntColumn("id");
            log.debug((Object)("insertDistinctRecord: return=" + distinctID));
            return distinctID;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public void insertIndex(String table, int itemID, Map sortCols) throws BrowseException {
        try {
            TableRow row = DatabaseManager.create(this.context, table);
            row.setColumn("item_id", itemID);
            for (Integer key : sortCols.keySet()) {
                String nValue = (String)sortCols.get(key);
                row.setColumn("sort_" + key.toString(), this.utils.truncateSortValue(nValue));
            }
            DatabaseManager.update(this.context, row);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public void insertIndex(String table, int itemID, String value, String sortValue, Map sortCols) throws BrowseException {
        try {
            TableRow row = DatabaseManager.create(this.context, table);
            row.setColumn("item_id", itemID);
            row.setColumn("value", this.utils.truncateValue(value));
            row.setColumn("sort_value", this.utils.truncateSortValue(sortValue));
            for (Integer key : sortCols.keySet()) {
                String nValue = (String)sortCols.get(key);
                row.setColumn("sort_" + key.toString(), this.utils.truncateSortValue(nValue));
            }
            DatabaseManager.update(this.context, row);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public void pruneDistinct(String table, String map) throws BrowseException {
        try {
            String query = "DELETE FROM " + table + " WHERE id NOT IN " + "(SELECT distinct_id FROM " + map + ")";
            DatabaseManager.updateQuery(this.context, query, new Object[0]);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public void pruneExcess(String table, String map, boolean withdrawn) throws BrowseException {
        TableRowIterator tri = null;
        try {
            String query = "SELECT item_id FROM " + table + " WHERE item_id NOT IN ( SELECT item_id FROM item WHERE ";
            query = withdrawn ? query + "withdrawn = true" : query + "in_archive = true AND withdrawn = false";
            query = query + ")";
            tri = DatabaseManager.query(this.context, query, new Object[0]);
            while (tri.hasNext()) {
                TableRow row = tri.next();
                String delete = "DELETE FROM " + table + " WHERE item_id = " + Integer.toString(row.getIntColumn("item_id"));
                DatabaseManager.updateQuery(this.context, delete, new Object[0]);
                if (map == null) continue;
                String deleteDistinct = "DELETE FROM " + map + " WHERE item_id = " + Integer.toString(row.getIntColumn("item_id"));
                DatabaseManager.updateQuery(this.context, deleteDistinct, new Object[0]);
            }
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean testTableExistance(String table) throws BrowseException {
        Context c = null;
        try {
            c = new Context();
            String testQuery = "SELECT * FROM " + table + " LIMIT 1";
            DatabaseManager.query(c, testQuery, new Object[0]);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (c != null) {
                c.abort();
            }
        }
    }

    private String getSortColumnDefinition() {
        int size = this.utils.getSortColumnMaxChars();
        if (size < 1) {
            return " TEXT ";
        }
        return " VARCHAR(" + size + ") ";
    }

    private String getValueColumnDefinition() {
        int size = this.utils.getValueColumnMaxChars();
        if (size < 1) {
            return " TEXT ";
        }
        return " VARCHAR(" + size + ") ";
    }
}

