/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.browse.BrowseException;
import org.dspace.browse.SortOption;
import org.dspace.core.ConfigurationManager;

public class BrowseIndex {
    private int number;
    private String name;
    private SortOption sortOption;
    private String metadata;
    private String datatype;
    private String displayType;
    private String tableBaseName;
    private String[] mdBits;
    private String defaultOrder;
    private static BrowseIndex itemIndex = new BrowseIndex("bi_item");
    private static BrowseIndex withdrawnIndex = new BrowseIndex("bi_withdrawn");

    private BrowseIndex() {
    }

    private BrowseIndex(String baseName) {
        try {
            this.number = -1;
            this.tableBaseName = baseName;
            this.displayType = "item";
            this.sortOption = SortOption.getDefaultSortOption();
        }
        catch (BrowseException browseException) {
            // empty catch block
        }
    }

    private BrowseIndex(String definition, int number) throws BrowseException {
        boolean valid = true;
        this.defaultOrder = "ASC";
        this.number = number;
        String rx = "(\\w+):(\\w+):([\\w\\.\\*]+):?(\\w*):?(\\w*)";
        Pattern pattern = Pattern.compile(rx);
        Matcher matcher = pattern.matcher(definition);
        if (matcher.matches()) {
            this.name = matcher.group(1);
            this.displayType = matcher.group(2);
            if (this.isMetadataIndex()) {
                String order;
                this.metadata = matcher.group(3);
                this.datatype = matcher.group(4);
                if (this.metadata == null || this.metadata.equals("")) {
                    valid = false;
                }
                if (this.datatype == null || this.datatype.equals("")) {
                    valid = false;
                }
                if (matcher.groupCount() > 4 && "DESC".equalsIgnoreCase(order = matcher.group(5))) {
                    this.defaultOrder = "DESC";
                }
                this.tableBaseName = BrowseIndex.makeTableBaseName(number);
            } else if (this.isItemIndex()) {
                String sortName = matcher.group(3);
                for (SortOption so : SortOption.getSortOptions()) {
                    if (!so.getName().equals(sortName)) continue;
                    this.sortOption = so;
                }
                if (this.sortOption == null) {
                    valid = false;
                }
                this.tableBaseName = BrowseIndex.getItemBrowseIndex().tableBaseName;
            } else {
                valid = false;
            }
        } else {
            valid = false;
        }
        if (!valid) {
            throw new BrowseException("Browse Index configuration is not valid: webui.browse.index." + number + " = " + definition);
        }
    }

    public String getDefaultOrder() {
        return this.defaultOrder;
    }

    public String getDataType() {
        if (this.sortOption != null) {
            return this.sortOption.getType();
        }
        return this.datatype;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public String[] getMdBits() {
        if (this.isMetadataIndex()) {
            return this.mdBits;
        }
        return null;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return this.name;
    }

    public SortOption getSortOption() {
        return this.sortOption;
    }

    public void generateMdBits() {
        try {
            if (this.isMetadataIndex()) {
                this.mdBits = this.interpretField(this.metadata, null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getSequenceName(boolean isDistinct, boolean isMap) {
        return BrowseIndex.getSequenceName(this.tableBaseName, isDistinct, isMap);
    }

    public static String getSequenceName(int number, boolean isDistinct, boolean isMap) {
        return BrowseIndex.getSequenceName(BrowseIndex.makeTableBaseName(number), isDistinct, isMap);
    }

    private static String getSequenceName(String baseName, boolean isDistinct, boolean isMap) {
        if (isDistinct) {
            baseName = baseName + "_dis";
        } else if (isMap) {
            baseName = baseName + "_dmap";
        }
        baseName = baseName + "_seq";
        return baseName;
    }

    public static String getTableName(int number, boolean isCommunity, boolean isCollection, boolean isDistinct, boolean isMap) {
        return BrowseIndex.getTableName(BrowseIndex.makeTableBaseName(number), isCommunity, isCollection, isDistinct, isMap);
    }

    private static String getTableName(String baseName, boolean isCommunity, boolean isCollection, boolean isDistinct, boolean isMap) {
        if (isDistinct) {
            return baseName + "_dis";
        }
        if (isCommunity) {
            baseName = baseName + "_com";
        } else if (isCollection) {
            baseName = baseName + "_col";
        }
        if (isMap) {
            baseName = baseName + "_dmap";
        }
        return baseName;
    }

    public String getTableName(boolean isCommunity, boolean isCollection, boolean isDistinct, boolean isMap) {
        if (this.isMetadataIndex()) {
            return BrowseIndex.getTableName(this.number, isCommunity, isCollection, isDistinct, isMap);
        }
        return BrowseIndex.getTableName(this.tableBaseName, isCommunity, isCollection, isDistinct, isMap);
    }

    public String getTableName(boolean isCommunity, boolean isCollection) {
        return this.getTableName(isCommunity, isCollection, false, false);
    }

    public String getTableName() {
        return this.getTableName(false, false, false, false);
    }

    public String getTableName(boolean isDistinct, boolean isCommunity, boolean isCollection) {
        return this.getTableName(isCommunity, isCollection, isDistinct, false);
    }

    public String getMapName(boolean isCommunity, boolean isCollection) {
        return this.getTableName(isCommunity, isCollection, false, true);
    }

    public String getMapName() {
        return this.getTableName(false, false, false, true);
    }

    public String getValueColumn() {
        if (!this.isDate()) {
            return "sort_text_value";
        }
        return "text_value";
    }

    public String getIndexColumn() {
        return "id";
    }

    public boolean isDate() {
        return "date".equals(this.getDataType());
    }

    public boolean isMetadataIndex() {
        return "metadata".equals(this.displayType);
    }

    public boolean isItemIndex() {
        return "item".equals(this.displayType);
    }

    public String getSortField() throws BrowseException {
        String focusField = this.isMetadataIndex() ? "sort_value" : (this.sortOption != null ? "sort_" + this.sortOption.getNumber() : "sort_1");
        return focusField;
    }

    public static String[] tables() throws BrowseException {
        BrowseIndex[] bis = BrowseIndex.getBrowseIndices();
        ArrayList<String> tables = new ArrayList<String>();
        for (int i = 0; i < bis.length; ++i) {
            String tableName = bis[i].getTableName();
            tables.add(tableName);
        }
        tables.add("Communities2Item");
        String[] returnTables = new String[tables.size()];
        returnTables = tables.toArray(returnTables);
        return returnTables;
    }

    public static BrowseIndex[] getBrowseIndices() throws BrowseException {
        Enumeration en = ConfigurationManager.propertyNames();
        ArrayList<BrowseIndex> browseIndices = new ArrayList<BrowseIndex>();
        String rx = "webui\\.browse\\.index\\.(\\d+)";
        Pattern pattern = Pattern.compile(rx);
        while (en.hasMoreElements()) {
            String property = (String)en.nextElement();
            Matcher matcher = pattern.matcher(property);
            if (!matcher.matches()) continue;
            int number = Integer.parseInt(matcher.group(1));
            String definition = ConfigurationManager.getProperty(property);
            BrowseIndex bi = new BrowseIndex(definition, number);
            browseIndices.add(bi);
        }
        BrowseIndex[] bis = new BrowseIndex[browseIndices.size()];
        bis = browseIndices.toArray(bis);
        return bis;
    }

    public static BrowseIndex getBrowseIndex(String name) throws BrowseException {
        for (BrowseIndex bix : BrowseIndex.getBrowseIndices()) {
            if (!bix.getName().equals(name)) continue;
            return bix;
        }
        return null;
    }

    public static BrowseIndex getBrowseIndex(SortOption so) throws BrowseException {
        for (BrowseIndex bix : BrowseIndex.getBrowseIndices()) {
            if (bix.getSortOption() != so) continue;
            return bix;
        }
        return null;
    }

    public static BrowseIndex getItemBrowseIndex() {
        return itemIndex;
    }

    public static BrowseIndex getWithdrawnBrowseIndex() {
        return withdrawnIndex;
    }

    public String[] interpretField(String mfield, String init) throws IOException {
        StringTokenizer sta = new StringTokenizer(mfield, ".");
        String[] field = new String[]{init, init, init};
        int i = 0;
        while (sta.hasMoreTokens()) {
            field[i++] = sta.nextToken();
        }
        if (field[0] == null || field[1] == null) {
            throw new IOException("at least a schema and element be specified in configuration.  You supplied: " + mfield);
        }
        return field;
    }

    public static boolean isInternalIndex(BrowseIndex bi) {
        return bi == itemIndex || bi == withdrawnIndex;
    }

    public boolean isInternalIndex() {
        return this == itemIndex || this == withdrawnIndex;
    }

    private static String makeTableBaseName(int number) {
        return "bi_" + Integer.toString(number);
    }
}

