/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Category;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggerRepository;
import org.dspace.core.Email;

public class ConfigurationManager {
    private static Logger log = Logger.getLogger(ConfigurationManager.class);
    private static Properties properties = null;
    private static String license;
    private static final int RECURSION_LIMIT = 9;
    private static File loadedFile;

    public static Properties getProperties() {
        return (Properties)properties.clone();
    }

    public static String getProperty(String property) {
        if (properties == null) {
            ConfigurationManager.loadConfig(null);
        }
        return properties.getProperty(property);
    }

    public static int getIntProperty(String property) {
        if (properties == null) {
            ConfigurationManager.loadConfig(null);
        }
        String stringValue = properties.getProperty(property);
        int intValue = 0;
        if (stringValue != null) {
            try {
                intValue = Integer.parseInt(stringValue.trim());
            }
            catch (NumberFormatException e) {
                ConfigurationManager.warn("Warning: Number format error in property: " + property);
            }
        }
        return intValue;
    }

    public static String getLicenseText(String licenseFile) {
        try {
            String lineIn;
            BufferedReader br = new BufferedReader(new FileReader(licenseFile));
            license = "";
            while ((lineIn = br.readLine()) != null) {
                license = license + lineIn + '\n';
            }
        }
        catch (IOException e) {
            ConfigurationManager.fatal("Can't load configuration", e);
            System.exit(1);
        }
        return license;
    }

    public static boolean getBooleanProperty(String property) {
        return ConfigurationManager.getBooleanProperty(property, false);
    }

    public static boolean getBooleanProperty(String property, boolean defaultValue) {
        String stringValue;
        if (properties == null) {
            ConfigurationManager.loadConfig(null);
        }
        if ((stringValue = properties.getProperty(property)) != null) {
            return (stringValue = stringValue.trim()).equalsIgnoreCase("true") || stringValue.equalsIgnoreCase("yes");
        }
        return defaultValue;
    }

    public static Enumeration propertyNames() {
        if (properties == null) {
            ConfigurationManager.loadConfig(null);
        }
        return properties.propertyNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Email getEmail(String emailFile) throws IOException {
        String charset = null;
        String subject = "";
        StringBuffer contentBuffer = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(emailFile));
            boolean more = true;
            while (more) {
                String line = reader.readLine();
                if (line == null) {
                    more = false;
                    continue;
                }
                if (line.toLowerCase().startsWith("subject:")) {
                    subject = line.substring(8).trim();
                    continue;
                }
                if (line.toLowerCase().startsWith("charset:")) {
                    charset = line.substring(8).trim();
                    continue;
                }
                if (line.startsWith("#")) continue;
                contentBuffer.append(line);
                contentBuffer.append("\n");
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Email email = new Email();
        email.setSubject(subject);
        email.setContent(contentBuffer.toString());
        if (charset != null) {
            email.setCharset(charset);
        }
        return email;
    }

    public static String getDefaultSubmissionLicense() {
        if (properties == null) {
            ConfigurationManager.loadConfig(null);
        }
        return license;
    }

    public static String getNewsFilePath() {
        String filePath = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator;
        return filePath;
    }

    public static String readNewsFile(String newsFile) {
        String fileName = ConfigurationManager.getNewsFilePath();
        fileName = fileName + newsFile;
        String text = "";
        try {
            String lineIn;
            FileInputStream fir = new FileInputStream(fileName);
            InputStreamReader ir = new InputStreamReader((InputStream)fir, "UTF-8");
            BufferedReader br = new BufferedReader(ir);
            while ((lineIn = br.readLine()) != null) {
                text = text + lineIn;
            }
            br.close();
        }
        catch (IOException e) {
            ConfigurationManager.warn("news_read: " + e.getLocalizedMessage());
        }
        return text;
    }

    public static String writeNewsFile(String newsFile, String news) {
        String fileName = ConfigurationManager.getNewsFilePath();
        fileName = fileName + newsFile;
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            OutputStreamWriter osr = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            PrintWriter out = new PrintWriter(osr);
            out.print(news);
            out.close();
        }
        catch (IOException e) {
            ConfigurationManager.warn("news_write: " + e.getLocalizedMessage());
        }
        return news;
    }

    public static void writeLicenseFile(String newLicense) {
        String licenseFile = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator + "default.license";
        try {
            FileOutputStream fos = new FileOutputStream(licenseFile);
            OutputStreamWriter osr = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            PrintWriter out = new PrintWriter(osr);
            out.print(newLicense);
            out.close();
        }
        catch (IOException e) {
            ConfigurationManager.warn("license_write: " + e.getLocalizedMessage());
        }
        license = newLicense;
    }

    protected static File getConfigurationFile() {
        ConfigurationManager.loadConfig(null);
        return loadedFile;
    }

    public static void loadConfig(String configFile) {
        if (properties != null) {
            return;
        }
        URL url = null;
        try {
            String configProperty = System.getProperty("dspace.configuration");
            if (configFile != null) {
                ConfigurationManager.info("Loading provided config file: " + configFile);
                loadedFile = new File(configFile);
                url = loadedFile.toURL();
            } else if (configProperty != null) {
                ConfigurationManager.info("Loading system provided config property (-Ddspace.configuration): " + configProperty);
                loadedFile = new File(configProperty);
                url = loadedFile.toURL();
            } else {
                url = ConfigurationManager.class.getResource("/dspace.cfg");
                if (url != null) {
                    ConfigurationManager.info("Loading from classloader: " + url);
                    loadedFile = new File(url.getPath());
                }
            }
            if (url == null) {
                ConfigurationManager.fatal("Cannot find dspace.cfg");
                throw new RuntimeException("Cannot find dspace.cfg");
            }
            properties = new Properties();
            properties.load(url.openStream());
            Enumeration<?> pe = properties.propertyNames();
            while (pe.hasMoreElements()) {
                String key = (String)pe.nextElement();
                String value = ConfigurationManager.interpolate(key, 1);
                if (value == null) continue;
                properties.setProperty(key, value);
            }
        }
        catch (IOException e) {
            ConfigurationManager.fatal("Can't load configuration: " + url, e);
            throw new RuntimeException("Cannot load configuration: " + url, e);
        }
        File licenseFile = new File(ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator + "default.license");
        try {
            String lineIn;
            FileInputStream fir = new FileInputStream(licenseFile);
            InputStreamReader ir = new InputStreamReader((InputStream)fir, "UTF-8");
            BufferedReader br = new BufferedReader(ir);
            license = "";
            while ((lineIn = br.readLine()) != null) {
                license = license + lineIn + '\n';
            }
            br.close();
        }
        catch (IOException e) {
            ConfigurationManager.fatal("Can't load license: " + licenseFile.toString(), e);
            throw new RuntimeException("Cannot load license: " + licenseFile.toString(), e);
        }
        try {
            String dsLogConfiguration = ConfigurationManager.getProperty("log.init.config");
            if (dsLogConfiguration == null || System.getProperty("dspace.log.init.disable") != null) {
                ConfigurationManager.info("Using default log4j provided log configuration,if uninitended, check your dspace.cfg for (log.init.config)");
            } else {
                ConfigurationManager.info("Using dspace provided log configuration (log.init.config)");
                File logConfigFile = new File(dsLogConfiguration);
                if (logConfigFile.exists()) {
                    ConfigurationManager.info("Loading: " + dsLogConfiguration);
                    OptionConverter.selectAndConfigure((URL)logConfigFile.toURL(), null, (LoggerRepository)LogManager.getLoggerRepository());
                } else {
                    ConfigurationManager.info("File does not exist: " + dsLogConfiguration);
                }
            }
        }
        catch (MalformedURLException e) {
            ConfigurationManager.fatal("Can't load dspace provided log4j configuration", e);
            throw new RuntimeException("Cannot load dspace provided log4j configuration", e);
        }
    }

    private static String interpolate(String key, int level) {
        int end;
        int start;
        if (level > 9) {
            throw new IllegalArgumentException("ConfigurationManager: Too many levels of recursion in configuration property variable interpolation, property=" + key);
        }
        String value = (String)properties.get(key);
        int from = 0;
        StringBuffer result = null;
        while (from < value.length() && (start = value.indexOf("${", from)) >= 0 && (end = value.indexOf("}", start)) >= 0) {
            String var = value.substring(start + 2, end);
            if (result == null) {
                result = new StringBuffer(value.substring(from, start));
            } else {
                result.append(value.substring(from, start));
            }
            if (properties.containsKey(var)) {
                String ivalue = ConfigurationManager.interpolate(var, level + 1);
                if (ivalue != null) {
                    result.append(ivalue);
                    properties.setProperty(var, ivalue);
                } else {
                    result.append(properties.getProperty(var));
                }
            } else {
                log.warn((Object)("Interpolation failed in value of property \"" + key + "\", there is no property named \"" + var + "\""));
            }
            from = end + 1;
        }
        if (result != null && from < value.length()) {
            result.append(value.substring(from));
        }
        return result == null ? null : result.toString();
    }

    public static void main(String[] argv) {
        if (argv.length == 2 && argv[0].equals("-property")) {
            String val = ConfigurationManager.getProperty(argv[1]);
            if (val != null) {
                System.out.println(val);
            } else {
                System.out.println("");
            }
            System.exit(0);
        } else {
            System.err.println("Usage: ConfigurationManager OPTION\n  -property prop.name  get value of prop.name from dspace.cfg");
        }
        System.exit(1);
    }

    private static void info(String string) {
        if (!ConfigurationManager.isConfigured()) {
            System.out.println("INFO: " + string);
        } else {
            log.info((Object)string);
        }
    }

    private static void warn(String string) {
        if (!ConfigurationManager.isConfigured()) {
            System.out.println("WARN: " + string);
        } else {
            log.warn((Object)string);
        }
    }

    private static void fatal(String string, Exception e) {
        if (!ConfigurationManager.isConfigured()) {
            System.out.println("FATAL: " + string);
            e.printStackTrace();
        } else {
            log.fatal((Object)string, (Throwable)e);
        }
    }

    private static void fatal(String string) {
        if (!ConfigurationManager.isConfigured()) {
            System.out.println("FATAL: " + string);
        } else {
            log.fatal((Object)string);
        }
    }

    private static boolean isConfigured() {
        Enumeration en = LogManager.getRootLogger().getAllAppenders();
        if (!(en instanceof NullEnumeration)) {
            return true;
        }
        Enumeration cats = Category.getCurrentCategories();
        while (cats.hasMoreElements()) {
            Category c = (Category)cats.nextElement();
            if (c.getAllAppenders() instanceof NullEnumeration) continue;
            return true;
        }
        return false;
    }

    static {
        loadedFile = null;
    }
}

