/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.search;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.LogManager;
import org.dspace.handle.HandleManager;
import org.dspace.search.DSQuery;

public class DSIndexer {
    private static final Logger log = Logger.getLogger(DSIndexer.class);
    private static final String LAST_INDEXED_FIELD = "DSIndexer.lastIndexed";
    private static final long WRITE_LOCK_TIMEOUT = 30000L;
    private static String index_directory = ConfigurationManager.getProperty("search.dir");
    private static int maxfieldlength = -1;
    private static Analyzer analyzer = null;
    private static IndexConfig[] indexConfigArr = new IndexConfig[0];

    public static void indexContent(Context context, DSpaceObject dso) throws SQLException, IOException {
        DSIndexer.indexContent(context, dso, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void indexContent(Context context, DSpaceObject dso, boolean force) throws SQLException, IOException {
        String handle = dso.getHandle();
        if (handle == null) {
            handle = HandleManager.findHandle(context, dso);
        }
        Term t = new Term("handle", handle);
        IndexWriter writer = null;
        try {
            switch (dso.getType()) {
                case 2: {
                    Item item = (Item)dso;
                    if (!item.isArchived() || item.isWithdrawn() || !DSIndexer.requiresIndexing(handle, ((Item)dso).getLastModified()) && !force) return;
                    Document doc = DSIndexer.buildDocument(context, (Item)dso);
                    writer = DSIndexer.openIndex(context, false);
                    writer.updateDocument(t, doc);
                    log.info((Object)("Wrote Item: " + handle + " to Index"));
                    return;
                }
                case 3: {
                    writer = DSIndexer.openIndex(context, false);
                    writer.updateDocument(t, DSIndexer.buildDocument(context, (Collection)dso));
                    log.info((Object)("Wrote Collection: " + handle + " to Index"));
                    return;
                }
                case 4: {
                    writer = DSIndexer.openIndex(context, false);
                    writer.updateDocument(t, DSIndexer.buildDocument(context, (Community)dso));
                    log.info((Object)("Wrote Community: " + handle + " to Index"));
                    return;
                }
                default: {
                    log.error((Object)"Only Items, Collections and Communities can be Indexed");
                    return;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static void unIndexContent(Context context, DSpaceObject dso) throws SQLException, IOException {
        try {
            DSIndexer.unIndexContent(context, dso.getHandle());
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            DSIndexer.emailException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unIndexContent(Context context, String handle) throws SQLException, IOException {
        IndexWriter writer = DSIndexer.openIndex(context, false);
        try {
            if (handle != null) {
                Term t = new Term("handle", handle);
                writer.deleteDocuments(t);
            } else {
                log.warn((Object)"unindex of content with null handle attempted");
            }
        }
        finally {
            writer.close();
        }
    }

    public static void reIndexContent(Context context, DSpaceObject dso) throws SQLException, IOException {
        try {
            DSIndexer.indexContent(context, dso);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            DSIndexer.emailException(exception);
        }
    }

    public static void createIndex(Context c) throws SQLException, IOException {
        DSIndexer.openIndex(c, true).close();
        DSIndexer.updateIndex(c, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void optimizeIndex(Context c) throws SQLException, IOException {
        IndexWriter writer = DSIndexer.openIndex(c, false);
        try {
            writer.optimize();
        }
        finally {
            writer.close();
        }
    }

    public static void main(String[] args) throws SQLException, IOException {
        Context context = new Context();
        context.setIgnoreAuthorization(true);
        String usage = "org.dspace.search.DSIndexer [-cbhouf[d <item handle>]] or nothing to update/clean an existing index.";
        Options options = new Options();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine line = null;
        OptionBuilder.withArgName((String)"item handle");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"delete an Item, Collection or Community from index based on its handle");
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"optimize existing index");
        options.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"clean existing index removing any documents that no longer exist in the db");
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"(re)build index, wiping out current one if it exists");
        options.addOption(OptionBuilder.create((String)"b"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"if updating existing index, force each handle to be reindexed even if uptodate");
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"print this help message");
        options.addOption(OptionBuilder.create((String)"h"));
        try {
            line = new PosixParser().parse(options, args);
        }
        catch (Exception e) {
            formatter.printHelp(usage, e.getMessage(), options, "");
            System.exit(1);
        }
        if (line.hasOption("h")) {
            formatter.printHelp(usage, options);
            System.exit(1);
        }
        if (line.hasOption("r")) {
            log.info((Object)("Removing " + line.getOptionValue("r") + " from Index"));
            DSIndexer.unIndexContent(context, line.getOptionValue("r"));
        } else if (line.hasOption("o")) {
            log.info((Object)"Optimizing Index");
            DSIndexer.optimizeIndex(context);
        } else if (line.hasOption("c")) {
            log.info((Object)"Cleaning Index");
            DSIndexer.cleanIndex(context);
        } else if (line.hasOption("u")) {
            log.info((Object)"Updating Index");
            DSIndexer.updateIndex(context, line.hasOption("f"));
        } else if (line.hasOption("b")) {
            log.info((Object)"(Re)building index from scratch.");
            DSIndexer.createIndex(context);
        } else {
            log.info((Object)"Updating and Cleaning Index");
            DSIndexer.cleanIndex(context);
            DSIndexer.updateIndex(context, line.hasOption("f"));
        }
        log.info((Object)"Done with indexing");
    }

    public static void updateIndex(Context context) {
        DSIndexer.updateIndex(context, false);
    }

    public static void updateIndex(Context context, boolean force) {
        try {
            ItemIterator i = Item.findAll(context);
            while (i.hasNext()) {
                Item item = i.next();
                DSIndexer.indexContent(context, item, force);
                item.decache();
            }
            Collection[] collections = Collection.findAll(context);
            for (int i2 = 0; i2 < collections.length; ++i2) {
                DSIndexer.indexContent(context, collections[i2], force);
                context.removeCached(collections[i2], collections[i2].getID());
            }
            Community[] communities = Community.findAll(context);
            for (int i3 = 0; i3 < communities.length; ++i3) {
                DSIndexer.indexContent(context, communities[i3], force);
                context.removeCached(communities[i3], communities[i3].getID());
            }
            DSIndexer.optimizeIndex(context);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void cleanIndex(Context context) throws IOException, SQLException {
        IndexReader reader = DSQuery.getIndexReader();
        for (int i = 0; i < reader.numDocs(); ++i) {
            if (!reader.isDeleted(i)) {
                Document doc = reader.document(i);
                String handle = doc.get("handle");
                DSpaceObject o = HandleManager.resolveToObject(context, handle);
                if (o == null) {
                    log.info((Object)("Deleting: " + handle));
                    DSIndexer.unIndexContent(context, handle);
                    continue;
                }
                context.removeCached(o, o.getID());
                log.debug((Object)("Keeping: " + handle));
                continue;
            }
            log.debug((Object)("Encountered deleted doc: " + i));
        }
    }

    static Analyzer getAnalyzer() throws IllegalStateException {
        if (analyzer == null) {
            String analyzerClassName = ConfigurationManager.getProperty("search.analyzer");
            if (analyzerClassName == null) {
                analyzerClassName = "org.dspace.search.DSAnalyzer";
            }
            try {
                Class<?> analyzerClass = Class.forName(analyzerClassName);
                analyzer = (Analyzer)analyzerClass.newInstance();
            }
            catch (Exception e) {
                log.fatal((Object)LogManager.getHeader(null, "no_search_analyzer", "search.analyzer=" + analyzerClassName), (Throwable)e);
                throw new IllegalStateException(e.toString());
            }
        }
        return analyzer;
    }

    private static void emailException(Exception exception) {
        try {
            String recipient = ConfigurationManager.getProperty("alert.recipient");
            if (recipient != null) {
                String stackTrace;
                Email email = ConfigurationManager.getEmail("internal_error");
                email.addRecipient(recipient);
                email.addArgument(ConfigurationManager.getProperty("dspace.url"));
                email.addArgument(new Date());
                if (exception != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    exception.printStackTrace(pw);
                    pw.flush();
                    stackTrace = sw.toString();
                } else {
                    stackTrace = "No exception";
                }
                email.addArgument(stackTrace);
                email.send();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unable to send email alert", (Throwable)e);
        }
    }

    private static boolean requiresIndexing(String handle, Date lastModified) throws SQLException, IOException {
        boolean reindexItem = false;
        boolean inIndex = false;
        IndexReader ir = DSQuery.getIndexReader();
        Term t = new Term("handle", handle);
        TermDocs docs = ir.termDocs(t);
        while (docs.next()) {
            inIndex = true;
            int id = docs.doc();
            Document doc = ir.document(id);
            Field lastIndexed = doc.getField(LAST_INDEXED_FIELD);
            if (lastIndexed != null && Long.parseLong(lastIndexed.stringValue()) >= lastModified.getTime()) continue;
            reindexItem = true;
        }
        return reindexItem || !inIndex;
    }

    private static IndexWriter openIndex(Context c, boolean wipe_existing) throws IOException {
        IndexWriter writer = new IndexWriter(index_directory, DSIndexer.getAnalyzer(), wipe_existing);
        if (maxfieldlength == -1) {
            writer.setMaxFieldLength(Integer.MAX_VALUE);
        } else {
            writer.setMaxFieldLength(maxfieldlength);
        }
        return writer;
    }

    private static String buildItemLocationString(Context c, Item myitem) throws SQLException {
        Community[] communities = myitem.getCommunities();
        Collection[] collections = myitem.getCollections();
        String location = "";
        int i = 0;
        for (i = 0; i < communities.length; ++i) {
            location = new String(location + " m" + communities[i].getID());
        }
        for (i = 0; i < collections.length; ++i) {
            location = new String(location + " l" + collections[i].getID());
        }
        return location;
    }

    private static String buildCollectionLocationString(Context c, Collection target) throws SQLException {
        Community[] communities = target.getCommunities();
        String location = "";
        int i = 0;
        for (i = 0; i < communities.length; ++i) {
            location = new String(location + " m" + communities[i].getID());
        }
        return location;
    }

    private static Document buildDocument(Context context, Community community) throws SQLException, IOException {
        Document doc = DSIndexer.buildDocument(4, community.getHandle(), null);
        String name = community.getMetadata("name");
        if (name != null) {
            doc.add((Fieldable)new Field("name", name, Field.Store.YES, Field.Index.TOKENIZED));
            doc.add((Fieldable)new Field("default", name, Field.Store.YES, Field.Index.TOKENIZED));
        }
        return doc;
    }

    private static Document buildDocument(Context context, Collection collection) throws SQLException, IOException {
        String location_text = DSIndexer.buildCollectionLocationString(context, collection);
        Document doc = DSIndexer.buildDocument(3, collection.getHandle(), location_text);
        String name = collection.getMetadata("name");
        if (name != null) {
            doc.add((Fieldable)new Field("name", name, Field.Store.YES, Field.Index.TOKENIZED));
            doc.add((Fieldable)new Field("default", name, Field.Store.YES, Field.Index.TOKENIZED));
        }
        return doc;
    }

    private static Document buildDocument(Context context, Item item) throws SQLException, IOException {
        int j;
        String handle = item.getHandle();
        if (handle == null) {
            handle = HandleManager.findHandle(context, item);
        }
        String location = DSIndexer.buildItemLocationString(context, item);
        Document doc = DSIndexer.buildDocument(2, handle, location);
        log.debug((Object)("Building Item: " + handle));
        int k = 0;
        if (indexConfigArr.length > 0) {
            int i;
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<String> content = new ArrayList<String>();
            for (i = 0; i < indexConfigArr.length; ++i) {
                DCValue[] mydc = DSIndexer.indexConfigArr[i].qualifier != null && DSIndexer.indexConfigArr[i].qualifier.equals("*") ? item.getMetadata(DSIndexer.indexConfigArr[i].schema, DSIndexer.indexConfigArr[i].element, "*", "*") : item.getMetadata(DSIndexer.indexConfigArr[i].schema, DSIndexer.indexConfigArr[i].element, DSIndexer.indexConfigArr[i].qualifier, "*");
                String content_text = "";
                for (j = 0; j < mydc.length; ++j) {
                    content_text = new String(content_text + mydc[j].value + " ");
                }
                k = fields.indexOf(DSIndexer.indexConfigArr[i].indexName);
                if (k < 0) {
                    fields.add(DSIndexer.indexConfigArr[i].indexName);
                    content.add(content_text);
                    continue;
                }
                content_text = new String(content_text + (String)content.get(k) + " ");
                content.set(k, content_text);
            }
            for (i = 0; i < fields.size(); ++i) {
                doc.add((Fieldable)new Field((String)fields.get(i), (String)content.get(i), Field.Store.YES, Field.Index.TOKENIZED));
                doc.add((Fieldable)new Field("default", (String)content.get(i), Field.Store.YES, Field.Index.TOKENIZED));
            }
        } else {
            DCValue[] authors = item.getDC("contributor", "*", "*");
            for (j = 0; j < authors.length; ++j) {
                doc.add((Fieldable)new Field("author", authors[j].value, Field.Store.YES, Field.Index.TOKENIZED));
                doc.add((Fieldable)new Field("default", authors[j].value, Field.Store.YES, Field.Index.TOKENIZED));
            }
            DCValue[] creators = item.getDC("creator", "*", "*");
            for (j = 0; j < creators.length; ++j) {
                doc.add((Fieldable)new Field("author", creators[j].value, Field.Store.YES, Field.Index.TOKENIZED));
                doc.add((Fieldable)new Field("default", creators[j].value, Field.Store.YES, Field.Index.TOKENIZED));
            }
            DCValue[] sors = item.getDC("description", "statementofresponsibility", "*");
            for (j = 0; j < sors.length; ++j) {
                doc.add((Fieldable)new Field("author", sors[j].value, Field.Store.YES, Field.Index.TOKENIZED));
                doc.add((Fieldable)new Field("default", sors[j].value, Field.Store.YES, Field.Index.TOKENIZED));
            }
            DCValue[] titles = item.getDC("title", "*", "*");
            for (j = 0; j < titles.length; ++j) {
                doc.add((Fieldable)new Field("title", titles[j].value, Field.Store.YES, Field.Index.TOKENIZED));
                doc.add((Fieldable)new Field("default", titles[j].value, Field.Store.YES, Field.Index.TOKENIZED));
            }
            DCValue[] keywords = item.getDC("subject", "*", "*");
            for (j = 0; j < keywords.length; ++j) {
                doc.add((Fieldable)new Field("keyword", keywords[j].value, Field.Store.YES, Field.Index.TOKENIZED));
                doc.add((Fieldable)new Field("default", keywords[j].value, Field.Store.YES, Field.Index.TOKENIZED));
            }
            DCValue[] abstracts = item.getDC("description", "abstract", "*");
            for (j = 0; j < abstracts.length; ++j) {
                doc.add((Fieldable)new Field("abstract", abstracts[j].value, Field.Store.YES, Field.Index.TOKENIZED));
                doc.add((Fieldable)new Field("default", abstracts[j].value, Field.Store.YES, Field.Index.TOKENIZED));
            }
            DCValue[] tocs = item.getDC("description", "tableofcontents", "*");
            for (j = 0; j < tocs.length; ++j) {
                doc.add((Fieldable)new Field("abstract", tocs[j].value, Field.Store.YES, Field.Index.TOKENIZED));
                doc.add((Fieldable)new Field("default", tocs[j].value, Field.Store.YES, Field.Index.TOKENIZED));
            }
            DCValue[] series = item.getDC("relation", "ispartofseries", "*");
            for (j = 0; j < series.length; ++j) {
                doc.add((Fieldable)new Field("series", series[j].value, Field.Store.YES, Field.Index.TOKENIZED));
                doc.add((Fieldable)new Field("default", series[j].value, Field.Store.YES, Field.Index.TOKENIZED));
            }
            DCValue[] mimetypes = item.getDC("format", "mimetype", "*");
            for (j = 0; j < mimetypes.length; ++j) {
                doc.add((Fieldable)new Field("mimetype", mimetypes[j].value, Field.Store.YES, Field.Index.TOKENIZED));
                doc.add((Fieldable)new Field("default", mimetypes[j].value, Field.Store.YES, Field.Index.TOKENIZED));
            }
            DCValue[] sponsors = item.getDC("description", "sponsorship", "*");
            for (j = 0; j < sponsors.length; ++j) {
                doc.add((Fieldable)new Field("sponsor", sponsors[j].value, Field.Store.YES, Field.Index.TOKENIZED));
                doc.add((Fieldable)new Field("default", sponsors[j].value, Field.Store.YES, Field.Index.TOKENIZED));
            }
            DCValue[] identifiers = item.getDC("identifier", "*", "*");
            for (j = 0; j < identifiers.length; ++j) {
                doc.add((Fieldable)new Field("identifier", identifiers[j].value, Field.Store.YES, Field.Index.TOKENIZED));
                doc.add((Fieldable)new Field("default", identifiers[j].value, Field.Store.YES, Field.Index.TOKENIZED));
            }
        }
        log.debug((Object)"  Added Metadata");
        try {
            Bundle[] myBundles = item.getBundles();
            for (int i = 0; i < myBundles.length; ++i) {
                if (myBundles[i].getName() == null || !myBundles[i].getName().equals("TEXT")) continue;
                Bitstream[] myBitstreams = myBundles[i].getBitstreams();
                for (j = 0; j < myBitstreams.length; ++j) {
                    try {
                        InputStreamReader is = new InputStreamReader(myBitstreams[j].retrieve());
                        doc.add((Fieldable)new Field("default", (Reader)is));
                        log.debug((Object)("  Added BitStream: " + myBitstreams[j].getStoreNumber() + "\t" + myBitstreams[j].getSequenceID() + "   " + myBitstreams[j].getName()));
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return doc;
    }

    private static Document buildDocument(int type, String handle, String location) {
        Document doc = new Document();
        doc.add((Fieldable)new Field(LAST_INDEXED_FIELD, Long.toString(System.currentTimeMillis()), Field.Store.YES, Field.Index.UN_TOKENIZED));
        doc.add((Fieldable)new Field("type", Integer.toString(type), Field.Store.YES, Field.Index.NO));
        if (handle != null) {
            doc.add((Fieldable)new Field("handletext", handle, Field.Store.YES, Field.Index.TOKENIZED));
            doc.add((Fieldable)new Field("handle", handle, Field.Store.YES, Field.Index.UN_TOKENIZED));
            doc.add((Fieldable)new Field("default", handle, Field.Store.YES, Field.Index.TOKENIZED));
        }
        if (location != null) {
            doc.add((Fieldable)new Field("location", location, Field.Store.YES, Field.Index.TOKENIZED));
            doc.add((Fieldable)new Field("default", location, Field.Store.YES, Field.Index.TOKENIZED));
        }
        return doc;
    }

    static {
        if (ConfigurationManager.getProperty("search.maxfieldlength") != null) {
            maxfieldlength = ConfigurationManager.getIntProperty("search.maxfieldlength");
        }
        ArrayList<String> indexConfigList = new ArrayList<String>();
        int i = 1;
        while (ConfigurationManager.getProperty("search.index." + i) != null) {
            indexConfigList.add(ConfigurationManager.getProperty("search.index." + i));
            ++i;
        }
        if (indexConfigList.size() > 0) {
            indexConfigArr = new IndexConfig[indexConfigList.size()];
            block7: for (i = 0; i < indexConfigList.size(); ++i) {
                DSIndexer.indexConfigArr[i] = new IndexConfig();
                String index = (String)indexConfigList.get(i);
                String[] configLine = index.split(":");
                DSIndexer.indexConfigArr[i].indexName = configLine[0];
                String[] parts = configLine[1].split("\\.");
                switch (parts.length) {
                    case 3: {
                        DSIndexer.indexConfigArr[i].qualifier = parts[2];
                    }
                    case 2: {
                        DSIndexer.indexConfigArr[i].schema = parts[0];
                        DSIndexer.indexConfigArr[i].element = parts[1];
                        continue block7;
                    }
                    default: {
                        log.warn((Object)("Malformed configuration line: search.index." + i));
                        throw new RuntimeException("Malformed configuration line: search.index." + i);
                    }
                }
            }
        }
        IndexWriter.setDefaultWriteLockTimeout((long)30000L);
        if (!IndexReader.indexExists((String)index_directory)) {
            try {
                new File(index_directory).mkdirs();
                DSIndexer.openIndex(null, true).close();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create search index: " + e.getMessage(), e);
            }
        }
    }

    private static class IndexConfig {
        String indexName;
        String schema;
        String element;
        String qualifier = null;

        private IndexConfig() {
        }
    }
}

