/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;

public abstract class AbstractProcessingStep {
    public static String PREVIOUS_BUTTON = "submit_prev";
    public static String NEXT_BUTTON = "submit_next";
    public static String CANCEL_BUTTON = "submit_cancel";
    public static String PROGRESS_BAR_PREFIX = "submit_jump_";
    public static int LAST_PAGE_REACHED = Integer.MAX_VALUE;
    public static int STATUS_COMPLETE = 0;
    private Map errorMessages = null;
    private List errorFields = null;

    public abstract int doProcessing(Context var1, HttpServletRequest var2, HttpServletResponse var3, SubmissionInfo var4) throws ServletException, IOException, SQLException, AuthorizeException;

    public final List getErrorFields() {
        return this.errorFields;
    }

    protected final void addErrorField(String fieldName) {
        if (this.errorFields == null) {
            this.errorFields = new ArrayList();
        }
        this.errorFields.add(fieldName);
    }

    protected final void clearErrorFields() {
        if (this.errorFields != null) {
            this.errorFields.clear();
        }
    }

    public final String getErrorMessage(int errorFlag) {
        if (this.errorMessages == null || this.errorMessages.size() == 0) {
            return null;
        }
        return (String)this.errorMessages.get(errorFlag);
    }

    protected final void addErrorMessage(int errorFlag, String errorMessage) {
        if (this.errorMessages == null) {
            this.errorMessages = new HashMap();
        }
        this.errorMessages.put(errorFlag, errorMessage);
    }

    public abstract int getNumberOfPages(HttpServletRequest var1, SubmissionInfo var2) throws ServletException;

    public static final int getCurrentPage(HttpServletRequest request) {
        int pageNum = -1;
        Integer currentPage = (Integer)request.getAttribute("submission.page");
        if (currentPage == null) {
            String val = request.getParameter("page");
            try {
                pageNum = Integer.parseInt(val.trim());
            }
            catch (Exception e) {
                pageNum = -1;
            }
            if (pageNum < 0) {
                pageNum = 1;
                AbstractProcessingStep.setCurrentPage(request, pageNum);
            } else {
                AbstractProcessingStep.setCurrentPage(request, pageNum);
            }
        } else {
            pageNum = currentPage;
        }
        return pageNum;
    }

    public static final void setCurrentPage(HttpServletRequest request, int pageNumber) {
        request.setAttribute("submission.page", (Object)new Integer(pageNumber));
    }
}

