/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.util.List;
import java.util.Map;
import org.dspace.app.util.DCInput;

public class DCInputSet {
    private String formName = null;
    private DCInput[][] inputs = null;

    public DCInputSet(String formName, List<List<Map<String, String>>> rows, Map<String, List<String>> listMap) {
        this.formName = formName;
        this.inputs = new DCInput[rows.size()][];
        for (int i = 0; i < this.inputs.length; ++i) {
            List<Map<String, String>> fields = rows.get(i);
            this.inputs[i] = new DCInput[fields.size()];
            for (int j = 0; j < this.inputs[i].length; ++j) {
                Map<String, String> field = rows.get(i).get(j);
                this.inputs[i][j] = new DCInput(field, listMap);
            }
        }
    }

    public String getFormName() {
        return this.formName;
    }

    public int getNumberFields() {
        return this.inputs.length;
    }

    public DCInput[][] getFields() {
        return this.inputs;
    }

    public boolean isDefinedMultTitles() {
        return this.isFieldPresent("dc.title.alternative");
    }

    public boolean isDefinedPubBefore() {
        return this.isFieldPresent("dc.date.issued") && this.isFieldPresent("dc.identifier.citation") && this.isFieldPresent("dc.publisher");
    }

    public boolean isFieldPresent(String fieldName) {
        for (int i = 0; i < this.inputs.length; ++i) {
            for (int j = 0; j < this.inputs[i].length; ++j) {
                DCInput field = this.inputs[i][j];
                String fullName = field.getFieldName();
                if (!fullName.equals(fieldName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFieldPresent(String fieldName, String documentType) {
        if (documentType == null) {
            documentType = "";
        }
        for (int i = 0; i < this.inputs.length; ++i) {
            for (int j = 0; j < this.inputs[i].length; ++j) {
                DCInput field = this.inputs[i][j];
                String fullName = field.getFieldName();
                if (!fullName.equals(fieldName) || !field.isAllowedFor(documentType)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean doField(DCInput dcf, boolean addTitleAlternative, boolean addPublishedBefore) {
        String rowName = dcf.getFieldName();
        if (rowName.equals("dc.title.alternative") && !addTitleAlternative) {
            return false;
        }
        if (rowName.equals("dc.date.issued") && !addPublishedBefore) {
            return false;
        }
        if (rowName.equals("dc.publisher.null") && !addPublishedBefore) {
            return false;
        }
        return !rowName.equals("dc.identifier.citation") || addPublishedBefore;
    }
}

