/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.util.Iterator;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;

public class BrowserScope {
    private Context context;
    private BrowseIndex browseIndex;
    private String order;
    private int sortBy;
    private String filterValue;
    private boolean filterValuePartial = false;
    private String filterValueLang;
    private int jumpItemId = -1;
    private String startsWith;
    private int resultsPerPage = 20;
    private Collection collection;
    private Community community;
    private SortOption sortOption;
    private String jumpValue;
    private String jumpValueLang;
    private int level = 0;
    private int etAl = 0;
    private int offset = 0;
    private String authority = null;
    private String userLocale = null;

    public BrowserScope(Context context) {
        this.context = context;
    }

    public void setBrowseContainer(IndexableObject dso) throws BrowseException {
        if (dso instanceof Collection) {
            this.collection = (Collection)dso;
        } else if (dso instanceof Community) {
            this.community = (Community)dso;
        } else {
            throw new BrowseException("The container must be a community or a collection");
        }
    }

    public DSpaceObject getBrowseContainer() {
        if (this.collection != null) {
            return this.collection;
        }
        if (this.community != null) {
            return this.community;
        }
        return null;
    }

    public void setBrowseLevel(int level) {
        this.level = level;
    }

    public int getBrowseLevel() {
        return this.level;
    }

    public boolean isTopLevel() {
        return this.level == 0;
    }

    public boolean isSecondLevel() {
        return this.level == 1;
    }

    public BrowseIndex getBrowseIndex() {
        return this.browseIndex;
    }

    public void setBrowseIndex(BrowseIndex browseIndex) throws BrowseException {
        this.browseIndex = browseIndex;
    }

    public int getEtAl() {
        return this.etAl;
    }

    public void setEtAl(int etAl) {
        this.etAl = etAl;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    public Community getCommunity() {
        return this.community;
    }

    public void setCommunity(Community community) {
        this.community = community;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public int getJumpToItem() {
        return this.jumpItemId;
    }

    public void setJumpToItem(int itemId) {
        this.jumpItemId = itemId;
    }

    public String getJumpToValue() {
        return this.jumpValue;
    }

    public void setJumpToValue(String value) {
        this.jumpValue = value;
    }

    public String getJumpToValueLang() {
        return this.jumpValueLang;
    }

    public void setJumpToValueLang(String valueLang) {
        this.jumpValueLang = valueLang;
    }

    public String getOrder() {
        if (this.order != null) {
            return this.order;
        }
        BrowseIndex bi = this.getBrowseIndex();
        if (bi != null) {
            return bi.getDefaultOrder();
        }
        return "ASC";
    }

    public void setOrder(String order) {
        if (order == null) {
            this.order = null;
        } else if ("ASC".equalsIgnoreCase(order)) {
            this.order = "ASC";
        } else if ("DESC".equalsIgnoreCase(order)) {
            this.order = "DESC";
        }
    }

    public int getResultsPerPage() {
        return this.resultsPerPage;
    }

    public void setResultsPerPage(int resultsPerPage) {
        if (resultsPerPage > -1 || this.browseIndex != null && this.browseIndex.isTagCloudEnabled()) {
            this.resultsPerPage = resultsPerPage;
        }
    }

    public int getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(int sortBy) throws BrowseException {
        this.sortBy = sortBy;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public SortOption getSortOption() throws BrowseException {
        try {
            if (this.sortOption == null && this.browseIndex != null) {
                if (this.sortBy <= 0 && this.browseIndex.isMetadataIndex()) {
                    String dataType = this.browseIndex.getDataType();
                    String type = "date".equals(dataType) ? "date" : "text";
                    this.sortOption = new SortOption(0, this.browseIndex.getName(), this.browseIndex.getMetadata(0), type);
                } else if (this.sortBy <= 0) {
                    Iterator<SortOption> dataType;
                    this.sortOption = this.browseIndex.getSortOption();
                    if (this.sortOption == null && (dataType = SortOption.getSortOptions().iterator()).hasNext()) {
                        SortOption so;
                        this.sortOption = so = dataType.next();
                    }
                } else {
                    for (SortOption so : SortOption.getSortOptions()) {
                        if (so.getNumber() != this.sortBy) continue;
                        this.sortOption = so;
                    }
                }
            }
            return this.sortOption;
        }
        catch (SortException se) {
            throw new BrowseException("Error in SortOptions", se);
        }
    }

    public String getStartsWith() {
        return this.startsWith;
    }

    public void setStartsWith(String startsWith) {
        this.startsWith = startsWith;
    }

    public String getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(String value) {
        this.filterValue = value;
    }

    public boolean getFilterValuePartial() {
        return this.filterValuePartial;
    }

    public void setFilterValuePartial(boolean filterValuePartial) {
        this.filterValuePartial = filterValuePartial;
    }

    public String getFilterValueLang() {
        return this.filterValueLang;
    }

    public void setFilterValueLang(String lang) {
        this.filterValueLang = lang;
    }

    public boolean inCommunity() {
        return this.community != null;
    }

    public boolean inCollection() {
        return this.collection != null;
    }

    public boolean isAscending() {
        if ("ASC".equalsIgnoreCase(this.order)) {
            return true;
        }
        if ("DESC".equalsIgnoreCase(this.order)) {
            return false;
        }
        BrowseIndex bi = this.getBrowseIndex();
        return bi == null || !"DESC".equalsIgnoreCase(bi.getDefaultOrder());
    }

    public boolean hasFilterValue() {
        return this.filterValue != null && !"".equals(this.filterValue);
    }

    public boolean hasJumpToItem() {
        return this.jumpItemId != -1;
    }

    public boolean hasJumpToValue() {
        return this.jumpValue != null;
    }

    public boolean hasStartsWith() {
        return this.startsWith != null;
    }

    public String getAuthorityValue() {
        return this.authority;
    }

    public void setAuthorityValue(String value) {
        this.authority = value;
    }

    public void setUserLocale(String userLocale) {
        this.userLocale = userLocale;
    }

    public String getUserLocale() {
        return this.userLocale;
    }
}

