/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.EntityType;
import org.dspace.content.RelationshipType;
import org.dspace.content.dao.RelationshipTypeDAO;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class RelationshipTypeServiceImpl
implements RelationshipTypeService {
    @Autowired(required=true)
    protected RelationshipTypeDAO relationshipTypeDAO;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;

    @Override
    public RelationshipType create(Context context) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators can modify relationshipType");
        }
        return this.relationshipTypeDAO.create(context, new RelationshipType());
    }

    @Override
    public RelationshipType create(Context context, RelationshipType relationshipType) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators can modify relationshipType");
        }
        return this.relationshipTypeDAO.create(context, relationshipType);
    }

    @Override
    public RelationshipType findbyTypesAndLabels(Context context, EntityType leftType, EntityType rightType, String leftLabel, String rightLabel) throws SQLException {
        return this.relationshipTypeDAO.findByTypesAndLabels(context, leftType, rightType, leftLabel, rightLabel);
    }

    @Override
    public List<RelationshipType> findAll(Context context) throws SQLException {
        return this.relationshipTypeDAO.findAll(context, RelationshipType.class);
    }

    @Override
    public List<RelationshipType> findByLeftOrRightLabel(Context context, String label) throws SQLException {
        return this.relationshipTypeDAO.findByLeftOrRightLabel(context, label);
    }

    @Override
    public List<RelationshipType> findByEntityType(Context context, EntityType entityType) throws SQLException {
        return this.relationshipTypeDAO.findByEntityType(context, entityType);
    }

    @Override
    public RelationshipType create(Context context, EntityType leftEntityType, EntityType rightEntityType, String leftLabel, String rightLabel, Integer leftCardinalityMinInteger, Integer leftCardinalityMaxInteger, Integer rightCardinalityMinInteger, Integer rightCardinalityMaxInteger) throws SQLException, AuthorizeException {
        RelationshipType relationshipType = new RelationshipType();
        relationshipType.setLeftType(leftEntityType);
        relationshipType.setRightType(rightEntityType);
        relationshipType.setLeftLabel(leftLabel);
        relationshipType.setRightLabel(rightLabel);
        relationshipType.setLeftMinCardinality(leftCardinalityMinInteger);
        relationshipType.setLeftMaxCardinality(leftCardinalityMaxInteger);
        relationshipType.setRightMinCardinality(rightCardinalityMinInteger);
        relationshipType.setRightMaxCardinality(rightCardinalityMaxInteger);
        return this.create(context, relationshipType);
    }

    @Override
    public RelationshipType find(Context context, int id) throws SQLException {
        return (RelationshipType)this.relationshipTypeDAO.findByID(context, RelationshipType.class, id);
    }

    @Override
    public void update(Context context, RelationshipType relationshipType) throws SQLException, AuthorizeException {
        this.update(context, Collections.singletonList(relationshipType));
    }

    @Override
    public void update(Context context, List<RelationshipType> relationshipTypes) throws SQLException, AuthorizeException {
        if (CollectionUtils.isNotEmpty(relationshipTypes)) {
            if (!this.authorizeService.isAdmin(context)) {
                throw new AuthorizeException("Only administrators can modify RelationshipType");
            }
            for (RelationshipType relationshipType : relationshipTypes) {
                this.relationshipTypeDAO.save(context, relationshipType);
            }
        }
    }

    @Override
    public void delete(Context context, RelationshipType relationshipType) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators can delete entityType");
        }
        this.relationshipTypeDAO.delete(context, relationshipType);
    }
}

