/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccessBufferedFileInputStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.packager.PackageDisseminator;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.SelfNamedPlugin;
import org.dspace.core.Utils;
import org.dspace.workflow.WorkflowException;

public class PDFPackager
extends SelfNamedPlugin
implements PackageIngester,
PackageDisseminator {
    private static final Logger log = LogManager.getLogger(PDFPackager.class);
    protected static final String BITSTREAM_FORMAT_NAME = "Adobe PDF";
    protected static String[] aliases = new String[]{"PDF", "Adobe PDF", "pdf", "application/pdf"};
    protected final BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected final BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected final BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    protected final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected final WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();

    public static String[] getPluginNames() {
        return (String[])ArrayUtils.clone((Object[])aliases);
    }

    protected void setFormatToMIMEType(Context context, Bitstream bs, String mimeType) throws SQLException {
        List<BitstreamFormat> bf = this.bitstreamFormatService.findNonInternal(context);
        for (BitstreamFormat aBf : bf) {
            if (!aBf.getMIMEType().equalsIgnoreCase(mimeType)) continue;
            bs.setFormat(context, aBf);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DSpaceObject ingest(Context context, DSpaceObject parent, File pkgFile, PackageParameters params, String license) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException, WorkflowException {
        Item item;
        block12: {
            WorkspaceItem wi;
            block13: {
                boolean success = false;
                Bundle original = null;
                Bitstream bs = null;
                wi = null;
                try {
                    wi = this.workspaceItemService.create(context, (Collection)parent, false);
                    Item myitem = wi.getItem();
                    original = this.bundleService.create(context, myitem, "ORIGINAL");
                    try (FileInputStream fileStream = null;){
                        fileStream = new FileInputStream(pkgFile);
                        bs = this.bitstreamService.create(context, original, fileStream);
                    }
                    bs.setName(context, "package.pdf");
                    this.setFormatToMIMEType(context, bs, "application/pdf");
                    this.bitstreamService.update(context, bs);
                    if (log.isDebugEnabled()) {
                        log.debug("Created bitstream ID=" + String.valueOf(bs.getID()) + ", parsing...");
                    }
                    this.crosswalkPDF(context, myitem, this.bitstreamService.retrieve(context, bs));
                    this.workspaceItemService.update(context, wi);
                    success = true;
                    log.info(org.dspace.core.LogManager.getHeader(context, "ingest", "Created new Item, db ID=" + String.valueOf(myitem.getID()) + ", WorkspaceItem ID=" + String.valueOf(wi.getID())));
                    item = myitem = PackageUtils.finishCreateItem(context, wi, null, params);
                    if (success) break block12;
                    if (original == null || bs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        if (original != null && bs != null) {
                            this.bundleService.removeBitstream(context, original, bs);
                        }
                        if (wi != null) {
                            this.workspaceItemService.deleteAll(context, wi);
                        }
                    }
                    context.complete();
                    throw throwable;
                }
                this.bundleService.removeBitstream(context, original, bs);
            }
            if (wi != null) {
                this.workspaceItemService.deleteAll(context, wi);
            }
        }
        context.complete();
        return item;
    }

    @Override
    public List<String> ingestAll(Context context, DSpaceObject parent, File pkgFile, PackageParameters params, String license) throws PackageException, UnsupportedOperationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        throw new UnsupportedOperationException("PDF packager does not support the ingestAll() operation at this time.");
    }

    @Override
    public DSpaceObject replace(Context context, DSpaceObject dso, File pkgFile, PackageParameters params) throws PackageException, UnsupportedOperationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        throw new UnsupportedOperationException("PDF packager does not support the replace() operation at this time.");
    }

    @Override
    public List<String> replaceAll(Context context, DSpaceObject dso, File pkgFile, PackageParameters params) throws PackageException, UnsupportedOperationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        throw new UnsupportedOperationException("PDF packager does not support the replaceAll() operation at this time.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disseminate(Context context, DSpaceObject dso, PackageParameters params, File pkgFile) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        if (dso.getType() != 2) {
            throw new PackageValidationException("This disseminator can only handle objects of type ITEM.");
        }
        Item item = (Item)dso;
        BitstreamFormat pdff = this.bitstreamFormatService.findByShortDescription(context, BITSTREAM_FORMAT_NAME);
        if (pdff == null) {
            throw new PackageValidationException("Cannot find BitstreamFormat \"Adobe PDF\"");
        }
        Bitstream pkgBs = PackageUtils.getBitstreamByFormat(context, item, pdff, "ORIGINAL");
        if (pkgBs == null) {
            throw new PackageValidationException("Cannot find Bitstream with format \"Adobe PDF\"");
        }
        if (!pkgFile.exists()) {
            PackageUtils.createFile(pkgFile);
        }
        try (FileOutputStream out = null;){
            out = new FileOutputStream(pkgFile);
            Utils.copy(this.bitstreamService.retrieve(context, pkgBs), out);
        }
    }

    @Override
    public List<File> disseminateAll(Context context, DSpaceObject dso, PackageParameters params, File pkgFile) throws PackageException, CrosswalkException, AuthorizeException, SQLException, IOException {
        throw new UnsupportedOperationException("PDF packager does not support the disseminateAll() operation at this time.");
    }

    @Override
    public String getMIMEType(PackageParameters params) {
        return "application/pdf";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crosswalkPDF(Context context, Item item, InputStream metadata) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        try (COSDocument cos = null;){
            Calendar calValue;
            ScratchFile scratchFile = null;
            try {
                long useRAM = Runtime.getRuntime().freeMemory() * 80L / 100L;
                scratchFile = new ScratchFile(MemoryUsageSetting.setupMixed((long)useRAM));
            }
            catch (IOException ioe) {
                log.warn("Error initializing scratch file: " + ioe.getMessage());
            }
            PDFParser parser = new PDFParser((RandomAccessRead)new RandomAccessBufferedFileInputStream(metadata), scratchFile);
            parser.parse();
            cos = parser.getDocument();
            if (cos.getEncryptionDictionary() != null) {
                throw new MetadataValidationException("This packager cannot accept an encrypted PDF document.");
            }
            PDDocument pd = new PDDocument(cos);
            PDDocumentInformation docinfo = pd.getDocumentInformation();
            String title = docinfo.getTitle();
            if (title == null) {
                throw new MetadataValidationException("This PDF file is unacceptable, it does not have a value for \"Title\" in its Info dictionary.");
            }
            if (log.isDebugEnabled()) {
                log.debug("PDF Info dict title=\"" + title + "\"");
            }
            this.itemService.addMetadata(context, item, MetadataSchemaEnum.DC.getName(), "title", null, "en", title);
            String value = docinfo.getAuthor();
            if (value != null) {
                this.itemService.addMetadata(context, item, MetadataSchemaEnum.DC.getName(), "contributor", "author", null, value);
                if (log.isDebugEnabled()) {
                    log.debug("PDF Info dict author=\"" + value + "\"");
                }
            }
            if ((value = docinfo.getCreator()) != null) {
                this.itemService.addMetadata(context, item, MetadataSchemaEnum.DC.getName(), "description", "provenance", "en", "Application that created the original document: " + value);
            }
            if ((value = docinfo.getProducer()) != null) {
                this.itemService.addMetadata(context, item, MetadataSchemaEnum.DC.getName(), "description", "provenance", "en", "Original document converted to PDF by: " + value);
            }
            if ((value = docinfo.getSubject()) != null) {
                this.itemService.addMetadata(context, item, MetadataSchemaEnum.DC.getName(), "description", "abstract", null, value);
            }
            if ((value = docinfo.getKeywords()) != null) {
                this.itemService.addMetadata(context, item, MetadataSchemaEnum.DC.getName(), "subject", "other", null, value);
            }
            if ((calValue = docinfo.getCreationDate()) == null) {
                calValue = docinfo.getModificationDate();
            }
            if (calValue != null) {
                this.itemService.addMetadata(context, item, MetadataSchemaEnum.DC.getName(), "date", "created", null, new DCDate(calValue.getTime()).toString());
            }
            this.itemService.update(context, item);
        }
    }

    @Override
    public String getParameterHelp() {
        return "No additional options available.";
    }
}

