/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.ctask.general;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.ctask.general.MetadataWebServiceDataInfo;
import org.dspace.curate.AbstractCurationTask;
import org.dspace.curate.Curator;
import org.dspace.curate.Mutative;
import org.dspace.curate.Suspendable;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Mutative
@Suspendable
public class MetadataWebService
extends AbstractCurationTask
implements NamespaceContext {
    private static final Logger log = LogManager.getLogger(MetadataWebService.class);
    protected Pattern ttPattern = Pattern.compile("'([^']*)'|(\\S+)");
    protected String urlTemplate = null;
    protected String templateParam = null;
    protected String lookupField = null;
    protected String lookupTransform = null;
    protected List<MetadataWebServiceDataInfo> dataList = null;
    protected DocumentBuilder docBuilder = null;
    protected String lang = null;
    protected String fieldSeparator = null;
    protected Map<String, String> nsMap = new HashMap<String, String>();
    protected Map<String, String> headers = new HashMap<String, String>();

    @Override
    public void init(Curator curator, String taskId) throws IOException {
        super.init(curator, taskId);
        this.lang = this.configurationService.getProperty("default.language");
        String fldSep = this.taskProperty("separator");
        this.fieldSeparator = fldSep != null ? fldSep : " ";
        this.urlTemplate = this.taskProperty("template");
        this.templateParam = this.urlTemplate.substring(this.urlTemplate.indexOf("{") + 1, this.urlTemplate.indexOf("}"));
        String[] parsed = this.parseTransform(this.templateParam);
        this.lookupField = parsed[0];
        this.lookupTransform = parsed[1];
        this.dataList = new ArrayList<MetadataWebServiceDataInfo>();
        for (String entry : this.taskArrayProperty("datamap")) {
            int slIdx;
            String src = entry = entry.trim();
            String mapping = null;
            String field = null;
            int mapIdx = this.getMapIndex(entry);
            if (mapIdx > 0) {
                src = entry.substring(0, mapIdx);
                mapping = entry.substring(mapIdx, mapIdx + 2);
                field = entry.substring(mapIdx + 2);
            }
            String label = (slIdx = src.lastIndexOf("/")) > 0 ? src.substring(slIdx + 1) : src;
            this.dataList.add(new MetadataWebServiceDataInfo(this, src, label, mapping, field));
        }
        String hdrs = this.taskProperty("headers");
        if (hdrs != null) {
            for (String header : hdrs.split("\\|\\|")) {
                int split = header.indexOf(":");
                this.headers.put(header.substring(0, split).trim(), header.substring(split + 1).trim());
            }
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            this.docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pcE) {
            log.error("caught exception: " + pcE);
            throw new IOException(pcE.getMessage(), pcE);
        }
    }

    @Override
    public int perform(DSpaceObject dso) throws IOException {
        int status = 2;
        StringBuilder resultSb = new StringBuilder();
        if (dso.getType() == 2) {
            Item item = (Item)dso;
            String itemId = item.getHandle();
            if (itemId == null) {
                List<MetadataValue> titleDc = this.itemService.getMetadata(item, "dc", "title", null, "*");
                String title = titleDc.size() > 0 ? titleDc.get(0).getValue() : "untitled - dbId: " + item.getID();
                itemId = "Workflow item: " + title;
            } else {
                itemId = "handle: " + itemId;
            }
            resultSb.append(itemId);
            List<MetadataValue> dcVals = this.itemService.getMetadataByMetadataString(item, this.lookupField);
            if (dcVals.size() > 0 && dcVals.get(0).getValue().length() > 0) {
                String value = this.transform(dcVals.get(0).getValue(), this.lookupTransform);
                status = this.callService(value, item, resultSb);
            } else {
                resultSb.append(" lacks metadata value required for service: ").append(this.lookupField);
                status = 1;
            }
        } else {
            resultSb.append("Object skipped");
        }
        this.report(resultSb.toString());
        this.setResult(resultSb.toString());
        return status;
    }

    protected int callService(String value, Item item, StringBuilder resultSb) throws IOException {
        String callUrl = this.urlTemplate.replaceAll("\\{" + this.templateParam + "\\}", value);
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet req = new HttpGet(callUrl);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            req.addHeader(entry.getKey(), entry.getValue());
        }
        HttpResponse resp = client.execute((HttpUriRequest)req);
        int status = -1;
        int statusCode = resp.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            HttpEntity entity = resp.getEntity();
            if (entity != null) {
                try (InputStream instream = entity.getContent();){
                    Document doc = this.docBuilder.parse(instream);
                    status = this.processResponse(doc, item, resultSb);
                }
                client.getConnectionManager().shutdown();
            } else {
                log.error(" obtained no valid service response");
                resultSb.append("no service response");
            }
        } else {
            log.error("service returned non-OK status: " + statusCode);
            resultSb.append("no service response");
        }
        return status;
    }

    protected int processResponse(Document doc, Item item, StringBuilder resultSb) throws IOException {
        boolean update = false;
        int status = -1;
        ArrayList<String> values = new ArrayList<String>();
        this.checkNamespaces(doc);
        try {
            for (MetadataWebServiceDataInfo info : this.dataList) {
                NodeList nodes = (NodeList)info.getExpr().evaluate(doc, XPathConstants.NODESET);
                values.clear();
                if (nodes.getLength() > 0 && info.getMapping() != null) {
                    if ("=>".equals(info.getMapping())) {
                        this.itemService.clearMetadata(Curator.curationContext(), item, info.getSchema(), info.getElement(), info.getQualifier(), "*");
                    } else if ("~>".equals(info.getMapping())) {
                        if (this.itemService.getMetadata(item, info.getSchema(), info.getElement(), info.getQualifier(), "*").size() > 0) {
                            continue;
                        }
                    } else {
                        for (MetadataValue dcVal : this.itemService.getMetadata(item, info.getSchema(), info.getElement(), info.getQualifier(), "*")) {
                            values.add(dcVal.getValue());
                        }
                    }
                }
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String tvalue = this.transform(node.getFirstChild().getNodeValue(), info.getTransform());
                    if (info.getMapping() != null && !values.contains(tvalue)) {
                        this.itemService.addMetadata(Curator.curationContext(), item, info.getSchema(), info.getElement(), info.getQualifier(), this.lang, tvalue);
                        update = true;
                    }
                    resultSb.append(this.fieldSeparator).append(info.getLabel()).append(": ").append(tvalue);
                }
            }
            if (update) {
                this.itemService.update(Curator.curationContext(), item);
            }
            status = 0;
        }
        catch (AuthorizeException authE) {
            log.error("caught exception: " + authE);
            resultSb.append(" not authorized to update");
            status = 1;
        }
        catch (SQLException sqlE) {
            log.error("caught exception: " + sqlE);
            resultSb.append(" error updating metadata");
        }
        catch (XPathExpressionException xpeE) {
            log.error("caught exception: " + xpeE);
            resultSb.append(" error reading response document");
        }
        return status;
    }

    protected String transform(String value, String transDef) {
        if (transDef == null) {
            return value;
        }
        String[] tokens = this.tokenize(transDef);
        String retValue = value;
        for (int i = 0; i < tokens.length; i += 2) {
            if ("cut".equals(tokens[i]) || "trunc".equals(tokens[i])) {
                int index = Integer.parseInt(tokens[i + 1]);
                if (retValue.length() > index) {
                    if ("cut".equals(tokens[i])) {
                        retValue = retValue.substring(index);
                        continue;
                    }
                    retValue = retValue.substring(0, index);
                    continue;
                }
                if (!"cut".equals(tokens[i])) continue;
                log.error("requested cut: " + index + " exceeds value length");
                return value;
            }
            if ("match".equals(tokens[i])) {
                int index2 = retValue.indexOf(tokens[i + 1]);
                if (index2 > 0) {
                    retValue = retValue.substring(index2);
                    continue;
                }
                log.error("requested match: " + tokens[i + 1] + " failed");
                return value;
            }
            if ("text".equals(tokens[i])) {
                retValue = retValue + tokens[i + 1];
                continue;
            }
            log.error(" unknown transform operation: " + tokens[i]);
            return value;
        }
        return retValue;
    }

    protected String[] tokenize(String text) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = this.ttPattern.matcher(text);
        while (m.find()) {
            if (m.group(1) != null) {
                list.add(m.group(1));
                continue;
            }
            if (m.group(2) == null) continue;
            list.add(m.group(2));
        }
        return list.toArray(new String[0]);
    }

    protected int getMapIndex(String mapping) {
        int index = mapping.indexOf("->");
        if (index == -1) {
            index = mapping.indexOf("=>");
        }
        if (index == -1) {
            index = mapping.indexOf("~>");
        }
        return index;
    }

    protected String[] parseTransform(String field) {
        String[] parsed = new String[2];
        parsed[0] = field;
        int txIdx = field.indexOf(":");
        if (txIdx > 0) {
            String txName = field.substring(0, txIdx);
            parsed[1] = this.taskProperty("transform." + txName);
            if (parsed[1] == null) {
                log.error("no transform found for: " + txName);
            }
            parsed[0] = field.substring(txIdx + 1);
        }
        return parsed;
    }

    protected void checkNamespaces(Document document) throws IOException {
        if (this.dataList.get(0).getExpr() != null) {
            return;
        }
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            String prefix = null;
            NamedNodeMap attrs = document.getDocumentElement().getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node n = attrs.item(i);
                String name = n.getNodeName();
                if (!name.startsWith("xmlns")) continue;
                if (!"xmlns".equals(name)) {
                    this.nsMap.put(name.substring(name.indexOf(":") + 1), n.getNodeValue());
                    continue;
                }
                prefix = "pre";
                this.nsMap.put(prefix, n.getNodeValue());
            }
            if (this.nsMap.size() > 0) {
                xpath.setNamespaceContext(this);
            }
            for (MetadataWebServiceDataInfo info : this.dataList) {
                info.setExpr(xpath.compile(this.mangleExpr(info.getXpsrc(), prefix)));
            }
        }
        catch (XPathExpressionException xpeE) {
            log.error("caught exception: " + xpeE);
            throw new IOException(xpeE.getMessage(), xpeE);
        }
    }

    protected String mangleExpr(String expr, String prefix) {
        if (prefix == null) {
            return expr;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < expr.length()) {
            String token;
            if (expr.charAt(i) == '/') {
                sb.append("/");
                ++i;
                continue;
            }
            int next = expr.indexOf("/", i);
            String string = token = next > 0 ? expr.substring(i, next) : expr.substring(i);
            if (!token.startsWith("@") && token.indexOf(":") < 0) {
                sb.append(prefix).append(":");
            }
            sb.append(token);
            i += token.length();
        }
        return sb.toString();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new NullPointerException("Null prefix");
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        String nsURI = this.nsMap.get(prefix);
        return nsURI != null ? nsURI : "";
    }

    @Override
    public String getPrefix(String uri) {
        throw new UnsupportedOperationException();
    }

    public Iterator getPrefixes(String uri) {
        throw new UnsupportedOperationException();
    }
}

