/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.util.List;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SolrServiceIndexPlugin;

public class SolrServiceContentInOriginalBundleFilterPlugin
implements SolrServiceIndexPlugin {
    @Override
    public void additionalIndex(Context context, IndexableObject dso, SolrInputDocument document) {
        if (dso instanceof Item) {
            Item item = (Item)dso;
            boolean hasOriginalBundleWithContent = this.hasOriginalBundleWithContent(item);
            if (!hasOriginalBundleWithContent) {
                document.addField("has_content_in_original_bundle", (Object)false);
                document.addField("has_content_in_original_bundle_keyword", (Object)false);
                document.addField("has_content_in_original_bundle_filter", (Object)false);
            } else {
                document.addField("has_content_in_original_bundle", (Object)true);
                document.addField("has_content_in_original_bundle_keyword", (Object)true);
                document.addField("has_content_in_original_bundle_filter", (Object)true);
            }
        }
    }

    private boolean hasOriginalBundleWithContent(Item item) {
        List<Bundle> bundles = item.getBundles();
        if (bundles != null) {
            for (Bundle curBundle : bundles) {
                List<Bitstream> bitstreams;
                String bName = curBundle.getName();
                if (bName == null || !bName.equals("ORIGINAL") || (bitstreams = curBundle.getBitstreams()) == null || bitstreams.size() <= 0) continue;
                return true;
            }
        }
        return false;
    }
}

