/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.handle;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataValueService;
import org.dspace.core.Context;
import org.dspace.discovery.IndexClient;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class UpdateHandlePrefix {
    private static final Logger log = LogManager.getLogger(UpdateHandlePrefix.class);
    private static final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    private UpdateHandlePrefix() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("\nUsage: update-handle-prefix <old handle> <new handle>\n");
            System.exit(1);
        } else {
            HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
            String oldH = args[0];
            String newH = args[1];
            System.out.println("\nGetting information about handles from database...");
            Context context = new Context();
            long count = handleService.countHandlesByPrefix(context, oldH);
            if (count > 0L) {
                System.out.println("In your repository will be updated " + count + " handle" + (count > 1L ? "s" : "") + " to new prefix " + newH + " from original " + oldH + "!\n");
                System.out.print("Servlet container (e.g. Apache Tomcat, Jetty, Caucho Resin) must be running.\nIf it is necessary, please make a backup of the database.\nAre you ready to continue? [y/n]: ");
                BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
                String choiceString = input.readLine();
                if (choiceString.equalsIgnoreCase("y")) {
                    context.turnOffAuthorisationSystem();
                    try {
                        log.info("Updating handle prefix from " + oldH + " to " + newH);
                        System.out.print("\nUpdating handle table... ");
                        int updHdl = handleService.updateHandlesWithNewPrefix(context, newH, oldH);
                        System.out.println(updHdl + " item" + (updHdl > 1 ? "s" : "") + " updated");
                        System.out.print("Updating metadatavalues table... ");
                        MetadataValueService metadataValueService = ContentServiceFactory.getInstance().getMetadataValueService();
                        String handlePrefix = handleService.getCanonicalPrefix();
                        Iterator<MetadataValue> metadataValues = metadataValueService.findByValueLike(context, handlePrefix + oldH);
                        int updMeta = 0;
                        while (metadataValues.hasNext()) {
                            MetadataValue metadataValue = metadataValues.next();
                            metadataValue.setValue(metadataValue.getValue().replace(handlePrefix + oldH, handlePrefix + newH));
                            metadataValueService.update(context, metadataValue, true);
                            context.uncacheEntity(metadataValue);
                            ++updMeta;
                        }
                        System.out.println(updMeta + " metadata value" + (updMeta > 1 ? "s" : "") + " updated");
                        context.complete();
                        log.info("Done with updating handle prefix. It was changed " + updHdl + " handle" + (updHdl > 1 ? "s" : "") + " and " + updMeta + " metadata record" + (updMeta > 1 ? "s" : ""));
                    }
                    catch (SQLException sqle) {
                        if (context != null && context.isValid()) {
                            context.abort();
                            context = null;
                        }
                        System.out.println("\nError during SQL operations.");
                        throw sqle;
                    }
                    System.out.println("Handles successfully updated in database.\n");
                    System.out.println("Re-creating browse and search indexes...");
                    try {
                        IndexClient.main(new String[]{"-b"});
                        System.out.println("Browse and search indexes are ready now.");
                        System.out.println("\nAll done successfully. Please check the DSpace logs!\n");
                    }
                    catch (Exception e) {
                        System.out.println("Error during re-indexing.");
                        System.out.println("\n\nAutomatic re-indexing failed. Please perform it manually.\n\n  [dspace]/bin/dspace index-discovery -b\n\nWhen launching this command, your servlet container must be running.\n");
                        throw e;
                    }
                    context.restoreAuthSystemState();
                } else {
                    System.out.println("No changes have been made to your data.\n");
                }
            } else {
                System.out.println("Nothing to do! All handles are up-to-date.\n");
            }
        }
    }
}

