/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.pubmed.service;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.service.AbstractImportMetadataSourceService;
import org.jaxen.JaxenException;

public class PubmedImportMetadataSourceServiceImpl
extends AbstractImportMetadataSourceService<OMElement> {
    private String baseAddress;
    private WebTarget pubmedWebTarget;

    @Override
    public int getNbRecords(String query) throws MetadataSourceException {
        return this.retry(new GetNbRecords(query));
    }

    @Override
    public int getNbRecords(Query query) throws MetadataSourceException {
        return this.retry(new GetNbRecords(query));
    }

    @Override
    public Collection<ImportRecord> getRecords(String query, int start, int count) throws MetadataSourceException {
        return this.retry(new GetRecords(query, start, count));
    }

    @Override
    public Collection<ImportRecord> getRecords(Query query) throws MetadataSourceException {
        return this.retry(new GetRecords(query));
    }

    @Override
    public ImportRecord getRecord(String id) throws MetadataSourceException {
        return this.retry(new GetRecord(id));
    }

    @Override
    public ImportRecord getRecord(Query query) throws MetadataSourceException {
        return this.retry(new GetRecord(query));
    }

    @Override
    public String getImportSource() {
        return "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/";
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Item item) throws MetadataSourceException {
        return this.retry(new FindMatchingRecords(item));
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Query query) throws MetadataSourceException {
        return this.retry(new FindMatchingRecords(query));
    }

    @Override
    public void init() throws Exception {
        Client client = ClientBuilder.newClient();
        WebTarget webTarget = client.target(this.baseAddress);
        this.pubmedWebTarget = webTarget.queryParam("db", new Object[]{"pubmed"});
    }

    public String getBaseAddress() {
        return this.baseAddress;
    }

    public void setBaseAddress(String baseAddress) {
        this.baseAddress = baseAddress;
    }

    private String getSingleElementValue(String src, String elementName) {
        OMXMLParserWrapper records = OMXMLBuilderFactory.createOMBuilder((Reader)new StringReader(src));
        OMElement element = records.getDocumentElement();
        AXIOMXPath xpath = null;
        String value = null;
        try {
            xpath = new AXIOMXPath("//" + elementName);
            List recordsList = xpath.selectNodes((Object)element);
            if (!recordsList.isEmpty()) {
                value = ((OMElement)recordsList.get(0)).getText();
            }
        }
        catch (JaxenException e) {
            value = null;
        }
        return value;
    }

    private List<OMElement> splitToRecords(String recordsSrc) {
        OMXMLParserWrapper records = OMXMLBuilderFactory.createOMBuilder((Reader)new StringReader(recordsSrc));
        OMElement element = records.getDocumentElement();
        AXIOMXPath xpath = null;
        try {
            xpath = new AXIOMXPath("//PubmedArticle");
            List recordsList = xpath.selectNodes((Object)element);
            return recordsList;
        }
        catch (JaxenException e) {
            return null;
        }
    }

    private class FindMatchingRecords
    implements Callable<Collection<ImportRecord>> {
        private Query query;

        private FindMatchingRecords(Item item) throws MetadataSourceException {
            this.query = PubmedImportMetadataSourceServiceImpl.this.getGenerateQueryForItem().generateQueryForItem(item);
        }

        public FindMatchingRecords(Query q) {
            this.query = q;
        }

        @Override
        public Collection<ImportRecord> call() throws Exception {
            LinkedList<ImportRecord> records = new LinkedList<ImportRecord>();
            WebTarget getRecordIdsTarget = PubmedImportMetadataSourceServiceImpl.this.pubmedWebTarget.queryParam("term", new Object[]{this.query.getParameterAsClass("term", String.class)});
            getRecordIdsTarget = getRecordIdsTarget.queryParam("field", new Object[]{this.query.getParameterAsClass("field", String.class)});
            getRecordIdsTarget = getRecordIdsTarget.queryParam("usehistory", new Object[]{"y"});
            getRecordIdsTarget = getRecordIdsTarget.path("esearch.fcgi");
            Invocation.Builder invocationBuilder = getRecordIdsTarget.request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE});
            Response response = invocationBuilder.get();
            String responseString = (String)response.readEntity(String.class);
            String queryKey = PubmedImportMetadataSourceServiceImpl.this.getSingleElementValue(responseString, "QueryKey");
            String webEnv = PubmedImportMetadataSourceServiceImpl.this.getSingleElementValue(responseString, "WebEnv");
            WebTarget getRecordsTarget = PubmedImportMetadataSourceServiceImpl.this.pubmedWebTarget.queryParam("WebEnv", new Object[]{webEnv});
            getRecordsTarget = getRecordsTarget.queryParam("query_key", new Object[]{queryKey});
            getRecordsTarget = getRecordsTarget.queryParam("retmode", new Object[]{"xml"});
            getRecordsTarget = getRecordsTarget.path("efetch.fcgi");
            invocationBuilder = getRecordsTarget.request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE});
            response = invocationBuilder.get();
            List omElements = PubmedImportMetadataSourceServiceImpl.this.splitToRecords((String)response.readEntity(String.class));
            for (OMElement record : omElements) {
                records.add(PubmedImportMetadataSourceServiceImpl.this.transformSourceRecords(record));
            }
            return records;
        }
    }

    private class GetRecord
    implements Callable<ImportRecord> {
        private Query query;

        private GetRecord(String id) {
            this.query = new Query();
            this.query.addParameter("id", id);
        }

        public GetRecord(Query q) {
            this.query = q;
        }

        @Override
        public ImportRecord call() throws Exception {
            String id = this.query.getParameterAsClass("id", String.class);
            WebTarget getRecordTarget = PubmedImportMetadataSourceServiceImpl.this.pubmedWebTarget.queryParam("id", new Object[]{id});
            getRecordTarget = getRecordTarget.queryParam("retmode", new Object[]{"xml"});
            getRecordTarget = getRecordTarget.path("efetch.fcgi");
            Invocation.Builder invocationBuilder = getRecordTarget.request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE});
            Response response = invocationBuilder.get();
            List omElements = PubmedImportMetadataSourceServiceImpl.this.splitToRecords((String)response.readEntity(String.class));
            if (omElements.size() == 0) {
                return null;
            }
            return PubmedImportMetadataSourceServiceImpl.this.transformSourceRecords((OMElement)omElements.get(0));
        }
    }

    private class GetRecords
    implements Callable<Collection<ImportRecord>> {
        private Query query;

        private GetRecords(String queryString, int start, int count) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
            this.query.addParameter("start", start);
            this.query.addParameter("count", count);
        }

        private GetRecords(Query q) {
            this.query = q;
        }

        @Override
        public Collection<ImportRecord> call() throws Exception {
            String queryString = this.query.getParameterAsClass("query", String.class);
            Integer start = this.query.getParameterAsClass("start", Integer.class);
            Integer count = this.query.getParameterAsClass("count", Integer.class);
            if (count == null || count < 0) {
                count = 10;
            }
            if (start == null || start < 0) {
                start = 0;
            }
            LinkedList<ImportRecord> records = new LinkedList<ImportRecord>();
            WebTarget getRecordIdsTarget = PubmedImportMetadataSourceServiceImpl.this.pubmedWebTarget.queryParam("term", new Object[]{queryString});
            getRecordIdsTarget = getRecordIdsTarget.queryParam("retstart", new Object[]{start});
            getRecordIdsTarget = getRecordIdsTarget.queryParam("retmax", new Object[]{count});
            getRecordIdsTarget = getRecordIdsTarget.queryParam("usehistory", new Object[]{"y"});
            getRecordIdsTarget = getRecordIdsTarget.path("esearch.fcgi");
            Invocation.Builder invocationBuilder = getRecordIdsTarget.request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE});
            Response response = invocationBuilder.get();
            String responseString = (String)response.readEntity(String.class);
            String queryKey = PubmedImportMetadataSourceServiceImpl.this.getSingleElementValue(responseString, "QueryKey");
            String webEnv = PubmedImportMetadataSourceServiceImpl.this.getSingleElementValue(responseString, "WebEnv");
            WebTarget getRecordsTarget = PubmedImportMetadataSourceServiceImpl.this.pubmedWebTarget.queryParam("WebEnv", new Object[]{webEnv});
            getRecordsTarget = getRecordsTarget.queryParam("query_key", new Object[]{queryKey});
            getRecordsTarget = getRecordsTarget.queryParam("retmode", new Object[]{"xml"});
            getRecordsTarget = getRecordsTarget.path("efetch.fcgi");
            getRecordsTarget = getRecordsTarget.queryParam("retmax", new Object[]{count});
            getRecordsTarget = getRecordsTarget.queryParam("retstart", new Object[]{start});
            invocationBuilder = getRecordsTarget.request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE});
            response = invocationBuilder.get();
            List omElements = PubmedImportMetadataSourceServiceImpl.this.splitToRecords((String)response.readEntity(String.class));
            for (OMElement record : omElements) {
                records.add(PubmedImportMetadataSourceServiceImpl.this.transformSourceRecords(record));
            }
            return records;
        }
    }

    private class GetNbRecords
    implements Callable<Integer> {
        private Query query;

        private GetNbRecords(String queryString) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
        }

        public GetNbRecords(Query query) {
            this.query = query;
        }

        @Override
        public Integer call() throws Exception {
            WebTarget getRecordIdsTarget = PubmedImportMetadataSourceServiceImpl.this.pubmedWebTarget.queryParam("term", new Object[]{this.query.getParameterAsClass("query", String.class)});
            getRecordIdsTarget = getRecordIdsTarget.path("esearch.fcgi");
            Invocation.Builder invocationBuilder = getRecordIdsTarget.request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE});
            Response response = invocationBuilder.get();
            String responseString = (String)response.readEntity(String.class);
            String count = PubmedImportMetadataSourceServiceImpl.this.getSingleElementValue(responseString, "Count");
            return Integer.parseInt(count);
        }
    }
}

