/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Dataset {
    private int nbRows;
    private int nbCols;
    private List<String> colLabels;
    private List<String> rowLabels;
    private String colTitle;
    private String rowTitle;
    private List<Map<String, String>> colLabelsAttrs;
    private List<Map<String, String>> rowLabelsAttrs;
    private String[][] matrix;
    private String format = "0";

    public Dataset(int rows, int cols) {
        this.matrix = new String[rows][cols];
        this.nbRows = rows;
        this.nbCols = cols;
        this.initColumnLabels(cols);
        this.initRowLabels(rows);
    }

    public Dataset(String[][] matrix) {
        this.matrix = (String[][])ArrayUtils.clone((Object[])matrix);
        this.nbRows = matrix.length;
        if (0 < matrix.length && 0 < matrix[0].length) {
            this.nbCols = matrix[0].length;
        }
        this.initColumnLabels(this.nbCols);
        this.initRowLabels(this.nbRows);
    }

    private void initRowLabels(int rows) {
        this.rowLabels = new ArrayList<String>(rows);
        this.rowLabelsAttrs = new ArrayList<Map<String, String>>();
        for (int i = 0; i < rows; ++i) {
            this.rowLabels.add("Row " + (i + 1));
            this.rowLabelsAttrs.add(new HashMap());
        }
    }

    private void initColumnLabels(int nbCols) {
        this.colLabels = new ArrayList<String>(nbCols);
        this.colLabelsAttrs = new ArrayList<Map<String, String>>();
        for (int i = 0; i < nbCols; ++i) {
            this.colLabels.add("Column " + (i + 1));
            this.colLabelsAttrs.add(new HashMap());
        }
    }

    public void setColLabel(int n, String label) {
        this.colLabels.set(n, label);
    }

    public void setRowLabel(int n, String label) {
        this.rowLabels.set(n, label);
    }

    public String getRowTitle() {
        return this.rowTitle;
    }

    public String getColTitle() {
        return this.colTitle;
    }

    public void setColTitle(String colTitle) {
        this.colTitle = colTitle;
    }

    public void setRowTitle(String rowTitle) {
        this.rowTitle = rowTitle;
    }

    public void setRowLabelAttr(int pos, String attrName, String attr) {
        Map<String, String> attrs = this.rowLabelsAttrs.get(pos);
        attrs.put(attrName, attr);
        this.rowLabelsAttrs.set(pos, attrs);
    }

    public void setRowLabelAttr(int pos, Map<String, String> attrMap) {
        this.rowLabelsAttrs.set(pos, attrMap);
    }

    public void setColLabelAttr(int pos, String attrName, String attr) {
        Map<String, String> attrs = this.colLabelsAttrs.get(pos);
        attrs.put(attrName, attr);
        this.colLabelsAttrs.set(pos, attrs);
    }

    public void setColLabelAttr(int pos, Map<String, String> attrMap) {
        this.colLabelsAttrs.set(pos, attrMap);
    }

    public List<Map<String, String>> getColLabelsAttrs() {
        return this.colLabelsAttrs;
    }

    public List<Map<String, String>> getRowLabelsAttrs() {
        return this.rowLabelsAttrs;
    }

    public List<String> getColLabels() {
        return this.colLabels;
    }

    public List<String> getRowLabels() {
        return this.rowLabels;
    }

    public int getNbRows() {
        return this.nbRows;
    }

    public int getNbCols() {
        return this.nbCols;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String[][] getMatrix() {
        if (this.matrix.length == 0) {
            return new String[0][0];
        }
        return this.matrix;
    }

    public void addValueToMatrix(int row, int coll, float value) {
        DecimalFormat decimalFormat = new DecimalFormat(this.format);
        this.matrix[row][coll] = decimalFormat.format(value);
    }

    public void addValueToMatrix(int row, int coll, String value) throws ParseException {
        this.matrix[row][coll] = value;
    }

    public boolean containsNonZeroValues() {
        if (this.matrix != null) {
            String[][] stringArray = this.matrix;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] vector;
                for (String v : vector = stringArray[i]) {
                    if (!StringUtils.isBlank((CharSequence)v) && !v.equals("0")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void flipRowCols() {
        Object backup;
        if (0 < this.matrix.length && 0 < this.matrix[0].length) {
            String[][] newMatrix = new String[this.matrix[0].length][this.matrix.length];
            for (int i = 0; i < this.matrix.length; ++i) {
                for (int j = 0; j < this.matrix[i].length; ++j) {
                    newMatrix[j][i] = this.matrix[i][j];
                }
            }
            backup = this.colLabels;
            this.colLabels = this.rowLabels;
            this.rowLabels = backup;
            List<Map<String, String>> backList = this.colLabelsAttrs;
            this.colLabelsAttrs = this.rowLabelsAttrs;
            this.rowLabelsAttrs = backList;
            this.matrix = newMatrix;
        }
        int backUp = this.nbRows;
        this.nbRows = this.nbCols;
        this.nbCols = backUp;
        backup = this.rowTitle;
        this.rowTitle = this.colTitle;
        this.colTitle = backup;
    }

    public ByteArrayOutputStream exportAsCSV() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CSVWriter ecsvp = new CSVWriter((Writer)new OutputStreamWriter(baos), ';');
        List<String> colLabels = this.getColLabels();
        colLabels.add(0, "");
        ecsvp.writeNext(colLabels.toArray(new String[colLabels.size()]));
        List<String> rowLabels = this.getRowLabels();
        String[][] matrix = this.getMatrix();
        for (int i = 0; i < rowLabels.size(); ++i) {
            String rowLabel = rowLabels.get(i);
            ecsvp.writeNext((String[])ArrayUtils.addAll((Object[])new String[]{rowLabel}, (Object[])matrix[i]));
        }
        ecsvp.flush();
        ecsvp.close();
        return baos;
    }
}

