/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.statistics.LogAnalyser;
import org.dspace.app.statistics.LogLine;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;

public class ClassicDSpaceLogConverter {
    private final Logger log = LogManager.getLogger(ClassicDSpaceLogConverter.class);
    private final Context context;
    private boolean verbose = false;
    private boolean newEvents = false;
    private final Pattern ipaddrPattern = Pattern.compile("ip_addr=(\\d*\\.\\d*\\.\\d*\\.\\d*):");
    private final SimpleDateFormat dateFormatIn = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final SimpleDateFormat dateFormatOut = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final SimpleDateFormat dateFormatInUID = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private final SimpleDateFormat dateFormatOutUID = new SimpleDateFormat("yyyyMMddHHmmssSSS");

    public ClassicDSpaceLogConverter(Context c, boolean v, boolean nE) {
        this.context = c;
        this.verbose = v;
        this.newEvents = nE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int convert(String in, String out) {
        BufferedWriter output;
        BufferedReader input;
        int counter = 0;
        int lines = 0;
        try {
            if (null == in || in.isEmpty() || "-".equals(in)) {
                input = new BufferedReader(new InputStreamReader(System.in));
                in = "standard input";
            } else {
                input = new BufferedReader(new FileReader(in));
            }
            if (null == out || out.isEmpty() || "-".equals(out)) {
                output = new BufferedWriter(new OutputStreamWriter(System.out));
                out = "standard output";
            } else {
                output = new BufferedWriter(new FileWriter(out));
            }
        }
        catch (IOException ie) {
            this.log.error("File access problem", (Throwable)ie);
            return 0;
        }
        System.err.println(" About to convert '" + in + "' to '" + out + "'");
        LogAnalyser.setRegex(in);
        try {
            String line;
            String lastLine = "";
            while ((line = input.readLine()) != null) {
                String lout;
                LogLine lline;
                ++lines;
                if (this.verbose) {
                    System.out.println("  - IN: " + line);
                }
                if ((lline = LogAnalyser.getLogLine(line)) == null || !lline.isLevel("INFO")) {
                    if (!this.verbose) continue;
                    System.out.println("   - IGNORED!");
                    continue;
                }
                Matcher matcher = this.ipaddrPattern.matcher(line);
                String ip = matcher.find() ? matcher.group(1) : "unknown";
                String date = this.dateFormatOut.format(this.dateFormatIn.parse(line.substring(0, line.indexOf(44)), new ParsePosition(0)));
                String uid = this.dateFormatOutUID.format(this.dateFormatInUID.parse(line.substring(0, line.indexOf(32, line.indexOf(32) + 1)), new ParsePosition(0)));
                try {
                    String id;
                    if (!(!lline.getAction().equals("view_bitstream") || lline.getParams().contains("invalid_bitstream_id") || lline.getParams().contains("withdrawn") || line.contains("org.dspace.usage.LoggerUsageEventListener") && !this.newEvents)) {
                        id = lline.getParams().substring(13);
                    } else if (lline.getAction().equals("view_item") && (!line.contains("org.dspace.usage.LoggerUsageEventListener") || this.newEvents)) {
                        String handle = lline.getParams().substring(7);
                        DSpaceObject dso = HandleServiceFactory.getInstance().getHandleService().resolveToObject(this.context, handle);
                        id = "" + dso.getID();
                    } else if (lline.getAction().equals("view_collection") && (!line.contains("org.dspace.usage.LoggerUsageEventListener") || this.newEvents)) {
                        id = lline.getParams().substring(14);
                    } else {
                        if (!lline.getAction().equals("view_community") || line.contains("org.dspace.usage.LoggerUsageEventListener") && !this.newEvents) continue;
                        id = lline.getParams().substring(13);
                    }
                    lout = uid + "," + lline.getAction() + "," + id + "," + date + "," + lline.getUser() + "," + ip + "\n";
                }
                catch (Exception e) {
                    if (this.verbose) {
                        System.out.println("  - IN: " + line);
                    }
                    if (!this.verbose) continue;
                    System.err.println("Error with log line! " + e.getMessage());
                    continue;
                }
                if (this.verbose && !"".equals(lout)) {
                    System.out.println("  - IN: " + line);
                    System.out.println("  - OUT: " + lout);
                }
                if ("".equals(lout) || lout.equals(lastLine)) continue;
                output.write(lout);
                ++counter;
                lastLine = lout;
            }
        }
        catch (IOException e) {
            this.log.error("File access problem", (Throwable)e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            try {
                ((Writer)output).flush();
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            try {
                ((Writer)output).close();
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        System.err.println("  Read " + lines + " lines and recorded " + counter + " events");
        return counter;
    }

    private static void printHelp(Options options, int exitCode) {
        HelpFormatter myhelp = new HelpFormatter();
        myhelp.printHelp("ClassicDSpaceLogConverter\n", options);
        System.err.println("\n\tClassicDSpaceLogConverter -i infilename -o outfilename -v (for verbose output)");
        System.exit(exitCode);
    }

    public static void main(String[] args) {
        CommandLine line;
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("i", "in", true, "source file ('-' or omit for standard input)");
        options.addOption("o", "out", true, "destination file or directory ('-' or omit for standard output)");
        options.addOption("m", "multiple", false, "treat the input file as having a wildcard ending");
        options.addOption("n", "newformat", false, "process new format log lines (1.6+)");
        options.addOption("v", "verbose", false, "display verbose output (useful for debugging)");
        options.addOption("h", "help", false, "help");
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException pe) {
            System.err.println("Error parsing command line arguments: " + pe.getMessage());
            System.exit(1);
            return;
        }
        if (line.hasOption('h')) {
            ClassicDSpaceLogConverter.printHelp(options, 0);
        }
        boolean newEvents = line.hasOption('n');
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        ClassicDSpaceLogConverter converter = new ClassicDSpaceLogConverter(context, line.hasOption('v'), newEvents);
        try {
            LogAnalyser.readConfig();
        }
        catch (IOException ioe) {
            System.err.println("Unable to read config file: " + LogAnalyser.getConfigFile());
            System.exit(1);
        }
        if (line.hasOption('m')) {
            FilenameFilter filter;
            final File sample = new File(line.getOptionValue('i'));
            File dir = sample.getAbsoluteFile().getParentFile();
            String[] children = dir.list(filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(sample.getName());
                }
            });
            if (null == children) {
                System.err.println(sample + " could not be used to find a directory of log files.");
                System.exit(1);
            } else if (children.length <= 0) {
                System.err.println(sample + " matched no files.");
            } else {
                for (String in : children) {
                    System.err.println(in);
                    String out = line.getOptionValue('o') + (dir.getAbsolutePath() + System.getProperty("file.separator") + in).substring(line.getOptionValue('i').length());
                    converter.convert(dir.getAbsolutePath() + System.getProperty("file.separator") + in, out);
                }
            }
        } else {
            converter.convert(line.getOptionValue('i'), line.getOptionValue('o'));
        }
        context.restoreAuthSystemState();
        context.abort();
    }
}

