/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.StringValue;
import gr.ekt.bte.core.Value;
import java.util.LinkedList;
import java.util.List;
import org.dspace.app.util.XMLUtils;
import org.dspace.submit.util.SubmissionLookupPublication;
import org.w3c.dom.Element;

public class ArxivUtils {
    private ArxivUtils() {
    }

    public static Record convertArxixDomToRecord(Element dataRoot) {
        LinkedList<StringValue> values;
        String journalRef;
        String doi;
        List<Element> links;
        String comment;
        String splashPageUrl;
        String year;
        String summary;
        SubmissionLookupPublication record = new SubmissionLookupPublication("");
        String articleTitle = XMLUtils.getElementValue(dataRoot, "title");
        if (articleTitle != null) {
            record.addValue("title", (Value)new StringValue(articleTitle));
        }
        if ((summary = XMLUtils.getElementValue(dataRoot, "summary")) != null) {
            record.addValue("summary", (Value)new StringValue(summary));
        }
        if ((year = XMLUtils.getElementValue(dataRoot, "published")) != null) {
            record.addValue("published", (Value)new StringValue(year));
        }
        if ((splashPageUrl = XMLUtils.getElementValue(dataRoot, "id")) != null) {
            record.addValue("id", (Value)new StringValue(splashPageUrl));
        }
        if ((comment = XMLUtils.getElementValue(dataRoot, "arxiv:comment")) != null) {
            record.addValue("comment", (Value)new StringValue(comment));
        }
        if ((links = XMLUtils.getElementList(dataRoot, "link")) != null) {
            for (Element link : links) {
                String pdfUrl;
                if (!"related".equals(link.getAttribute("rel")) || !"pdf".equals(link.getAttribute("title")) || (pdfUrl = link.getAttribute("href")) == null) continue;
                record.addValue("pdfUrl", (Value)new StringValue(pdfUrl));
            }
        }
        if ((doi = XMLUtils.getElementValue(dataRoot, "arxiv:doi")) != null) {
            record.addValue("doi", (Value)new StringValue(doi));
        }
        if ((journalRef = XMLUtils.getElementValue(dataRoot, "arxiv:journal_ref")) != null) {
            record.addValue("journalRef", (Value)new StringValue(journalRef));
        }
        LinkedList<String> primaryCategory = new LinkedList<String>();
        List<Element> primaryCategoryList = XMLUtils.getElementList(dataRoot, "arxiv:primary_category");
        if (primaryCategoryList != null) {
            for (Element element : primaryCategoryList) {
                primaryCategory.add(element.getAttribute("term"));
            }
        }
        if (primaryCategory.size() > 0) {
            LinkedList<StringValue> values2 = new LinkedList<StringValue>();
            for (String string : primaryCategory) {
                values2.add(new StringValue(string));
            }
            record.addField("primaryCategory", values2);
        }
        LinkedList<String> category = new LinkedList<String>();
        List<Element> list = XMLUtils.getElementList(dataRoot, "category");
        if (list != null) {
            for (Element element : list) {
                category.add(element.getAttribute("term"));
            }
        }
        if (category.size() > 0) {
            LinkedList<StringValue> linkedList = new LinkedList<StringValue>();
            for (String s : category) {
                linkedList.add(new StringValue(s));
            }
            record.addField("category", linkedList);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        List<Element> authorList = XMLUtils.getElementList(dataRoot, "author");
        if (authorList != null) {
            for (Element authorElement : authorList) {
                String authorName = XMLUtils.getElementValue(authorElement, "name");
                String authorAffiliation = XMLUtils.getElementValue(authorElement, "arxiv:affiliation");
                linkedList.add(authorName);
                linkedList2.add(authorName + ": " + authorAffiliation);
            }
        }
        if (linkedList.size() > 0) {
            values = new LinkedList<StringValue>();
            for (String sArray : linkedList) {
                values.add(new StringValue(sArray));
            }
            record.addField("author", values);
        }
        if (linkedList2.size() > 0) {
            values = new LinkedList();
            for (String sArray : linkedList2) {
                values.add(new StringValue(sArray));
            }
            record.addField("authorWithAffiliation", values);
        }
        return record;
    }
}

