/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflowbasic;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.workflowbasic.BasicWorkflowItem;
import org.dspace.workflowbasic.dao.BasicWorkflowItemDAO;
import org.dspace.workflowbasic.service.BasicWorkflowItemService;
import org.dspace.workflowbasic.service.TaskListItemService;
import org.springframework.beans.factory.annotation.Autowired;

public class BasicWorkflowItemServiceImpl
implements BasicWorkflowItemService {
    protected static Logger log = org.apache.logging.log4j.LogManager.getLogger(BasicWorkflowItem.class);
    @Autowired(required=true)
    protected BasicWorkflowItemDAO workflowItemDAO;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected TaskListItemService taskListItemService;

    protected BasicWorkflowItemServiceImpl() {
    }

    @Override
    public int getSupportsIndexableObjectTypeConstant() {
        return 9;
    }

    @Override
    public BasicWorkflowItem create(Context context, Item item, Collection collection) throws SQLException, AuthorizeException {
        if (this.findByItem(context, item) != null) {
            throw new IllegalArgumentException("Unable to create a workflow item for an item that already has a workflow item.");
        }
        BasicWorkflowItem workflowItem = this.workflowItemDAO.create(context, new BasicWorkflowItem());
        workflowItem.setItem(item);
        workflowItem.setCollection(collection);
        this.update(context, workflowItem);
        return workflowItem;
    }

    @Override
    public BasicWorkflowItem find(Context context, int id) throws SQLException {
        BasicWorkflowItem workflowItem = (BasicWorkflowItem)this.workflowItemDAO.findByID(context, BasicWorkflowItem.class, id);
        if (workflowItem == null) {
            if (log.isDebugEnabled()) {
                log.debug(LogManager.getHeader(context, "find_workflow_item", "not_found,workflow_id=" + id));
            }
        } else if (log.isDebugEnabled()) {
            log.debug(LogManager.getHeader(context, "find_workflow_item", "workflow_id=" + id));
        }
        return workflowItem;
    }

    @Override
    public BasicWorkflowItem findIndexableObject(Context context, Integer id) throws SQLException {
        if (id != null) {
            return this.find(context, id);
        }
        return null;
    }

    @Override
    public List<BasicWorkflowItem> findAll(Context context) throws SQLException {
        return this.workflowItemDAO.findAll(context, BasicWorkflowItem.class);
    }

    @Override
    public List<BasicWorkflowItem> findBySubmitter(Context context, EPerson ep) throws SQLException {
        return this.workflowItemDAO.findBySubmitter(context, ep);
    }

    @Override
    public void deleteByCollection(Context context, Collection collection) throws SQLException, IOException, AuthorizeException {
        List<BasicWorkflowItem> workflowItems = this.findByCollection(context, collection);
        Iterator<BasicWorkflowItem> iterator = workflowItems.iterator();
        while (iterator.hasNext()) {
            BasicWorkflowItem workflowItem = iterator.next();
            iterator.remove();
            this.delete(context, workflowItem);
        }
    }

    @Override
    public void delete(Context context, BasicWorkflowItem workflowItem) throws SQLException, AuthorizeException, IOException {
        Item item = workflowItem.getItem();
        this.deleteWrapper(context, workflowItem);
        this.itemService.delete(context, item);
    }

    @Override
    public List<BasicWorkflowItem> findByCollection(Context context, Collection collection) throws SQLException {
        return this.workflowItemDAO.findByCollection(context, collection);
    }

    @Override
    public BasicWorkflowItem findByItem(Context context, Item item) throws SQLException {
        return this.workflowItemDAO.findByItem(context, item);
    }

    @Override
    public void deleteWrapper(Context context, BasicWorkflowItem workflowItem) throws SQLException, AuthorizeException {
        this.taskListItemService.deleteByWorkflowItem(context, workflowItem);
        this.workflowItemDAO.delete(context, workflowItem);
    }

    @Override
    public void update(Context context, BasicWorkflowItem workflowItem) throws SQLException, AuthorizeException {
        log.info(LogManager.getHeader(context, "update_workflow_item", "workflow_item_id=" + workflowItem.getID()));
        this.itemService.update(context, workflowItem.getItem());
        this.workflowItemDAO.save(context, workflowItem);
    }

    @Override
    public List<BasicWorkflowItem> findPooledTasks(Context context, EPerson ePerson) throws SQLException {
        return this.workflowItemDAO.findByPooledTasks(context, ePerson);
    }

    @Override
    public List<BasicWorkflowItem> findByOwner(Context context, EPerson ePerson) throws SQLException {
        return this.workflowItemDAO.findByOwner(context, ePerson);
    }

    @Override
    public int countTotal(Context context) throws SQLException {
        return this.workflowItemDAO.countRows(context);
    }

    @Override
    public void move(Context context, BasicWorkflowItem inProgressSubmission, Collection fromCollection, Collection toCollection) {
    }
}

