/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.dspace.content.Collection;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.xmlworkflow.Role;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.state.actions.UserSelectionActionConfig;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlWorkflowFactoryImpl
implements XmlWorkflowFactory {
    private Logger log = LogManager.getLogger(XmlWorkflowFactoryImpl.class);
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    protected HashMap<String, Workflow> workflowCache;
    protected String path;

    @PostConstruct
    protected void init() {
        this.path = this.configurationService.getProperty("dspace.dir") + File.separator + "config" + File.separator + "workflow.xml";
    }

    protected XmlWorkflowFactoryImpl() {
    }

    @Override
    public Workflow getWorkflow(Collection collection) throws IOException, WorkflowConfigurationException {
        if (this.workflowCache == null) {
            this.workflowCache = new HashMap();
        }
        if (this.workflowCache.get(collection.getHandle()) == null) {
            try {
                File xmlFile = new File(this.path);
                Document input = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xmlFile);
                Node mainNode = input.getFirstChild();
                Node workflowMap = XPathAPI.selectSingleNode((Node)mainNode, (String)("//workflow-map/name-map[@collection='" + collection.getHandle() + "']"));
                if (workflowMap == null) {
                    if (this.workflowCache.get("default") == null) {
                        String workflowID = XPathAPI.selectSingleNode((Node)mainNode, (String)"//workflow-map/name-map[@collection='default']").getAttributes().getNamedItem("workflow").getTextContent();
                        if (workflowID == null) {
                            throw new WorkflowConfigurationException("No mapping is present for collection with handle:" + collection.getHandle());
                        }
                        Node workflowNode = XPathAPI.selectSingleNode((Node)mainNode, (String)("//workflow[@id='" + workflowID + "']"));
                        Workflow wf = new Workflow(workflowID, this.getRoles(workflowNode));
                        Step step = this.createFirstStep(wf, workflowNode);
                        wf.setFirstStep(step);
                        this.workflowCache.put("default", wf);
                        this.workflowCache.put(collection.getHandle(), wf);
                        return wf;
                    }
                    return this.workflowCache.get("default");
                }
                String workflowID = workflowMap.getAttributes().getNamedItem("workflow").getTextContent();
                Node workflowNode = XPathAPI.selectSingleNode((Node)mainNode, (String)("//workflow[@id='" + workflowID + "']"));
                Workflow wf = new Workflow(workflowID, this.getRoles(workflowNode));
                Step step = this.createFirstStep(wf, workflowNode);
                wf.setFirstStep(step);
                this.workflowCache.put(collection.getHandle(), wf);
                return wf;
            }
            catch (Exception e) {
                this.log.error("Error while retrieving workflow for collection: " + collection.getHandle(), (Throwable)e);
                throw new WorkflowConfigurationException("Error while retrieving workflow for the following collection: " + collection.getHandle());
            }
        }
        return this.workflowCache.get(collection.getHandle());
    }

    protected Step createFirstStep(Workflow workflow, Node workflowNode) throws TransformerException, WorkflowConfigurationException {
        String firstStepID = workflowNode.getAttributes().getNamedItem("start").getTextContent();
        Node stepNode = XPathAPI.selectSingleNode((Node)workflowNode, (String)("step[@id='" + firstStepID + "']"));
        if (stepNode == null) {
            throw new WorkflowConfigurationException("First step does not exist for workflow: " + workflowNode.getAttributes().getNamedItem("id").getTextContent());
        }
        Node roleNode = stepNode.getAttributes().getNamedItem("role");
        Role role = null;
        if (roleNode != null) {
            role = workflow.getRoles().get(roleNode.getTextContent());
        }
        String userSelectionActionID = stepNode.getAttributes().getNamedItem("userSelectionMethod").getTextContent();
        UserSelectionActionConfig userSelection = this.createUserAssignmentActionConfig(userSelectionActionID);
        return new Step(firstStepID, workflow, role, userSelection, XmlWorkflowFactoryImpl.getStepActionConfigs(stepNode), this.getStepOutcomes(stepNode), this.getNbRequiredUser(stepNode));
    }

    protected Map<Integer, String> getStepOutcomes(Node stepNode) throws TransformerException, WorkflowConfigurationException {
        try {
            NodeList outcomesNodeList = XPathAPI.selectNodeList((Node)stepNode, (String)"outcomes/step");
            HashMap<Integer, String> outcomes = new HashMap<Integer, String>();
            for (int i = 0; i < outcomesNodeList.getLength(); ++i) {
                Node outcomeNode = outcomesNodeList.item(i);
                int index = Integer.parseInt(outcomeNode.getAttributes().getNamedItem("status").getTextContent());
                if (index < 0) {
                    throw new WorkflowConfigurationException("Outcome configuration error for step: " + stepNode.getAttributes().getNamedItem("id").getTextContent());
                }
                outcomes.put(index, outcomeNode.getTextContent());
            }
            return outcomes;
        }
        catch (Exception e) {
            this.log.error("Outcome configuration error for step: " + stepNode.getAttributes().getNamedItem("id").getTextContent(), (Throwable)e);
            throw new WorkflowConfigurationException("Outcome configuration error for step: " + stepNode.getAttributes().getNamedItem("id").getTextContent());
        }
    }

    protected int getNbRequiredUser(Node stepnode) {
        if (stepnode.getAttributes().getNamedItem("requiredUsers") != null) {
            return Integer.parseInt(stepnode.getAttributes().getNamedItem("requiredUsers").getTextContent());
        }
        return 1;
    }

    private static List<String> getStepActionConfigs(Node stepNode) throws TransformerException {
        NodeList actionConfigNodes = XPathAPI.selectNodeList((Node)stepNode, (String)"actions/action");
        ArrayList<String> actionConfigIDs = new ArrayList<String>();
        for (int i = 0; i < actionConfigNodes.getLength(); ++i) {
            actionConfigIDs.add(actionConfigNodes.item(i).getAttributes().getNamedItem("id").getTextContent());
        }
        return actionConfigIDs;
    }

    @Override
    public Step createStep(Workflow workflow, String stepID) throws WorkflowConfigurationException, IOException {
        try {
            File xmlFile = new File(this.path);
            Document input = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xmlFile);
            Node mainNode = input.getFirstChild();
            Node stepNode = XPathAPI.selectSingleNode((Node)mainNode, (String)("//workflow[@id='" + workflow.getID() + "']/step[@id='" + stepID + "']"));
            if (stepNode == null) {
                throw new WorkflowConfigurationException("Step does not exist for workflow: " + workflow.getID());
            }
            Node roleNode = stepNode.getAttributes().getNamedItem("role");
            Role role = null;
            if (roleNode != null) {
                role = workflow.getRoles().get(roleNode.getTextContent());
            }
            String userSelectionActionID = stepNode.getAttributes().getNamedItem("userSelectionMethod").getTextContent();
            UserSelectionActionConfig userSelection = this.createUserAssignmentActionConfig(userSelectionActionID);
            return new Step(stepID, workflow, role, userSelection, XmlWorkflowFactoryImpl.getStepActionConfigs(stepNode), this.getStepOutcomes(stepNode), this.getNbRequiredUser(stepNode));
        }
        catch (Exception e) {
            this.log.error("Error while creating step with :" + stepID, (Throwable)e);
            throw new WorkflowConfigurationException("Step: " + stepID + " does not exist for workflow: " + workflow.getID());
        }
    }

    protected UserSelectionActionConfig createUserAssignmentActionConfig(String userSelectionActionID) {
        return (UserSelectionActionConfig)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(userSelectionActionID, UserSelectionActionConfig.class);
    }

    @Override
    public WorkflowActionConfig createWorkflowActionConfig(String actionID) {
        return (WorkflowActionConfig)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(actionID, WorkflowActionConfig.class);
    }

    protected LinkedHashMap<String, Role> getRoles(Node workflowNode) throws WorkflowConfigurationException {
        NodeList roleNodes = null;
        try {
            roleNodes = XPathAPI.selectNodeList((Node)workflowNode, (String)"roles/role");
        }
        catch (Exception e) {
            this.log.error("Error while resolving nodes", (Throwable)e);
            throw new WorkflowConfigurationException("Error while retrieving roles");
        }
        LinkedHashMap<String, Role> roles = new LinkedHashMap<String, Role>();
        for (int i = 0; i < roleNodes.getLength(); ++i) {
            Role.Scope scope;
            String roleID = roleNodes.item(i).getAttributes().getNamedItem("id").getTextContent();
            String roleName = roleNodes.item(i).getAttributes().getNamedItem("name").getTextContent();
            Node descriptionNode = roleNodes.item(i).getAttributes().getNamedItem("description");
            String roleDescription = null;
            if (descriptionNode != null) {
                roleDescription = descriptionNode.getTextContent();
            }
            Node scopeNode = roleNodes.item(i).getAttributes().getNamedItem("scope");
            String roleScope = null;
            if (scopeNode != null) {
                roleScope = scopeNode.getTextContent();
            }
            Node internalNode = roleNodes.item(i).getAttributes().getNamedItem("internal");
            boolean internal = false;
            if (internalNode != null) {
                String roleInternal = internalNode.getTextContent();
                internal = Boolean.parseBoolean(roleInternal);
            }
            if (roleScope == null || roleScope.equalsIgnoreCase("collection")) {
                scope = Role.Scope.COLLECTION;
            } else if (roleScope.equalsIgnoreCase("item")) {
                scope = Role.Scope.ITEM;
            } else if (roleScope.equalsIgnoreCase("repository")) {
                scope = Role.Scope.REPOSITORY;
            } else {
                throw new WorkflowConfigurationException("An invalid role scope has been specified it must either be item or collection.");
            }
            Role role = new Role(roleID, roleName, roleDescription, internal, scope);
            roles.put(roleID, role);
        }
        return roles;
    }
}

