/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.jdbc;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.easybatch.core.mapper.BeanIntrospectionException;
import org.easybatch.jdbc.PreparedStatementProvider;

public class BeanPropertiesPreparedStatementProvider
implements PreparedStatementProvider {
    private String[] properties;
    private PropertyDescriptor[] propertyDescriptors;

    public BeanPropertiesPreparedStatementProvider(Class<?> type, String ... properties) throws BeanIntrospectionException {
        this.properties = properties;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            this.propertyDescriptors = beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new BeanIntrospectionException("Unable to introspect type " + type, (Throwable)e);
        }
    }

    @Override
    public void prepareStatement(PreparedStatement preparedStatement, Object record) throws SQLException {
        int index = 1;
        block2: for (String property : this.properties) {
            try {
                for (PropertyDescriptor propertyDescriptor : this.propertyDescriptors) {
                    if (!propertyDescriptor.getName().equals(property)) continue;
                    Object value = propertyDescriptor.getReadMethod().invoke(record, new Object[0]);
                    preparedStatement.setObject(index++, value);
                    continue block2;
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new BeanIntrospectionException(String.format("Unable to get property %s from type %s", property, record.getClass().getName()), (Throwable)e);
            }
        }
    }
}

