/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.easybatch.core.reader.RecordReader;
import org.easybatch.core.record.Header;
import org.easybatch.core.util.Utils;
import org.easybatch.jdbc.JdbcRecord;

public class JdbcRecordReader
implements RecordReader {
    private static final Logger LOGGER = Logger.getLogger(JdbcRecordReader.class.getSimpleName());
    private DataSource dataSource;
    private Connection connection;
    private Statement statement;
    private ResultSet resultSet;
    private String query;
    private String dataSourceName;
    private long currentRecordNumber;
    private int maxRows;
    private int queryTimeout;
    private int fetchSize;

    public JdbcRecordReader(DataSource dataSource, String query) {
        Utils.checkNotNull((Object)dataSource, (String)"data source");
        Utils.checkNotNull((Object)query, (String)"query");
        this.dataSource = dataSource;
        this.query = query;
    }

    public void open() throws Exception {
        this.currentRecordNumber = 0L;
        this.connection = this.dataSource.getConnection();
        this.statement = this.connection.createStatement(1003, 1007);
        if (this.maxRows >= 1) {
            this.statement.setMaxRows(this.maxRows);
        }
        if (this.fetchSize >= 1) {
            this.statement.setFetchSize(this.fetchSize);
        }
        if (this.queryTimeout >= 1) {
            this.statement.setQueryTimeout(this.queryTimeout);
        }
        this.resultSet = this.statement.executeQuery(this.query);
        this.dataSourceName = this.getDataSourceName();
    }

    private boolean hasNextRecord() {
        try {
            return this.resultSet.next();
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "An exception occurred during checking the existence of next database record", e);
            return false;
        }
    }

    public JdbcRecord readRecord() {
        if (this.hasNextRecord()) {
            Header header = new Header(Long.valueOf(++this.currentRecordNumber), this.dataSourceName, new Date());
            return new JdbcRecord(header, this.resultSet);
        }
        return null;
    }

    private String getDataSourceName() {
        try {
            return "Connection URL: " + this.connection.getMetaData().getURL() + " | Query string: " + this.query;
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "Unable to get data source name", e);
            return "N/A";
        }
    }

    public void close() throws Exception {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        if (this.statement != null) {
            this.statement.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public void setMaxRows(int maxRows) {
        Utils.checkArgument((maxRows >= 1 ? 1 : 0) != 0, (String)"max rows parameter must be greater than or equal to 1");
        this.maxRows = maxRows;
    }

    public void setFetchSize(int fetchSize) {
        Utils.checkArgument((fetchSize >= 1 ? 1 : 0) != 0, (String)"fetch size parameter must be greater than or equal to 1");
        this.fetchSize = fetchSize;
    }

    public void setQueryTimeout(int queryTimeout) {
        Utils.checkArgument((queryTimeout >= 1 ? 1 : 0) != 0, (String)"query timeout parameter must be greater than or equal to 1");
        this.queryTimeout = queryTimeout;
    }
}

