/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.easybatch.core.record.Batch;
import org.easybatch.core.record.Record;
import org.easybatch.core.util.Utils;
import org.easybatch.core.writer.RecordWriter;
import org.easybatch.jdbc.PreparedStatementProvider;

public class JdbcRecordWriter
implements RecordWriter {
    private static final Logger LOGGER = Logger.getLogger(JdbcRecordWriter.class.getSimpleName());
    private DataSource dataSource;
    private Connection connection;
    private String query;
    private PreparedStatementProvider preparedStatementProvider;

    public JdbcRecordWriter(DataSource dataSource, String query, PreparedStatementProvider preparedStatementProvider) {
        Utils.checkNotNull((Object)dataSource, (String)"data source");
        Utils.checkNotNull((Object)query, (String)"query");
        Utils.checkNotNull((Object)preparedStatementProvider, (String)"prepared statement");
        this.dataSource = dataSource;
        this.query = query;
        this.preparedStatementProvider = preparedStatementProvider;
    }

    public void open() throws Exception {
        this.connection = this.dataSource.getConnection();
        this.connection.setAutoCommit(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRecords(Batch batch) throws Exception {
        try (PreparedStatement preparedStatement = null;){
            preparedStatement = this.connection.prepareStatement(this.query);
            for (Record record : batch) {
                this.preparedStatementProvider.prepareStatement(preparedStatement, record.getPayload());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            this.connection.commit();
            LOGGER.info("Transaction committed");
        }
    }

    public void close() throws Exception {
        if (this.connection != null) {
            LOGGER.info("Closing connection");
            this.connection.close();
        }
    }
}

