/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpEventListener;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.security.Authentication;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeaderValues;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersions;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.View;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Timeout;

public abstract class AbstractHttpConnection
extends AbstractConnection
implements Dumpable {
    private static final Logger LOG = Log.getLogger(AbstractHttpConnection.class);
    protected HttpDestination _destination;
    protected HttpGenerator _generator;
    protected HttpParser _parser;
    protected boolean _http11 = true;
    protected int _status;
    protected Buffer _connectionHeader;
    protected boolean _reserved;
    protected volatile HttpExchange _exchange;
    protected HttpExchange _pipeline;
    private final Timeout.Task _idleTimeout = new ConnectionIdleTask();
    private AtomicBoolean _idle = new AtomicBoolean(false);

    AbstractHttpConnection(Buffers requestBuffers, Buffers responseBuffers, EndPoint endp) {
        super(endp);
        this._generator = new HttpGenerator(requestBuffers, endp);
        this._parser = new HttpParser(responseBuffers, endp, (HttpParser.EventHandler)new Handler());
    }

    public void setReserved(boolean reserved) {
        this._reserved = reserved;
    }

    public boolean isReserved() {
        return this._reserved;
    }

    public HttpDestination getDestination() {
        return this._destination;
    }

    public void setDestination(HttpDestination destination) {
        this._destination = destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(HttpExchange ex) throws IOException {
        LOG.debug("Send {} on {}", new Object[]{ex, this});
        AbstractHttpConnection abstractHttpConnection = this;
        synchronized (abstractHttpConnection) {
            if (this._exchange != null) {
                if (this._pipeline != null) {
                    throw new IllegalStateException((Object)((Object)this) + " PIPELINED!!!  _exchange=" + this._exchange);
                }
                this._pipeline = ex;
                return true;
            }
            this._exchange = ex;
            this._exchange.associate(this);
            if (!this._endp.isOpen()) {
                this._exchange.disassociate();
                this._exchange = null;
                return false;
            }
            this._exchange.setStatus(2);
            this.adjustIdleTimeout();
            return true;
        }
    }

    private void adjustIdleTimeout() throws IOException {
        long timeout = this._exchange.getTimeout();
        if (timeout <= 0L) {
            timeout = this._destination.getHttpClient().getTimeout();
        }
        long endPointTimeout = this._endp.getMaxIdleTime();
        if (timeout > 0L && timeout > endPointTimeout) {
            this._endp.setMaxIdleTime(2 * (int)timeout);
        }
    }

    public abstract Connection handle() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        AbstractHttpConnection abstractHttpConnection = this;
        synchronized (abstractHttpConnection) {
            return this._exchange == null;
        }
    }

    public boolean isSuspended() {
        return false;
    }

    public void onClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitRequest() throws IOException {
        AbstractHttpConnection abstractHttpConnection = this;
        synchronized (abstractHttpConnection) {
            Buffer requestContent;
            this._status = 0;
            if (this._exchange.getStatus() != 2) {
                throw new IllegalStateException();
            }
            this._exchange.setStatus(3);
            this._generator.setVersion(this._exchange.getVersion());
            String method = this._exchange.getMethod();
            String uri = this._exchange.getRequestURI();
            if (this._destination.isProxied()) {
                Authentication auth;
                if (!"CONNECT".equals(method) && uri.startsWith("/")) {
                    boolean secure = this._destination.isSecure();
                    String host = this._destination.getAddress().getHost();
                    int port = this._destination.getAddress().getPort();
                    StringBuilder absoluteURI = new StringBuilder();
                    absoluteURI.append(secure ? "https" : "http");
                    absoluteURI.append("://");
                    absoluteURI.append(host);
                    if (!(secure && port == 443 || !secure && port == 80)) {
                        absoluteURI.append(":").append(port);
                    }
                    absoluteURI.append(uri);
                    uri = absoluteURI.toString();
                }
                if ((auth = this._destination.getProxyAuthentication()) != null) {
                    auth.setCredentials(this._exchange);
                }
            }
            this._generator.setRequest(method, uri);
            this._parser.setHeadResponse("HEAD".equalsIgnoreCase(method));
            HttpFields requestHeaders = this._exchange.getRequestFields();
            if (this._exchange.getVersion() >= 11 && !requestHeaders.containsKey(HttpHeaders.HOST_BUFFER)) {
                requestHeaders.add(HttpHeaders.HOST_BUFFER, this._destination.getHostHeader());
            }
            if ((requestContent = this._exchange.getRequestContent()) != null) {
                requestHeaders.putLongField("Content-Length", (long)requestContent.length());
                this._generator.completeHeader(requestHeaders, false);
                this._generator.addContent((Buffer)new View(requestContent), true);
                this._exchange.setStatus(4);
            } else {
                InputStream requestContentStream = this._exchange.getRequestContentSource();
                if (requestContentStream != null) {
                    this._generator.completeHeader(requestHeaders, false);
                } else {
                    requestHeaders.remove("Content-Length");
                    this._generator.completeHeader(requestHeaders, true);
                    this._exchange.setStatus(4);
                }
            }
        }
    }

    protected void reset() throws IOException {
        this._connectionHeader = null;
        this._parser.reset();
        this._generator.reset();
        this._http11 = true;
    }

    public String toString() {
        return String.format("%s %s g=%s p=%s", super.toString(), this._destination == null ? "?.?.?.?:??" : this._destination.getAddress(), this._generator, this._parser);
    }

    public String toDetailString() {
        return this.toString() + " ex=" + this._exchange + " idle for " + this._idleTimeout.getAge();
    }

    public void close() throws IOException {
        HttpExchange exchange = this._exchange;
        if (exchange != null && !exchange.isDone()) {
            switch (exchange.getStatus()) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 6: {
                    if (this._endp.isInputShutdown() && this._parser.isState(1)) break;
                }
                default: {
                    String reason;
                    String exch = exchange.toString();
                    String string = this._endp.isOpen() ? (this._endp.isInputShutdown() ? "half closed: " : "local close: ") : (reason = "closed: ");
                    if (!exchange.setStatus(9)) break;
                    exchange.getEventListener().onException((Throwable)new EofException(reason + exch));
                }
            }
        }
        if (this._endp.isOpen()) {
            this._endp.close();
            this._destination.returnConnection(this, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdleTimeout() {
        AbstractHttpConnection abstractHttpConnection = this;
        synchronized (abstractHttpConnection) {
            if (!this._idle.compareAndSet(false, true)) {
                throw new IllegalStateException();
            }
            this._destination.getHttpClient().scheduleIdle(this._idleTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelIdleTimeout() {
        AbstractHttpConnection abstractHttpConnection = this;
        synchronized (abstractHttpConnection) {
            if (this._idle.compareAndSet(true, false)) {
                this._destination.getHttpClient().cancel(this._idleTimeout);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exchangeExpired(HttpExchange exchange) {
        AbstractHttpConnection abstractHttpConnection = this;
        synchronized (abstractHttpConnection) {
            if (this._exchange == exchange) {
                try {
                    this._destination.returnConnection(this, true);
                }
                catch (IOException x) {
                    LOG.ignore((Throwable)x);
                }
            }
        }
    }

    public String dump() {
        return AggregateLifeCycle.dump((Dumpable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Appendable out, String indent) throws IOException {
        AbstractHttpConnection abstractHttpConnection = this;
        synchronized (abstractHttpConnection) {
            out.append(String.valueOf((Object)this)).append("\n");
            AggregateLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Collections.singletonList(this._endp)});
        }
    }

    private class NonFinalResponseListener
    implements HttpEventListener {
        final HttpExchange _exchange;
        final HttpEventListener _next;

        public NonFinalResponseListener(HttpExchange exchange) {
            this._exchange = exchange;
            this._next = exchange.getEventListener();
        }

        @Override
        public void onRequestCommitted() throws IOException {
        }

        @Override
        public void onRequestComplete() throws IOException {
        }

        @Override
        public void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
        }

        @Override
        public void onResponseHeader(Buffer name, Buffer value) throws IOException {
            this._next.onResponseHeader(name, value);
        }

        @Override
        public void onResponseHeaderComplete() throws IOException {
            this._next.onResponseHeaderComplete();
        }

        @Override
        public void onResponseContent(Buffer content) throws IOException {
        }

        @Override
        public void onResponseComplete() throws IOException {
            this._exchange.setEventListener(this._next);
            this._exchange.setStatus(4);
            AbstractHttpConnection.this._parser.reset();
        }

        @Override
        public void onConnectionFailed(Throwable ex) {
            this._exchange.setEventListener(this._next);
            this._next.onConnectionFailed(ex);
        }

        @Override
        public void onException(Throwable ex) {
            this._exchange.setEventListener(this._next);
            this._next.onException(ex);
        }

        @Override
        public void onExpire() {
            this._exchange.setEventListener(this._next);
            this._next.onExpire();
        }

        @Override
        public void onRetry() {
            this._exchange.setEventListener(this._next);
            this._next.onRetry();
        }
    }

    private class ConnectionIdleTask
    extends Timeout.Task {
        private ConnectionIdleTask() {
        }

        public void expired() {
            if (AbstractHttpConnection.this._idle.compareAndSet(true, false)) {
                AbstractHttpConnection.this._destination.returnIdleConnection(AbstractHttpConnection.this);
            }
        }
    }

    private class Handler
    extends HttpParser.EventHandler {
        private Handler() {
        }

        public void startRequest(Buffer method, Buffer url, Buffer version) throws IOException {
        }

        public void startResponse(Buffer version, int status, Buffer reason) throws IOException {
            HttpExchange exchange = AbstractHttpConnection.this._exchange;
            if (exchange == null) {
                LOG.warn("No exchange for response", new Object[0]);
                AbstractHttpConnection.this._endp.close();
                return;
            }
            switch (status) {
                case 100: 
                case 102: {
                    exchange.setEventListener(new NonFinalResponseListener(exchange));
                    break;
                }
                case 200: {
                    if (!"CONNECT".equalsIgnoreCase(exchange.getMethod())) break;
                    AbstractHttpConnection.this._parser.setHeadResponse(true);
                }
            }
            AbstractHttpConnection.this._http11 = HttpVersions.HTTP_1_1_BUFFER.equals(version);
            AbstractHttpConnection.this._status = status;
            exchange.getEventListener().onResponseStatus(version, status, reason);
            exchange.setStatus(5);
        }

        public void parsedHeader(Buffer name, Buffer value) throws IOException {
            HttpExchange exchange = AbstractHttpConnection.this._exchange;
            if (exchange != null) {
                if (HttpHeaders.CACHE.getOrdinal(name) == 1) {
                    AbstractHttpConnection.this._connectionHeader = HttpHeaderValues.CACHE.lookup(value);
                }
                exchange.getEventListener().onResponseHeader(name, value);
            }
        }

        public void headerComplete() throws IOException {
            HttpExchange exchange = AbstractHttpConnection.this._exchange;
            if (exchange != null) {
                exchange.setStatus(6);
                if ("CONNECT".equalsIgnoreCase(exchange.getMethod())) {
                    AbstractHttpConnection.this._parser.setPersistent(true);
                }
            }
        }

        public void content(Buffer ref) throws IOException {
            HttpExchange exchange = AbstractHttpConnection.this._exchange;
            if (exchange != null) {
                exchange.getEventListener().onResponseContent(ref);
            }
        }

        public void messageComplete(long contextLength) throws IOException {
            HttpExchange exchange = AbstractHttpConnection.this._exchange;
            if (exchange != null) {
                exchange.setStatus(7);
            }
        }

        public void earlyEOF() {
            HttpExchange exchange = AbstractHttpConnection.this._exchange;
            if (exchange != null && !exchange.isDone() && exchange.setStatus(9)) {
                exchange.getEventListener().onException((Throwable)new EofException("early EOF"));
            }
        }
    }
}

