/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nosql.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.util.ClassLoadingObjectInputStream;

public class MongoUtils {
    public static Object decodeValue(Object valueToDecode) throws IOException, ClassNotFoundException {
        if (valueToDecode == null || valueToDecode instanceof Number || valueToDecode instanceof String || valueToDecode instanceof Boolean || valueToDecode instanceof Date) {
            return valueToDecode;
        }
        if (valueToDecode instanceof byte[]) {
            byte[] decodeObject = (byte[])valueToDecode;
            ByteArrayInputStream bais = new ByteArrayInputStream(decodeObject);
            ClassLoadingObjectInputStream objectInputStream = new ClassLoadingObjectInputStream((InputStream)bais);
            return objectInputStream.readUnshared();
        }
        if (valueToDecode instanceof DBObject) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String name : ((DBObject)valueToDecode).keySet()) {
                String attr = MongoUtils.decodeName(name);
                map.put(attr, MongoUtils.decodeValue(((DBObject)valueToDecode).get(name)));
            }
            return map;
        }
        throw new IllegalStateException(valueToDecode.getClass().toString());
    }

    public static String decodeName(String name) {
        return name.replace("%2E", ".").replace("%25", "%");
    }

    public static String encodeName(String name) {
        return name.replace("%", "%25").replace(".", "%2E");
    }

    public static Object encodeName(Object value) throws IOException {
        if (value instanceof Number || value instanceof String || value instanceof Boolean || value instanceof Date) {
            return value;
        }
        if (value.getClass().equals(HashMap.class)) {
            BasicDBObject o = new BasicDBObject();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                if (!(entry.getKey() instanceof String)) {
                    o = null;
                    break;
                }
                o.append(MongoUtils.encodeName(entry.getKey().toString()), MongoUtils.encodeName(entry.getValue()));
            }
            if (o != null) {
                return o;
            }
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.reset();
        out.writeUnshared(value);
        out.flush();
        return bout.toByteArray();
    }

    public static Object getNestedValue(DBObject dbObject, String nestedKey) {
        String[] keyChain = nestedKey.split("\\.");
        DBObject temp = dbObject;
        for (int i = 0; i < keyChain.length - 1; ++i) {
            if ((temp = (DBObject)temp.get(keyChain[i])) != null) continue;
            return null;
        }
        return temp.get(keyChain[keyChain.length - 1]);
    }
}

