/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.descriptor.AbstractExtensionContext;
import org.junit.jupiter.engine.descriptor.TestTemplateTestDescriptor;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineExecutionListener;

final class TestTemplateExtensionContext
extends AbstractExtensionContext<TestTemplateTestDescriptor> {
    private final Object testInstance;

    TestTemplateExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, TestTemplateTestDescriptor testDescriptor, ConfigurationParameters configurationParameters, Object testInstance) {
        super(parent, engineExecutionListener, testDescriptor, configurationParameters);
        this.testInstance = testInstance;
    }

    @Override
    public Optional<AnnotatedElement> getElement() {
        return Optional.of(((TestTemplateTestDescriptor)this.getTestDescriptor()).getTestMethod());
    }

    @Override
    public Optional<Class<?>> getTestClass() {
        return Optional.of(((TestTemplateTestDescriptor)this.getTestDescriptor()).getTestClass());
    }

    @Override
    public Optional<TestInstance.Lifecycle> getTestInstanceLifecycle() {
        return this.getParent().flatMap(ExtensionContext::getTestInstanceLifecycle);
    }

    @Override
    public Optional<Object> getTestInstance() {
        return Optional.ofNullable(this.testInstance);
    }

    @Override
    public Optional<Method> getTestMethod() {
        return Optional.of(((TestTemplateTestDescriptor)this.getTestDescriptor()).getTestMethod());
    }

    @Override
    public Optional<Throwable> getExecutionException() {
        return Optional.empty();
    }
}

