/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jetty.util.TopologicalSort;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.FragmentDescriptor;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.Ordering;

public class RelativeOrdering
implements Ordering {
    protected MetaData _metaData;

    public RelativeOrdering(MetaData metaData) {
        this._metaData = metaData;
    }

    @Override
    public List<Resource> order(List<Resource> jars) {
        TopologicalSort<Resource> sort = new TopologicalSort<Resource>();
        ArrayList<Resource> sorted = new ArrayList<Resource>(jars);
        HashSet<Resource> others = new HashSet<Resource>();
        HashSet<Resource> before_others = new HashSet<Resource>();
        HashSet<Resource> after_others = new HashSet<Resource>();
        for (Resource jar : jars) {
            FragmentDescriptor fragment = this._metaData.getFragment(jar);
            if (fragment == null) {
                others.add(jar);
                continue;
            }
            switch (fragment.getOtherType()) {
                case None: {
                    others.add(jar);
                    break;
                }
                case Before: {
                    before_others.add(jar);
                    break;
                }
                case After: {
                    after_others.add(jar);
                }
            }
        }
        HashSet<Resource> referenced = new HashSet<Resource>();
        for (Resource jar : jars) {
            FragmentDescriptor fragment = this._metaData.getFragment(jar);
            if (fragment != null) {
                for (String name : fragment.getAfters()) {
                    Resource after = this._metaData.getJarForFragment(name);
                    sort.addDependency(jar, after);
                    referenced.add(after);
                }
                for (String name : fragment.getBefores()) {
                    Resource before = this._metaData.getJarForFragment(name);
                    sort.addDependency(before, jar);
                    referenced.add(before);
                }
                switch (fragment.getOtherType()) {
                    case None: {
                        break;
                    }
                    case Before: {
                        Consumer<Resource> add_before = other -> {
                            if (!referenced.contains(other)) {
                                sort.addDependency((Resource)other, jar);
                            }
                        };
                        others.forEach(add_before);
                        after_others.forEach(add_before);
                        break;
                    }
                    case After: {
                        Consumer<Resource> add_after = other -> {
                            if (!referenced.contains(other)) {
                                sort.addDependency(jar, (Resource)other);
                            }
                        };
                        before_others.forEach(add_after);
                        others.forEach(add_after);
                    }
                }
            }
            referenced.clear();
        }
        sort.sort(sorted);
        return sorted;
    }
}

