/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Supplier;

public final class StackUtils {
    /*
     * Enabled aggressive exception aggregation
     */
    public static String toString(Throwable t) {
        try (StringWriter w = new StringWriter();){
            PrintWriter out = new PrintWriter(w);
            try {
                t.printStackTrace(out);
                String string = w.toString();
                out.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return "Unable to get stacktrace for: " + t;
        }
    }

    public static Supplier<String> supply(Throwable t) {
        return () -> StackUtils.toString(t);
    }
}

